/************************************************************************

    CPPREP v1.00 - Replacement for MODE CON CP PREPARE supporting various
                  file formats.

    Copyright (C) 2006  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

/* Main program: Deals with command parsing. */
#include "cpprep.h"

int device = 0;
int verbose = 0;
char *dumpfile = NULL;

static int have_hardware = 0;
static int cpcount = 0;

static void option(char *arg);
static void syntax(void);
static void parse(char *arg, REQUEST *p);

int main(int argc, char **argv)
{
	int n, m, cp;
	REQUEST req;

	for (n = 1; n < argc; n++)
	{
		if (argv[n][0] == '-' || argv[n][0] == '/')
		{
			option(argv[n] + 1);
		}
		else
		{
			parse(argv[n], NULL);
			++cpcount;
		}
	}
	if (!cpcount)
	{
		syntax();
	}
	have_hardware = init_hardware();
	if (!dumpfile && !have_hardware)
	{
		fprintf(stderr, "DISPLAY.SYS not loaded. Codepages cannot "
			"be loaded; you can only use the -D\n"
			"option to generate CPI files.\n");
		exit(1);
	}

	cp = 0;
	init_cpi(cpcount);
	for (n = 1; n < argc; n++)
	{
		if (argv[n][0] != '-' && argv[n][0] != '/')
		{
			int have = 0;
			parse(argv[n], &req);
			set_pageno(cp, req.page);
			for (m = 0; m < 3; m++)
			{
				load_font(cp, req.file[m], &have);
			}
			if (device == 2 && have != 1)
			{
				have = 0;
			}
			if (device != 2 && have != 7) 
				/* EGA, and missing fonts */
			{
				have = extrapolate(cp, have);
				if (have != 7) have = 0;
			}
			if (!have)
			{
				fprintf(stderr, "Cannot generate codepage %d: No font data loaded!\n", req.page);
				exit(1);
			}
			cp++;
		}
	}
	if (dumpfile)
	{
		dump_cpi(dumpfile);
	}
	else
	{
#ifdef __MSDOS__
		/* Now for it */
		install_font(cpcount);
#endif
	}
	free_cpi();
	return 0;
}

static void option(char *arg)
{
	char c = arg[0];
	if (islower(c)) c = toupper(c);
	switch(c)
	{
		case 'D':
			dumpfile = arg + 1;
			break;
		case 'E':
			device = 1;
			break;
		case 'L':
			device = 2;
			break;
		case 'V':
			verbose = 1;
			break;

		case '?':
		case 'H':
			syntax();
		
		default:
			fprintf(stderr, "Unrecognised option: %s\n", arg);
			exit(1);
	}
}

static void syntax(void)
{
	fprintf(stderr, "Syntax:\n\n"
			"CPPREP { options } codepage=file{+file...} ...\n");
	fprintf(stderr, "Options are:\n"
			"-Dfile  Dump output to 'file'\n"
			"-E  Codepage is for EGA/VGA (default)\n"
			"-L  Codepage is for Convertible LCD\n"
			"-V  Verbose\n");
	exit(1);
}


/* Parse an argument. If p is not null, populate it with codepage ID and
 * filename(s). */
static void parse(char *arg, REQUEST *p)
{
	REQUEST q;
	char *s;
	int n;

	if (!p) p = &q;

	p->page = 0xFFFF;
	for (n = 0; n < 3; n++) p->file[n] = NULL;

	if (sscanf(arg, "%u", &p->page) != 1)
	{
		fprintf(stderr, "'%s' does not start with a number.\n"
			"It should be formed 'nnn=filename{+filename...}\n", 
			arg);
		exit(1);
	}
	s = strchr(arg, '=');
	if (!s)
	{
		fprintf(stderr, "'%s' is not formed 'nnn=filename(s)'.\n", 
			arg);
		exit(1);
	}
	/* If the caller doesn't want to know the filename, then 
	 * just return. This is because filename parsing is destructive;
	 * it can only be done once. */
	if (p == &q) return;
	arg = s + 1;
	for (n = 0; n < 3; n++)
	{
		p->file[n] = arg;
		s = strchr(arg, '+');
		if (!s) break;
		*s = 0;
		arg = s + 1;
	}
}



