/* 8000 Plus listing checker (v2) 
 * C conversion of the BASIC program by Adrian Wilkins and Peter Crane
 * in 8000 Plus issue 26, page 64
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int main(int argc, char **argv)
{
	FILE *infile;
	char *filename;
	char line[257];
	int i, j, check;
	int y;

	if (argc < 2) 
	{
		filename = "-";
		infile = stdin;
	}
	else	
	{
		filename = argv[1];
		infile = fopen(filename, "r");
		if (infile == NULL)
		{
			perror(argv[1]);
			return EXIT_FAILURE;
		}
	}
	while (fgets(line, sizeof(line), infile))
	{
		check = j = 0;
		line[256] = 0;
		for (i = 0; line[i]; i++)
		{
			/* Enforce uppercase */	
			y = toupper(line[i]);	
			if (y == '\n' || y == '\r')
			{
				line[i] = 0;
				break;
			}
			/* Ignore spaces */
			if (y == ' ') continue;

			if ((y & 0xFF) == 0xFC)
			{
				fprintf(stderr, "Program was not saved in ASCII mode.\n\nDo the following:\n"
					"  LOAD \"%s\"\n"  
					"  SAVE \"%s\",A\n"
					"and run the checksum program again.", 
					filename, filename);  
				return EXIT_FAILURE;
			}
			j++;
			check = check + (y - ' ') * ((j % 7) + 1);
		}
		if (strlen(line) < 74) printf ("%-74.74s %04x\n", line, check);
		else                   printf ("%s\n%-74.74s %04x\n", 
						line, "", check);
	}
	if (infile != stdin) fclose(infile);
	return EXIT_SUCCESS;
}
