1 ' Label and macro compiler by Simon Forrester
2 ' PCW Plus issue 117, page 19
3 '
10 '#Hairy's label compiler#
20 PRINT CHR$(27);"E";CHR$(27);"H";
30 PRINT "Hairy's textual BASIC compiler"
40 PRINT
50 DIM lb$(1024)
60 DIM wb$(1024)
70 DIM wr(1024)
80 FILES
90 PRINT:PRINT
100 INPUT "Compile:",f$
110 PRINT
120 PRINT "Pass 1 - reading, stripping and label searching"
130 OPEN "I",1,f$
140 lc=1:wc=1
150 WHILE NOT EOF(1)
160 LINE INPUT #1,l$
170 IF LEFT$(l$,1)=" "THEN l$=RIGHT$(l$,LEN(l$)-1):GOTO 170
180 IF RIGHT$(l$,1)=" "THEN l$=LEFT$(l$,LEN(l$)-1):GOTO 180
190 IF l$="" GOTO 270			'Totally blank line
200 IF LEFT$(l$,1)=";" THEN GOTO 270	'Preprocessor comment
210 IF LEFT$(l$,1)="" THEN GOTO 240
215 IF LEFT$(l$,1)="" THEN GOSUB 1000	'Macro substitution
220 lb$(lc)=l$::lc=lc+1			'Store as line
230 GOTO 270
240 l$=RIGHT$(l$,LEN(l$)-1)		'Strip off label identifier
250 IF l$="" THEN GOTO 270
260 wb$(wc)=l$:wr(wc)=lc:wc=wc+1	'Store as label
270 WEND
280 CLOSE #1
290 lc=lc-1
300 wc=wc-1
310 PRINT "Pass 2 - label linking"
320 FOR l=1 TO lc
330 ol$=lb$(l)
340 IF INSTR(ol$,"")=0 THEN nl$=ol$:GOTO 540	'No labels to expand
350 nl$=""
360 FOR c=1 TO LEN(ol$)
370 c$=MID$(ol$,c,1)
380 IF c$<>"" THEN GOTO 520	'No label to substitute
390 c=c+1
400 l$=""
410 IF c>LEN(ol$) THEN GOTO 470
420 c$=MID$(ol$,c,1)
430 IF c$=" " OR c$=":" OR c$="," THEN GOTO 470
440 l$=l$+c$
450 c=c+1
460 GOTO 410
470 FOR w=1 TO wc
480 IF UPPER$(wb$(w))=UPPER$(l$) THEN c$=STR$(wr(w)):c$=RIGHT$(c$,LEN(c$)-1):c=c-1:GOTO 520
490 NEXT w
500 PRINT "Error: Undefined label ";l$;" in line";l
510 c$="[ERROR]"
520 nl$=nl$+c$
530 NEXT c
540 lb$(l)=STR$(l)+" "+nl$
550 NEXT l
560 PRINT
570 PRINT "Operation complete"
580 PRINT
590 PRINT "Lines:";lc
600 PRINT "Labels:";wc
610 PRINT
620 INPUT "Save as:",f$
630 IF f$="" THEN f$="c.bas":PRINT "Default:C.BAS"
640 OPEN "o",1,f$
650 FOR l=1 TO lc
660 PRINT #1,lb$(l)
670 NEXT l
680 CLOSE #1
690 PRINT
700 PRINT "Executing program"
710 RUN f$
999 ' Macro library
1000 RESTORE
1010 READ mn$,mr$
1020 IF mn$="END" THEN RETURN
1030 IF UPPER$(l$)=UPPER$(mn$) THEN l$=mr$:RETURN
1040 GOTO 1010
1050 DATA "CLS",PRINT CHR$(27);"E";CHR$(27);"H";
1060 DATA "KPW","WHILE LEN(INKEY$)=0:WEND"
1070 DATA END,END

