1 ' Mandelbrot Plot by Brian Aird
2 ' 8000 Plus issue 31, pages 61,62
3 ' Plot / Screensave routines by Lawrence Simons; see issues 23, 28, 29
4 '
5 ' Samples made using these parameters:
6 ' mandel1.png: -2    <= X <= 0.5,   -1.25 <= Y <= 1.25, iterations = 40
7 ' mandel2.png: -0.75 <= X <= -0.7,   0.25 <= Y <= 0.3,  iterations = 40 
8 '
10 REM Mandelbrot numbers:- the set of complex numbers
20 REM that can tolerate the iteration of z=z^2+c without the number
30 REM of iterations, I% > t%, whilst the size of z < 2 or z^2 < 4
40 REM line 240 is algorithm, note size of z^2 = a*a + b*b
50 REM c=x+jy, where j = complex operator, -1 and x and y are scaled to
60 REM screen coordinates for each pixel.
70 GOSUB 54000
80 INPUT "Do you wish to (S)ave or (L)oad the graphics screen ";s$
90 IF s$="S" OR s$="s" OR s$="L" OR s$="l" THEN q=-1
100 IF q<>-1 THEN GOTO 80
110 clt$=CHR$(27)+"E"+CHR$(27)+"H":
120 setg$=CHR$(27)+"0"+CHR$(27)+"E"+CHR$(27)+"f"
130 setx$=CHR$(27)+"e"+CHR$(27)+"1"+CHR$(27)+"Y"+CHR$(59)+CHR$(32)
140 IF UPPER$(s$)<>"S" THEN 350
150 INPUT "X MIN ";xmin:INPUT "X MAX ";xmax
160 INPUT"Y MIN ";ymin:INPUT "Y MAX ";ymax:INPUT "MAX NO OF ITERATIONS ";t%
170 INPUT "What name for screen file ";a$
180 IF FIND$(a$)<>"" THEN PRINT "file already exists":GOTO 170
190 a$=a$+CHR$(0)
200 GOSUB 50000:f%=1:PRINT setg$: REM set up plot routine
210 sidex=xmax-xmin:sidey=ymax-ymin: REM scale PCW screen dimensions
220 gapx=sidex/360:x=xmin:gapy=sidey/256:y=ymax:oldi%=0:r%=0:rl%=1
230 FOR y%=255 TO 0 STEP -1:y=y-gapy
240 FOR x%=0 TO 719 STEP 2: x=x+gapx
250 a=0:b=0:i%=0
260 WHILE i%<=t% AND a*a+b*b<=4:z=a*a-b*b+x:b=2*a*b+y:a=z:i%=i%+1:WEND
270 IF i%>t% THEN k=0 ELSE k=i%MOD(3)+1
280 IF k=1 OR k=3 THEN CALL plot (x%,y%,f%)
290 IF k=3 THEN x1%=x%+1:CALL plot (x1%,y%,f%)
300 NEXT:x=xmin:NEXT
310 CALL scrnsave(a$,e%)
320 IF e%<>0 THEN print "screen save error - try again":GOTO 340
330 WHILE INKEY$="":WEND:PRINT setx$:END 'Wait for a key press
340 INPUT "type new file name ";a$:a$=a$+CHR$(0):GOTO 310
350 IF UPPER$(s$)<>"L" THEN END
360 INPUT "What file do you wish to load ";a$
370 a$=a$+CHR$(0)
380 CALL scrnload(a$,e%)
390 IF e%<>0 THEN PRINT "file load error - try again ":GOTO 350
400 GOTO 330
50000 MEMORY &HBFFF:plot=&HC000:A=PLOT:E=0
50010 RESTORE 50120
50020 FOR f=0 TO 14
50030 s=0
50040 FOR G=0 TO 7
50050 READ X$:X=VAL("&H"+X$)
50060 S=S+X:POKE A,X:A=A+1:NEXT
50070 READ X$: IF S<>VAL("&H"+X$) THEN E=E+1:PRINT "Error in Line";10*(F+5012)
50080 NEXT
50090 IF E=0 THEN RETURN
50100 PRINT E;"ERROR";:IF E=1 THEN PRINT ELSE PRINT "S"
50110 STOP
50120 DATA 0A,32,7C,C0,4E,23,46,21,250
50130 DATA CF,02,A7,ED,42,D8,ED,43,4AF
50140 DATA 78,C0,EB,5E,23,56,7A,A7,41B
50150 DATA C0,93,3D,5F,ED,53,7A,C0,469
50160 DATA F3,ED,73,7D,C0,31,9D,C0,51E
50170 DATA 01,36,C0,CD,5A,FC,E9,00,403
50180 DATA ED,7B,7D,C0,FB,C9,2A,7A,50D
50190 DATA C0,29,11,00,B6,19,5E,23,24A
50200 DATA 56,7B,E6,F8,CB,27,CB,12,47E
50210 DATA 47,7B,E6,07,B0,5F,2A,78,360
50220 DATA C0,45,7D,E6,F8,6F,EB,19,4D3
50230 DATA 78,E6,07,3C,47,AF,37,1F,2ED
50240 DATA 10,FD,47,3A,7C,C0,A7,20,391
50250 DATA 05,78,2F,A6,77,C9,3D,78,347
50260 DATA 20,03,B6,77,C9,AE,77,C9,407
54000 REM Set up SCRNSAVE and SCRNLOAD machine-code routines
54010 MEMORY &HBFFF
54020 SCRNSAVE=&HC400:SCRNLOAD=&HC46D:A=SCRNSAVE:E=0
54030 RESTORE 54150
54040 FOR F=0 TO 40
54050 S=0
54060 FOR G=0 TO 7
54070 READ X$:X=VAL("&H"+X$)
54080 S=S+X:POKE A,X:A=A+1
54090 NEXT
54100 READ X$:IF S<>VAL("&H"+X$) THEN E=E+1:PRINT "ERROR IN LINE";10*(F+5415)
54110 NEXT
54120 IF E=0 THEN RETURN
54130 PRINT E;"ERROR";:IF E=1 THEN PRINT ELSE PRINT "S"
54140 END
54150 DATA ED, 73, 4D, C5, 31, 6D, C5, D5, 4AA
54160 DATA CD, DF, C4, CD, 2C, C4, CD, 04, 4FE
54170 DATA C5, AF, F5, 01, 5C, C4, CD, 5A, 4B1
54180 DATA FC, E9, 00, CD, 3C, C4, F1, 3C, 4DF
54190 DATA FE, 20, 38, EE, CD, 4C, C4, 11, 432
54200 DATA 00, 00, 18, 6A, 0E, 16, 11, 5C, 113
54210 DATA 00, CD, 05, 00, 3C, C0, D1, 11, 2B0
54220 DATA 02, 00, 18, 5A, 0E, 15, 11, 5C, 104
54230 DATA 00, CD, 05, 00, A7, C8, D1, 11, 323
54240 DATA 03, 00, 18, 4A, 0E, 10, 11, 5C, 0F0
54250 DATA 00, CD, 05, 00, 3C, C0, D1, 11, 2B0
54260 DATA 04, 00, 18, 3A, CD, 29, C5, EB, 2FC
54270 DATA 11, 6D, C5, 01, D0, 02, ED, B0, 3B3
54280 DATA C9, 3C, 00, 4A, 00, ED, 73, 4D, 2FC
54290 DATA C5, 31, 6D, C5, D5, CD, DF, C4, 56D
54300 DATA CD, B3, C4, CD, 04, C5, AF, F5, 57E
54310 DATA CD, C3, C4, F1, F5, 01, D3, C4, 5D2
54320 DATA CD, 5A, FC, E9, 00, F1, 3C, FE, 537
54330 DATA 20, 38, EC, 11, 00, 00, D5, 0E, 238
54340 DATA 1A, ED, 5B, 49, C5, CD, 05, 00, 342
54350 DATA 0E, 2C, 3A, 4B, C5, 5F, CD, 05, 2B5
54360 DATA 00, D1, E1, 73, 23, 72, ED, 7B, 422
54370 DATA 4D, C5, C9, 0E, 0F, 11, 5C, 00, 265
54380 DATA CD, 05, 00, 3C, C0, D1, 11, 02, 2B2
54390 DATA 00, 18, D3, 0E, 14, 11, 5C, 00, 17A
54400 DATA CD, 05, 00, A7, C8, D1, 11, 03, 326
54410 DATA 00, 18, C3, CD, 29, C5, 21, 6D, 324
54420 DATA C5, 01, D0, 02, ED, B0, C9, 7E, 47C
54430 DATA A7, 28, 1B, 23, 5E, 23, 56, 21, 205
54440 DATA 45, C5, 73, 23, 72, 23, 36, 5C, 2C7
54450 DATA 23, 36, 00, 0E, 98, 11, 45, C5, 21A
54460 DATA CD, 05, 00, 7C, B5, C8, D1, 11, 3AD
54470 DATA 01, 00, 18, A6, 0E, 31, 11, 69, 178
54480 DATA C4, CD, 05, 00, 22, 49, C5, 0E, 2D4
54490 DATA 1A, 11, 6D, C5, CD, 05, 00, 0E, 23D
54500 DATA 31, 11, 6B, C4, CD, 05, 00, 32, 275
54510 DATA 4B, C5, 0E, 2C, 1E, 06, C3, 05, 236
54520 DATA 00, 6F, 26, 00, 29, 29, 29, 29, 139
54530 DATA 11, 00, B6, 19, 5E, 23, 56, 7B, 232
54540 DATA E6, F8, CB, 27, CB, 12, 47, 7B, 46F
54550 DATA E6, 07, B0, 5F, C9, 00, 00, 00, 2C5
