1 ' Quadratic equation solver by John Langley
2 ' 8000 Plus issue 5, page 57
3 ' 
10 PRINT
20 PRINT
30 REM       Program to solve quadratic equations to 2 decimal places.
40 REM
50 PRINT " Equation solver for quadratics of the form ax^2 + bx + c = 0"
60 PRINT "('a', 'b' and 'c' must be real numbers and 'a' mustn't equal 0)"
70 PRINT
80 PRINT "Enter values for 'a', 'b' and 'c', separated by commas."
90 PRINT "Be careful with plus and minus signs. Enter 9999,0,0 to finish."
100 PRINT
110 INPUT a,b,c
120 WHILE a<>9999
130 IF A=0 THEN PRINT "You have entered a=0! Please try again.":GOTO 210
140 REM      Test discriminant b^2-4ac:
150 REM      If b^2-4ac > 0 then there are two different real roots
160 REM      If b^2-4ac = 0 then there are two identical real roots
170 REM      If b^2-4ac < 0 then there are two complex conjugate roots
180 PRINT
190 PRINT
200 ON SGN(b^2-4*a*c)+2 GOSUB 400,360,310
210 PRINT
220 PRINT
230 PRINT "Enter values for 'a', 'b' and 'c', separated by commas."
240 PRINT "Be careful with plus and minus signs. Enter 9999,0,0 to finish."
250 PRINT
260 INPUT a,b,c
270 WEND
280 PRINT "Program terminated."
290 END
300 REM
310 REM      Two different real roots
320 PRINT "The roots are ";ROUND((-b + SQR(b^2 - 4*a*c))/(2*a),2);" and ";
330 PRINT ROUND((-b - SQR(b^2 - 4*a*c))/(2*a),2)
340 RETURN
350 REM
360 REM      Two identical real roots
370 PRINT "The roots are both ";ROUND(-b/(2*a),2)
380 RETURN
390 REM
400 REM      Complex conjugate roots
410 LET X=ROUND(-b/(2*a),2)
420 LET Y=ROUND(SQR(ABS(b^2-4*a*c))/(2*a),2)
430 PRINT "The Roots are complex conjugate:   (";X;"+ i"MID$(STR$(Y),2);
440 PRINT ")  and  (";X;"- i"MID$(STR$(Y),2)")"
450 RETURN
