;       CBIOS88.ASM v.26 matching CBIOS80.ASM v.25 12/15/86
;	DATE:		January 23, 1987 
;
;	NCBIOS88 - 8088 ROM BIOS SIDE OF RP/M CBIOS
;
;------------------------------------------------------------------------
;
;                        (8080)  (Image) (8088)
;	CS =	RCP is at DB00H	 (0980H) (0000H)
;		RDOS	  E300H  (1180H) (0800H)
;		CBIOS80	  F100H  (1F80H) (1600H)
;		COMMON    FA00H  (2880H) (1F00H)
;		CBIOS80   FB00H  (2980H) (2000H)
;		CBIOS88  10000H  (2E80H) (2500H)
;------------------------------------------------------------------------
;		WARMBOOT 1C500H 	 (EA00H) Image of RCP and RDOS  
;------------------------------------------------------------------------
;		DISKBIOS 1DB00H  (5080H)(10000H) VDISK (start of M: disk)
;------------------------------------------------------------------------
;
CBINT	EQU	080H		;Cold Boot Interrupt to CBIOS80
RESET	EQU	00H		;DISK RESET
DSTAT	EQU	01H		;DISK STATUS
READ	EQU	02H		;DISK READ
WRITE	EQU	03H		;DISK WRITE
VERIFY	EQU	04H		;DISK VERIFY
FORMAT	EQU	05H		;DISK FORMAT
VSECSIZ	EQU	0200H		;VIRTUAL DISK SECTOR SIZE
MDISK	EQU	0CH		;VIRTUAL DISK DESIGNATOR = M:
CR	EQU	0DH		;CARRIAGE RETURN
LF	EQU	0AH		;LINE FEED
ESPREFX	EQU	026H		;ES: PREFIX
IOBYTE	EQU	0003H		;RP/M IOBYTE location.
CDISK	EQU	0004H		;RCP current disk in page 0
PDISK	EQU	003DH		;RCP path disk in page 0
ERRFLG	EQU	003EH		;batch error flag in page 0
SUBFLG	EQU	003FH		;submit flag in page 0
;
;
;
	ORG	01F00H		;Common Data Area (8080 address FA00H)
;
;	PC RP/M2 COMMON DATA AREA
;
	JMP	CBIOS88		;CBIOS88 ENTRY POINT
;
VDISK	.BYTE	MDISK		;VIRT DISK SELECT (00=NONE, 13=M:)
VDSKSEG	.WORD	0		;VIRTUAL DISK STARTING SEGMENT
VMAXSEG	.WORD	0		;VIRTUAL DISK END SEGMENT ADDRESS
VDSM	.WORD	0		;MAXIMUM BLOCK NUMBER, VIRT DISK
;
;	DATE-TIME STAMPING CALENDAR/CLOCK
;		Updated via ROM BIOS timer tick processing.
;
YEAR	.BYTE	086H		;BUMPED AT 12 MONTH ROLLOVER
MONTH	.BYTE	005H		;BUMPED EVERY 31 DAYS, RESET AT 13
DAY	.BYTE	014H		;BUMPED EVERY 24 HOURS, RESET AT 32
HOURS	.BYTE	008H		;BUMPED EVERY 60 MINUTES, RESET AT 24
MINUTES	.BYTE	0		;BUMPED EVERY 60 SECONDS, RESET AT 60
SECONDS	.BYTE	0		;BUMPED EVERY SECOND, RESET AT 60
;
TICKSEC	.WORD	0		;TICKS FOR SECONDS COUNTER
TICKMIN	.WORD	0		;TICKS FOR MINUTES COUNTER
TICKS	.WORD	0		;18.2 TICKS/SEC (ROLLS OVER/NOT RESET)
TIMEINT	JMP	TIMER		;INT 01CH COMES HERE 18.2 TIMES/SEC
;
FDSKS	.BYTE	0		;NUMBER OF FLOPPY DRIVES FOR CBIOS80
;
RPMSEG	.WORD	0		;RP/M CODE SEGMENT REGISTER (set by loader)
TERMID	.BYTE	0		;Terminal Emulation I.D. / Control
;
KTRAN	.WORD	KEYBD		;Default Keyboard Translate Table.
;
KMASK	.BYTE	0FFH		;KEYBOARD (CONSOLE) CHARACTER MASK
;
;	Disk Parameter Table
;
DPT:	EQU	$
	.BYTE	0CFH		;step rate time, head unload time
	.BYTE	002H		;head load time, DMA mode
	.BYTE	025H		;wait time to turning motor off
BPRSEC:	.BYTE	002H		;bytes/sector 0=128, 1=256, 2=512
EOTNUM:	.BYTE	009H		;end of track sector number
	.BYTE	02AH		;gap length          
	.BYTE	0FFH		;data length
	.BYTE	050H		;gap length for format
FILCHR:	.BYTE	0E5H		;formatting fill character
	.BYTE	001H		;head settle time
	.BYTE	004H		;motor start time
;
DSKALT:	.BYTE	013H		;Disk Alternate Interrupt 
ALTSW:	.BYTE	00H		;Alternate interrupt switch.
;
ASSIGN:	EQU	$		;Logical to Physical Disk Assignments
	.BYTE	00H		;A
	.BYTE	01H		;B
	.BYTE	FFH		;C
	.BYTE	FFH		;D
	.BYTE	FFH		;E
	.BYTE	FFH		;F
	.BYTE	FFH		;G
	.BYTE	FFH		;H
	.BYTE	FFH		;I
	.BYTE	FFH		;J
	.BYTE	FFH		;K
	.BYTE	FFH		;L
	.BYTE	0CH		;M
	.BYTE	FFH		;N
	.BYTE	FFH		;O
	.BYTE	FFH		;P
;
	.BYTE	0,0
	.BYTE	0,0
	.BYTE	0
;
	.BYTE	'CBIOS88 01-87 v26'
	.BYTE	'(C)86 MicroMethods'
;
	ORG	01F65H
;
KEYSAVE	.BYTE	0	;Translated key saved.
;
RSEID	.BYTE	0	;Resident System Extension Ident (zero = none).
;				01H = SETDISK.COM
;
KEYID	.BYTE	'A'	;Keyboard Ident (A = American, U.S. English)
;
TRMTBL	.WORD	STRTBL	;Terminal Emulation Control Table pointer.
;
COMSTS	.WORD	0	;Serial Communications Port Status
;
;	IOBYTE I/O REDIRECTION TRANSLATION TABLES
;
	ORG	01F6CH
;
CRT1O	EQU	00H	;Console CRT Display Out ordinal.
KEY1I	EQU	01H	;Keyboard In ordinal.
LPT1O	EQU	02H	;Line Printer 1 Out ordinal.
LPT2O	EQU	03H	:Line Printer 2 Out ordinal.
LPT3O	EQU	04H	;Line Printer 3 Out ordinal.
COM1I	EQU	05H	;Communications Port 1 In ordinal.
COM1O	EQU	06H	;Communications Port 1 Out ordinal.
COM2I	EQU	07H	;Communications Port 2 In ordinal.
COM2O	EQU	08H	;Communications Port 2 Out ordinal.
COM1S	EQU	09H	;Communications Port 1 Setup
COM2S	EQU	0AH	:Communications Port 2 Setup
COM1T	EQU	0BH	;Communications Port 1 Test (Status)
COM2T	EQU	0CH	;Communications Port 2 Test (Status)
NULOP	EQU	0FH	;No Operation (bit bucket) ordinal.
;
CONI:	EQU	$	;CONSOLE IN REDIRECTION TABLE
	.BYTE	KEY1I	; 0 = 01H ordinal, Keyboard In
	.BYTE	KEY1I	; 1 = 01H ordinal, Keyboard In
	.BYTE	KEY1I	; 2 = 01H ordinal, Keyboard In
	.BYTE	KEY1I	; 3 = 01H ordinal, Keyboard In
;
CONO:	EQU	$	;CONSOLE OUT REDIRECTION TABLE
	.BYTE	CRT1O	; 0 = 00H ordinal, CRT Display Out
	.BYTE	CRT1O	; 1 = 00H ordinal, CRT Display Out
	.BYTE	CRT1O	; 2 = 00H ordinal, CRT Display Out
	.BYTE	CRT1O	; 3 = 00H ordinal, CRT Display Out
;
RDRI:	EQU	$	;READER IN REDIRECTION TABLE
	.BYTE 	COM1T	; 0 = 0BH ordinal, Comm Port 1 Status.
	.BYTE	COM2T	; 1 = 0CH ordinal, Comm Port 2 Status.
	.BYTE	COM1I	; 2 = 05H ordinal, Comm Port 1 In
	.BYTE	COM2I	; 3 = 07H ordinal, Comm Port 2 In
;
PUNO:	EQU	$	;PUNCH OUT REDIRECTION TABLE
	.BYTE	COM1S	; 0 = 09H ordinal, Comm Port 1 Setup
	.BYTE	COM2S	; 1 = 0AH ordinal, Comm Port 2 Setup
	.BYTE	COM1O	; 2 = 06H ordinal, Comm Port 1 Out
	.BYTE	COM2O	; 3 = 08H ordinal, Comm Port 2 Out
;
LSTO:	EQU	$	;LIST (PRINTER) OUT REDIRECTION TABLE
	.BYTE	LPT1O	; 0 = 02H ordinal, Line Printer 1 Out
	.BYTE	LPT2O	; 1 = 03H ordinal, Line Printer 2 Out
	.BYTE	LPT3O	; 2 = 04H ordinal, Line Printer 3 Out
	.BYTE	CRT1O	; 3 = 00H ordinal, CRT Display Out
;
;
;	TERMINAL EMULATION 
;
TETSEG	.WORD	0		;Terminal Emulation Table Segment
TETOFS	.WORD	STRTBL		;Terminal Emulation Table Offset
NRMATTR	.BYTE	07H		;Initial (normal) attribute byte.
ATTRIB	.BYTE	07H		;Current character attribute byte.
PREVATT	.BYTE	07H		;Previous character attribute byte.
CURSAV	.WORD	0		;Remembered cursor position.
OUTMSK	.BYTE	0FFH		;character out mask.
SHIFT	.BYTE	0		;keyboard shift status (last keyboard read)
SCRLIN	.BYTE	018H		;bottom line = scroll line (line 25 default)
;
;	STRING OUTPUT FROM EXTENDED CHARACTER IN
;
	ORG	01F90H            
;
;Record block table filled in by utility installing string output functions.
;May be byte or word RBT, depending upon contents of VDSK (maximum block no.).
;Because M: disk blocksize fixed to 2K, there are either 8 bytes or 8 words.
;
STRBT	.WORD	0		;byte/word 0 = block with strings 00-0FH
	.WORD	0		;byte/word 1 = block with strings 10-1FH
	.WORD	0		;byte/word 2 = block with strings 20-2FH
	.WORD	0		;byte/word 3 = block with strings 30-3FH
	.WORD	0		;byte/word 4 = block with strings 40-4FH
	.WORD	0		;byte/word 5 = block with strings 50-5FH
	.WORD	0		;byte/word 6 = block with strings 60-6FH
	.WORD	0		;byte/word 7 = block with strings 70-7FH
;
VDSKOFS	.WORD	0100H		;segment offset to first block
VBLKSZ	.WORD	080H		;segment block size
VRCDSZ	.BYTE	08H		;segment record size
;
STRSEG	.WORD	0		;current string segment address
STRINDX	.WORD	0		;index to next byte in string for output
STRCHAR	.BYTE	0		;current string key
RCDOFS	.WORD	0		;calculated record offset
BLKSEG	.WORD	0		;calculated block segment value
CTIME	.WORD	0		;save ticks for pacing string output
INT1CHO	.WORD	0		;save of timer interrupt offset for GODOS
INT1CHS	.WORD	0		;save of timer interrupt segment for GODOS
;
	ORG	01FBFH	
GODOSF	.BYTE	0		;GODOS flag (if nz, return to DOS at warmboot)
;
	ORG	01FD8H	
;
RPMBOOT	JMP	BOOTRPM		;Entry from Loader to boot RP/M2.
DOSDSK	.BYTE	0		;03H = DOSDISK is present
WBSEG	.WORD	0		;Warm Boot Segment Address (setup by loader)
WBTSIZE	.WORD	0806H		;SIZE OF WARM BOOT IMAGE
WBIMAGE	.WORD	0		;OFFSET TO WARM BOOT IMAGE IN 2ND SEG
RCPLOC	.WORD	0		;RCP ADDRESS RECEIVED FROM CBIOS80
;
FADRS	.WORD	0		;FUNCTION ADDRESS SAVE
PRTNO	.WORD	0		;PRINTER NUMBER SELECTED
PSTAT	.BYTE	0		;PRINTER STATUS FROM ROM BIOS
;
HEADSEL	.BYTE	0		;DISK HEAD SELECTED (0-1)
DSKSEL	.BYTE	0		;DISK DRIVE SELECTED
TRKREQ	.WORD	0		;LOGICAL TRACK REQUESTED (0-79)
TRKSEL	.WORD	0		;PHYSICAL TRACK NUMBER (00-27H)
SECREQ	.WORD	0		;LOGICAL SECTOR REQUESTED (00-07H)
SECSEL	.WORD	0		;PHYSICAL SECTOR NUMBER (01-08H)
NUMSEC	.BYTE	1		;NUMBER OF SECTORS TO READ/WRITE
DMASEG	.WORD	0		;DMA SEGMENT REGISTER (set by loader)
DMASET	.WORD	0		;DMA OFFSET ADDRESS SET
DISKOP	.BYTE	READ		;DISK OPERATION (02=READ, 03=WRITE)
DSKSTAT	.BYTE	0		;DISK STATUS RETURNED IN AH
DSKRTRY	.BYTE	0		;RETRY COUNT ON DISK ERROR
DSKERRS	.WORD	0		;CUMULATIVE COUNT OF DISK ERRORS
DERRST	.BYTE	0		;SAVE OF LAST DISK ERROR STATUS
;
KEYRD	.WORD	0		;SCAN CODE AND ASCII LAST READ
;
;
	ORG	02500H
;	
;	8080 REGISTERS ON ENTRY:
DSSAV	.WORD	0		;Save of DS register for exit.
BP8080	.WORD	0		;CBIOS80 STACK POINTER
SP8088	.WORD	0		;CBIOS88 STACK POINTER
AIN	.BYTE	0		;A REGISTER (AL)
BIN	.BYTE	0		;B REGISTER (CH)
CIN	.BYTE	0		;C REGISTER (CL)
DIN	.BYTE	0		;D REGISTER (DH)
EIN	.BYTE	0		;E REGISTER (DL)
HIN	.BYTE	0		;H REGISTER (BH)
LIN	.BYTE	0		;L REGISTER (BL)
;
;	8080 REGISTERS ON EXIT:
AOUT	.BYTE	0		;A REGISTER (AL)
BOUT	.BYTE	0		;B REGISTER (CH)
COUT	.BYTE	0		;C REGISTER (CL)
DOUT	.BYTE	0		;D REGISTER (DH)
EOUT	.BYTE	0		;E REGISTER (DL)
HOUT	.BYTE	0		;H REGISTER (BH)
LOUT	.BYTE	0		;L REGISTER (BL)
FOUT	.BYTE	0		;FLAGS OUT
AHOUT	.BYTE	0		;8088 REGISTER AH CONTENTS
;
;	CBIOS88 ENTRY PARAMETERS
;
;		DH = FUNCTION NUMBER
;		See function for other register usage.
;
;
C88TBL				;CBIOS88 FUNCTIONS JUMP TABLE
	.WORD	BOOTRPM         ; 0 = COLD BOOT
	.WORD	WARM		; 1 = WARM BOOT
	.WORD	STRSTAT		; 2 = KEYBOARD STATUS
	.WORD	STRCHR		; 3 = READ CHARACTER FROM KEYBOARD
	.WORD	CRTOUT		; 4 = SEND CHARACTER TO DISPLAY
	.WORD	PRTOUT		; 5 = LIST CHARACTER TO PRINTER
	.WORD	PUNOUT		; 6 = PUNCH CHARACTER OUT
	.WORD	RDRIN		; 7 = READER CHARACTER IN
	.WORD	SPARE		; 8 = HOME, NOT IMPLEMENTED
	.WORD	SELDSK		; 9 = SELECT DISK DRIVE
	.WORD	SETTRK		; A = SELECT TRACK NUMBER (00-27H)
	.WORD	SETSEC		; B = SELECT SECTOR NUMBER (01-08H)
	.WORD	SETDMA		; C = SET DMA (OFFSET ADDRESS IN SEG)
	.WORD	DSKREAD		; D = READ DISK SECTOR
	.WORD	DSKWRITE	; E = WRITE DISK SECTOR
	.WORD	LSTAT		; F = PRINTER STATUS (LOGICAL)
	.WORD	PLSTAT		;10 = PRINTER STATUS (PHYSICAL)
	.WORD	HDSEL		;11 = SELECT DISK HEAD
	.WORD	PORTIN  	;12 = IN FROM PORT   
	.WORD	PORTOUT		;13 = OUT TO  PORT    
	.WORD	SPARE		;14 = NOT IMPLEMENTED
	.WORD	SPARE		;15 = NOT IMPLEMENTED
	.WORD	SPARE		;16 = NOT IMPLEMENTED
	.WORD	SPARE		;17 = NOT IMPLEMENTED
	.WORD	SPARE		;18 = NOT IMPLEMENTED
	.WORD	SPARE		;19 = NOT IMPLEMENTED
	.WORD	DPTMOD		;1A = DPT MODIFICATION
	.WORD	GODOS		;1B = GODOS, TERMINATE RP/M & RET TO DOS
	.WORD	VCH  		;1C = VIDEO CLEAR SCREEN/HOME CURSOR
	.WORD	MEMMOV		;1D = MEMORY MOVE
	.WORD	UNLOCK		;1E = UNLOCK TO EXECUTE INTERRUPT
	.WORD	INTRPT		;1F = EXECUTE INTERRUPT
;
CBIOS88:			;SAVE ENTRY REGISTERS
	PUSH	DS	
	PUSH	CS
	POP	DS		;Get DS from CS
	MOV	SP8088,SP	;SAVE CBIOS88 STACK POINTER
	MOV	BP8080,BP	;SAVE CBIOS80 STACK POINTER
	MOV	AIN,AL		;A REGISTER (AL)
	MOV	BIN,CH		;B REGISTER (CH)
	MOV	CIN,CL		;C REGISTER (CL)
	MOV	DIN,DH		;D REGISTER (DH)
	MOV	EIN,DL		;E REGISTER (DL)
	MOV	HIN,BH		;H REGISTER (BH)
	MOV	LIN,BL		;L REGISTER (BL)
	POP	BX
	MOV	DSSAV,BX	;Save DS register for exit.
;
	MOV	BX,OFFSET C88TBL	;JUMP TABLE ADDRESS
	MOV	AH,0
	MOV	AL,DH		;AX = FUNCTION NUMBER
	AND	AX,01FH		;MASK FUNCTION TO TABLE RANGE
	SHL	AX		;MULTIPLY BY TWO
	ADD	BX,AX		;ADD TO JUMP TABLE ADDRESS
	MOV	FADRS,BX	;SAVE IT
	JMP	[BX]		;JUMP TO FUNCTION
;
EXIT:	MOV	AOUT,AL		;SAVE REGISTERS ON EXIT
	MOV	BOUT,CH
	MOV	COUT,CL
	MOV	DOUT,DH
	MOV	EOUT,DL
	MOV	HOUT,BH
	MOV	LOUT,BL
	MOV	AHOUT,AH
	LAHF			;GET FLAGS
	MOV	FOUT,AH		;FOR EXIT RECORD
	MOV	BP,BP8080	;RESTORE CBIOS80 STACK POINTER
;
SPARE:				;FUNCTION NOT IMPLEMENTED
;
	MOV	BYTE PTR LOCK,0		;LOCK INTERRUPT FUNCTION
;
UNLOCKX:			;UNLOCK INTERRUPT FUNCTION EXIT
;
	MOV	DS,DSSAV	;Restore DS for exit.
	NOP
	NOP
	NOP			;so no D8H-DFH within 6 bytes of RETI
	NOP
	NOP
	NOP
	.BYTE	0CFH		;RETI INSTRUCTION
	.BYTE	0		
;
;	BOOTRPM - Entry from Loader to Cold Boot PC RP/M2
;                 Gets here via long jump from loader.
;
BOOTRPM:	EQU	$
		PUSH	DS		;save DS
		PUSH	CS		;temp DS same as CS
		POP	DS
		MOV	AX,RPMSEG	;set up segment address
		MOV	GODOSEG,AX	;for GODOS far jump to INT 20H.
		MOV	AX,0
		MOV	ES,AX		;set ES to segment zero
		.BYTE	ESPREFX
		.BYTE	0A1H		;MOV AX,
		.WORD	INT78		;WORD PTR INT78
		MOV	DPTVEC,AX	;save original dpt vector for GODOS
		.BYTE	ESPREFX
		.BYTE	0A1H		;MOV AX,
		.WORD	INT78+2		;WORD PTR INT78+2
		MOV	DPTVEC+2,AX
		MOV	AX,OFFSET DPT
		MOV	DI,AX		;destination offset for dpt move
		.BYTE	ESPREFX
		MOV	INT78,AX	;set vector to our own DPT
		PUSH	CS
		POP	AX
		.BYTE	ESPREFX
		MOV	INT78+2,AX
		NOP
		NOP
		NOP
		MOV	CX,11		;move 11 byte dpt table to cda
		PUSH	CS
		POP	ES		;set ES to destination segment
		MOV	SI,DPTVEC	;source table offset
		PUSH	DS		;save DS
		MOV	AX,DPTVEC+2	;source segment
		MOV	DS,AX
		CALL	MOVBYT		;move disk parm table
		POP	DS		;restore DS
		MOV	BYTE PTR BPRSEC,002H	;set 512 byte sector
		MOV	BYTE PTR EOTNUM,009H	;set 9 sectors/track
		MOV	BYTE PTR FILCHR,0E5H	;set format fill character
		MOV	AX,RPMSEG	;determine if running under DOS
		CMP	AX,0060H	;stand-alone segment
		JZ	BOOT80		;if running stand-alone
		PUSH	DS		;Disable DOS CTRL-C for DOSTERM
		MOV	AH,25H		;set interrupt vector via DOS
		MOV	AL,23H		;DOS INT 23H
		MOV	DX,TETSEG	;segment address
		MOV	DS,DX		;to DS
		MOV	DX,OFFSET IRETX	;offset to IRET instruction
		INT	21H		;set INT 23H to IRETX in CBIOS88
		POP	DS		;DOS restores INT 23H at PGM TERM
		NOP
		NOP
		NOP
BOOT80:		EQU	$
		NOP
		NOP
		NOP
		POP	DS		;restore DS
		.BYTE	0FH,0FFH	;BRKEM instruction
		.BYTE	CBINT		;INT 80 to CBIOS80
;
;	GODOS - Entry here from RETEM instruction in GODOS.COM program.
;
GODOS:		EQU	$
		PUSH	CS
		POP	DS		;set DS to this segment
		MOV	AX,0
		MOV	ES,AX		;set ES to segment zero
		MOV	AX,DPTVEC	;restore original DPT vector
		.BYTE	ESPREFX
		MOV	INT78,AX
		MOV	AX,DPTVEC+2
		.BYTE	ESPREFX
		MOV	INT78+2,AX
		NOP
		NOP
		NOP
		MOV	AX,RPMSEG	;set ES to RP/M segment
		MOV	ES,AX
		.BYTE	ESPREFX
		MOV	BYTE PTR 0040H,0CDH	;set INT 20 at 0040H in TPA
		.BYTE	ESPREFX
		MOV	BYTE PTR 0041H,020H
		NOP
		NOP
		NOP
		.BYTE  	0EAH		;Far Jump to INT 20H at 0040H in TPA
		.WORD	0040H		;IP = 0040H in TPA
GODOSEG:	.WORD	0		;CS = RPM segment. 
		HLT			;Should never get here.
;
INT78:		EQU	0078H		;vector pointing to disk parm table
DPTVEC:		.WORD	0		;original dpt vector (offset)
		.WORD	0		;   "      "    "    (segment)   
;
;	DPTMOD - Function 1AH (DH register)
;		Entry H&L (BX) contains modification to disk parm table.
;
DPTMOD:		EQU	$
		MOV	BH,HIN		;H register in
		MOV	BL,LIN		;L register in
		MOV	BPRSEC,BX	;modify disk parm table
		JMP	EXIT
;
;
;	WARM BOOT - Entry from CBIOS80 with D (DH) = 01H
;		Brings in copy of RCP and RDOS from 2nd memory segment.
;		Entry:  RCP address in B (CH) and C (CL)
;
WARM:	EQU	$
	TEST	BYTE PTR GODOSF,0FFH	;test return to DOS flag
	JZ	WARM1		;not set - continue warmboot
	JMP	GODOS		;if set, return to DOS
WARM1:	EQU	$
     	MOV	TETSEG,DS	;DS is terminal emulation table segment.
	MOV	AX,WBSEG	;WARMBOOT IMAGE SEGMENT ADDRESS
	MOV	ES,AX
	MOV	RCPLOC,CX	;RCP LOCATION FROM CBIOS80
	MOV	DI,CX		;TO DESTINATION INDEX FOR MOVE
	MOV	CX,WBTSIZE	;BYTE COUNT OF WARM BOOT IMAGE
	MOV	SI,WBIMAGE	;START OF WARMBOOT IMAGE
;
MMV:	PUSH	DS		;Save DS
	.BYTE	ESPREFX		;ES: PREFIX
	MOV	AL,[SI]		;GET AND
	MOV	DS,RPMSEG	;RPM segment address to DS
	MOV	[DI],AL		;STORE BYTE
	POP	DS		;Restore DS
	INC	SI		;BUMP SOURCE ADDRESS
	INC	DI		;BUMP DESTINATION ADDRESS
	DEC	CX		;DECREMENT BYTE COUNT
	JNZ	MMV		;LOOP FOR BYTE COUNT
;
	JMP	EXIT		;RETURN TO CBIOS80
;
;
;	KEYSTAT - Entry from CBIOS80 with D (DH) = 02H
;		Get console (keyboard) input status.
;		Exit:	A (AL) = FF if character is available.
;				= 00 if no key pressed.
;	
STRSTAT:	EQU	$
	MOV	AX,STRSEG	;Get string segment address, if any.
	AND	AX,AX		
	JZ	KEYSTAT		;none - continue.
	MOV	AX,CTIME	;get character ticks from last time
	CMP	TICKS,AX	;wait for change to pace string output
	JZ	KEYSTAT		;not changed yet - do normal keyboard status
	JMP	KEYRDY		;simulate ready status for string output.
;
KEYSTAT:	EQU	$
	MOV	AX,RPMSEG	;Get RP/M segment address
	MOV	ES,AX     
	.BYTE	ESPREFX		;ES: Prefix
	.BYTE	08BH,016H	;MOV DX,[IOBYTE]
	.WORD	IOBYTE		;address of IOBYTE
	AND	DX,0003H	;mask console bits
	JZ	KEYST1		;not redirected
	DEC	DX		;0 = COM1, 1 = COM2
	MOV	AH,3		;serial port status request
	INT	014H		;to ROM BIOS
	AND	AH,01H		;test if character is ready
	JMP	KEYST2		;join common code
KEYST1:	EQU	$
	MOV	AH,01H		;GET KEYBOARD STATUS
	INT	016H		;VIA ROM BIOS
KEYST2:	EQU	$
;	ZERO FLAG = 0 IF CHARACTER READY (NON ZERO)
	JNZ	KEYRDY		;IF CHARACTER READY
	MOV	AL,0		;NO KEY IS PRESSED
	JMP	EXIT
KEYRDY:	MOV	AL,0FFH		;CHARACTER IS READY
	JMP	EXIT
;
;	KEYIN - Entry from CBIOS80 with D (DH) = 03H
;		Gets next keyboard character into A (AL).
;		Exit:	A (AL) = Next Character.
;			ASCII RETURNED (01-7FH)
;			EXTENDED CODES (80-FFH)
;
STRCHR:	EQU	$
	MOV	AX,TICKS	;Save ticks time for this character.
	MOV	CTIME,AX	;to pace string output
	MOV	AX,STRSEG	;Get segment of string output, if any.
	AND	AX,AX
	JZ	KEYIN		;no string for output
	MOV	ES,AX
	MOV	SI,STRINDX	;get index to string byte
	.BYTE	ESPREFX		;ES: prefix
	MOV	AX,[SI]		;pick up next two characters
	OR	AH,AH		;test look-ahead/next character.
	JZ	STRCHZ		;look-ahead character is end of string
	INC	SI		;bump index to next string character
	AND	SI,0FFH		;mask index to 128 positions
	JNZ	STRCHR1		;update index for next character
STRCHZ:	MOV	SI,0		;if end of string, clear pointers
	MOV	STRSEG,SI	;clear string segment address
STRCHR1:	EQU	$
	MOV	STRINDX,SI	;update or clear string index
	CMP	AL,07FH		;is string char extended code?
	JA	SETSTR		;yes - chain to next string, if any
	JMP	KEYIN3		;return string character to caller
;
KEYIN:	EQU	$
	MOV	CL,0		;IOBYTE shift count.
	MOV	DI,OFFSET CONI	;Console In Redirection Table Address
	JMP	REDIR		;go check if any redirection.
;
KEYIN1:	EQU	$		;from redirection dispatch.
	CALL	GETCHR		;Read Keyboard
	CMP	AL,0		;CHECK EXTENDED CODE
	JNZ	KEYIN0		;NO - RETURN ASCII CODE
	MOV	AL,AH		;MOVE SCAN CODE TO AL
	OR	AL,080H		;SET EXTENDED CODE BIT
KEYIN0:	MOV	AHOUT,AH	;SAVE AH - SCAN CODE
	MOV	BX,KTRAN	;Address of Keyboard Translate Table
KEYINL:	MOV	CX,[BX]		;PICK UP TABLE ENTRY LOOP
	AND	CX,CX		;SEE IF AT END OF TABLE
	JZ	KEYIN5		;yes, exit table loop
KEYIN4:	EQU	$
	CMP	CL,AL		;SEE IF MATCH IN TABLE
	JZ	KEYPADR		;YES - TRANSLATE IT
	INC	BX		;NO - BUMP TO NEXT ENTRY
	INC	BX
	JMP	KEYINL		;LOOP TO END OF TABLE
;
KEYPADR	JMP	KEYPAD		;Go check if keypad numbers before translate.
KEYIN3R	JMP	KEYIN3
;
KEYIN2:	MOV	AL,CH		;GET CONVERTED CHAR IN A (AL)
	CALL	CKSHIFT		;Do special processing for caps lock.
;
KEYIN5:	MOV	KEYSAVE,AL	;save translated key code
	CMP	AL,000H		;null,    Alt-131 (083H)
	JZ	SETSTR
	CMP	AL,07FH		;delete,  Alt-211 (0D3H)
	JZ	SETSTR
	CMP	AL,010H		;PrtSc,   Alt-242 (0F2H)
	JZ	SETSTR	
       	CMP	AL,080H		;check if extended character
	JB	KEYIN3R		;no - normal ASCII, continue
;
SETSTR:	MOV	BX,STRBT	;do we have a string file?
	AND	BX,BX
	JZ	KEYIN3R		;no
	CMP	AL,000H		;null,    Alt-131 (083H)
	JNZ	SET1
	MOV	AL,083H		;yes, sub IBM null code
	JMP	SETSTR1
SET1:	CMP	AL,07FH		;delete,  Alt-211 (0D3H)
	JNZ	SET2
	MOV	AL,0D3H		;yes, sub IBM delete code
	JMP	SETSTR1
SET2:	CMP	AL,010H		;PrtSc,   Alt-242 (0F2H)
	JNZ	SETSTR1
	MOV	AL,0F2H		;yes, sub IBM PrtSc code
SETSTR1:	EQU	$
	MOV	STRCHAR,AL	;yes
	AND	AX,070H		;mask extended char ordinal value
	TEST	WORD PTR VDSM,0FF00H	;see if word or byte RBT
	JZ	SETSTR2		;byte RBT
	MOV	CL,3		;word RBT
	JMP	SETSTR3
SETSTR2:	EQU	$
	MOV	CL,4
SETSTR3:	EQU	$
	SHR	AX,CL		;ordinal to block in the RBT
	MOV	SI,OFFSET STRBT	;pointer to RBT setup by utility
	ADD	SI,AX		;address of block with string we want
	TEST	WORD PTR VDSM,0FF00H	;see if word or byte RBT
	JNZ	SETSTR4		;word RBT
	MOV	BL,[SI]		;byte RBT
	MOV	BH,0
	JMP	SETSTR5
SETSTR4:	EQU	$
	MOV	BX,[SI]		;pick up the block number
SETSTR5:	EQU	$
	MOV	AX,VBLKSZ	;virtual disk block size
	MUL	AX,BX		;calculate block segment
	MOV	BLKSEG,AX	;save it
	MOV	AH,STRCHAR	;get string key value again
	AND	AH,0FH		;mask ordinal to record in the block
	MOV	AL,VRCDSZ	;record size (128 bytes)
	MUL	AL,AH		;calculate offset to record, result in AX
	MOV	RCDOFS,AX	;save it
	ADD	AX,VDSKOFS	;calculate string segment address
	ADD	AX,BLKSEG
	ADD	AX,VDSKSEG
	MOV	STRSEG,AX	;and setup for string output
	MOV	STRINDX,0	;initialize string byte index.
	MOV	ES,AX
	MOV	SI,0
	.BYTE	ESPREFX
	MOV	AH,[SI]		;do we have a string there
	AND	AH,AH
	JZ	SETSTR0 	;no string, just return key read
	JMP	STRCHR		;finally, go output the first character.   
;
SETSTR0:	EQU	$
	MOV	STRSEG,0	;no string, zero string segment
	MOV	AL,KEYSAVE 	;pick up translated key code that was saved
;
KEYIN3:	MOV	AH,AHOUT	;RESTORE AH
	AND	AL,KMASK	;MASK CHARACTER FOR CBIOS80
	JMP	EXIT		;RETURN CHARACTER IN A (AL)
;
;
GETCHR:	EQU	$
	MOV	AH,02H		;GET SHIFT STATUS OF KEYBOARD
	INT	016H		;VIA ROM BIOS
	MOV	BYTE PTR SHIFT,AL	;SAVE IT
	MOV	AH,0		;READ BYTE FROM KEYBOARD
	INT	016H		;VIA ROM BIOS
	MOV	KEYRD,AX	;SAVE AH SCAN CODE, AL ASCII CHAR
	RET			;HAS CHARACTER IN A (AL)
;
;	CRTOUT - CONSOLE CHARACTER OUT TO DISPLAY
;		Entry from CBIOS80 with D (DH) = 04H
;		   and C (CL) has the ASCII character.
;
CRTOUT:	EQU	$
	MOV	CL,0		;IOBYTE shift count
	MOV	DI,OFFSET CONO	;Console Out Redirection Table Address
	JMP	REDIR		;go check if any redirection requested.
;
CRTOUT3:	EQU	$	;back from redirection, if any.
	MOV	AH,0EH		;ROM BIOS TTY write character.
	MOV	BH,0		;DISPLAY PAGE ZERO
	MOV	CX,1		;ONE CHARACTER
	MOV	AL,CIN		;THE CHARACTER FROM CBIOS80
	AND	AL,OUTMSK	;Mask output character.
	INT	010H		;VIDEO DRIVER VIA ROM BIOS
CRTOUTX:	EQU	$	;exit from terminal emulation.
	MOV	CL,CIN		;PRESERVE CHARACTER SENT
	JMP	EXIT
;
;	PRTOUT - LIST CHARACTER TO THE PRINTER
;		Entry from CBIOS80 with D (DH) = 05H
;		  and C (CL) has the ASCII character.
;
PRTOUT:	EQU	$		;check redirection, if any
	MOV	CL,6		;IOBYTE shift count
	MOV	DI,OFFSET LSTO	;Printer Redirection Table Address
	JMP	REDIR		;go check if redirection requested.
;
LPT1OT:	EQU	$		;character out to LPT1
	MOV	WORD PTR PRTNO,0	;address Line Printer 1
	JMP	PRINT		;do it
;
LPT2OT:	EQU	$		;character out to LPT2
	MOV	WORD PTR PRTNO,1	;address Line Printer 2
	JMP	PRINT		;do it
;
LPT3OT:	EQU	$		;character out to LPT3
	MOV	WORD PTR PRTNO,2	;address Line Printer 3
;
PRINT:	EQU	$
	CALL	PRSTAT		;Get printer status via ROM BIOS.
	AND	AH,090H		;MASK FOR STATUS CHECK
	CMP	AH,090H		;READY AND SELECTED
	JNZ	PRTOUT		;LOOP UNTIL READY
;
	MOV	AH,0		;ROM BIOS PRINTER CHARACTER OUT
	MOV	DX,PRTNO	;selected printer number
	MOV	AL,CIN		;GET CHARACTER TO BE PRINTED
	AND	AL,OUTMSK	;Mask output character.
	INT	017H		;VIA ROM BIOS
	JMP	EXIT
;
;	LSTAT - LIST (PRINTER) LOGICAL STATUS REQUEST
;		Entry from CBIOS80 with D (DH) = 0FH
;		Exit with printer status in A register (AL).
;			A = 00 IF NOT READY
;			  = FF WHEN READY
;
LSTAT:	CALL	PRSTAT		;GETS PRINTER STATUS BACK IN AH
	CMP	AH,090H		;SEE IF SELECTED AND READY
	JZ	LSTAT1
	MOV	AL,0		;PRINTER NOT READY
	JMP	EXIT
LSTAT1:	MOV	AL,0FFH		;PRINTER READY
	JMP	EXIT
;
;	PLSTAT - PHYSICAL LIST (PRINTER) STATUS FOR CBIOS80
;		Entry from CBIOS80 with D (DH) = 10H
;		Exit with physical printer status in A (AL).
;
PLSTAT:	CALL	PRSTAT		;get physical printer status
	JMP	EXIT		;back to CBIOS80
;
PRSTAT:	MOV	AH,02H		;ROM BIOS PRINTER STATUS REQUEST
	MOV	DX,PRTNO	;Get printer number selected.
	INT	017H		;ROM BIOS PRINTER DRIVER
	MOV	PSTAT,AH	;SAVE STATUS BACK
	MOV	AL,AH		;status in A (AL) for CBIOS80.
	RET
;
;	SELDSK - SELECT DISK DRIVE
;		Entry from CBIOS80 with D (DH) = 09H
;		Entry, C (CL) has the disk drive number.
;
SELDSK:	MOV	DSKSEL,CL	;SET SELECTED DISK DRIVE
	JMP	EXIT
;
;	HDSEL - SET HEAD NUMBER (DISK SIDE)
;		Entry from CBIOS80 with D (DH) = 11H
;		Entry, C (CL) has the head number.
;			00H = side 1,  01H = side 2
;
HDSEL:	MOV	HEADSEL,CL	;Set selected head number.
	JMP	EXIT
;
;	SETTRK - SET TRACK NUMBER
;		Entry from CBIOS80 with D (DH) = 0AH
;		Entry, B (CH) and C (CL) have track number (00-27H)
;
SETTRK	MOV	TRKREQ,CX	;Save track requested for VDISK.
	MOV	TRKSEL,CX	;Set selected track.
	JMP	EXIT
;
;	SETSEC - SET SECTOR NUMBER
;		Entry from CBIOS80 with D (DH) = 0BH
;		Entry, B (CH) and C (CL) have sector number (01-08)
;
SETSEC:	MOV	SECSEL,CX	;Set selected physical sector number.
	DEC	CX		;Convert physical to logical sector #.
	MOV	SECREQ,CX	;Set logical sector number for VDISK.
	JMP	EXIT
;
;	SETDMA - SET DISK MEMORY ADDRESS (BUFFER ADDRESS)
;		Entry from CBIOS80 with D (DH) = 0CH
;		Entry, B (CH) and C (CL) has buffer address.
;
SETDMA:	MOV	DMASET,CX	;SET DMA (BUFFER ADDRESS)
	JMP	EXIT
;
;	DSKREAD - READ DISK SECTOR
;		Entry from CBIOS80 with D (DH) = 0DH
;		Entry, Disk, Track, Sector, DMA previously set.
;
DSKREAD:
	MOV	AH,READ		;READ DISK SECTOR
	MOV	DISKOP,AH
	JMP	DISKIO
;
;	DSKWRITE - WRITE DISK SECTOR
;		Entry from CBIOS80 with D (DH) = 0EH
;		Entry, Disk, Track, Sector, DMA previously set.
;
DSKWRITE:
	MOV	AH,WRITE	;WRITE DISK SECTOR
	MOV	DISKOP,AH
	JMP	DISKIO
;
;	DISKIO - SETUP AND CALL ROM BIOS FOR DISK I/O
;
DISKIO:	MOV	DSKRTRY,0AH	;INITIALIZE DISK ERROR RETRY COUNT
	MOV	ALTSW,00H	;and alternate interrupt switch
;
	MOV	AL,DSKSEL	;SEE IF VIRTUAL DISK SELECTED
	OR	AL,AL		;CANNOT BE THE A: DRIVE
	JZ	DISK1		;A: DRIVE, DO DISK I/O
	CMP	AL,VDISK	;MAY BE VIRTUAL DISK
	JNZ	DISK1		;NO - DO DISK I/O
	JMP	VDISK1		;YES - DO VIRTUAL DISK OPERATION
;
DISK1:	MOV	AH,DISKOP	;01H = READ, 02H = WRITE
	MOV	AL,NUMSEC	;NUMBER OF SECTORS (SET TO ONE)
	MOV	CH,TRKSEL	;TRACK SELECTED (00-27H)
	MOV	CL,SECSEL	;SECTOR SELECTED (01-08H)
	MOV	DH,HEADSEL	;HEAD SELECTED (00-01H)
	CMP	BYTE PTR DSKINT,082H
	JZ	DISK82		;head byte OK for our own disk code
	AND	DH,01H		;adjust head byte for ROM BIOS code
DISK82:	EQU	$
	MOV	DL,DSKSEL	;DISK DRIVE SELECTED (00-03H now)
;
	MOV	ES,DMASEG	;DMA BUFFER SEGMENT 
	MOV	BX,DMASET	;DMA BUFFER OFFSET
;
	INT	082H		;DISK BIOS INTERRUPT (originally 13H)
DSKINT:	EQU	$-1
;
	MOV	DSKSTAT,AH	;SAVE DISK STATUS RETURNED
	CMP	AH,0		;CHECK STATUS
	JZ	DISKX		;GOOD
;
	MOV	DERRST,AH	;SAVE ERROR STATUS
;
	MOV	AH,RESET	;RESET THE DISK
	INT	082H		;DISK BIOS INTERRUPT (originally 13H)
RSTINT:	EQU	$-1
;
	ADD	DSKERRS,01H	;INCREMENT ERROR COUNT
	SUB	DSKRTRY,01H	;DECREMENT RETRY COUNT
	JNS	DISK1		;GO RETRY DISK OPERATION
;
	TEST	BYTE PTR ALTSW,0FFH	;have we tried both interrupts?
	JNZ	DISKX			;yes - exit
;
	MOV	AL,DSKALT	;get alternate disk interrupt number
	MOV	AH,DSKINT	;save current as new alternate
	MOV	DSKALT,AH
	MOV	DSKINT,AL	;try alternate interrupt
	MOV	RSTINT,AL
	MOV	ALTSW,AL	;set trying alternate int switch
	MOV	DSKRTRY,0AH	;re-initialize retry count
	JMP	DISK1		;go try the operation with alt interrupt
;
DISKX:	MOV	AL,DSKSTAT	;RETURN STATUS TO CALLER IN REG A
	MOV	BYTE PTR ALTSW,00H	;reset alternate interrupt switch
	JMP	EXIT
;
;
;	VDISK1 - VIRTUAL DISK OPERATION
;		Entry from DISKIO if drive # matches virtual disk.
;
VDISK1:	PUSH	DS		;PRESERVE DS OVER VIRT DISK OPERATION
	MOV	AH,TRKREQ	;TRACK REQUESTED BY CBIOS80
	MOV	AL,SECREQ	;LOGICAL SECTOR NUMBER REQUESTED
	MOV	CL,5		;SECTOR*32 = SEGMENT LOCATION
	SHL	AL,CL
	ADD	AX,VDSKSEG	;ADD STARTING SEGMENT
	MOV	VSEG,AX		;ACTUAL SEGMENT OF THIS SECTOR
	CMP	AX,VDSKSEG	;CHECK SECTOR ABOVE STARTING SEGMENT
	JC	VERROR		;No - return error status.
	CMP	AX,VMAXSEG	;CHECK IF SEGMENT IN AVAIL MEMORY
	JC	VDISK3		;YES
;
VERROR:	MOV	ERVSEG,AX	;SAVE ERROR SEGMENT (SECTOR) ADDRESS
	MOV	AL,04H		;NO - SET SECTOR NOT FOUND ERROR
	JMP	VDISKX		;AND EXIT
;
VDISK3:	MOV	CX,VSECSIZ	;VIRTUAL SECTOR SIZE TO MOVE
;
	MOV	AH,DISKOP	;DETERMINE READ OR WRITE
	CMP	AH,WRITE
	JNZ	VREAD
;
VWRITE:	MOV	ES,VSEG		;VDISK SECTOR TO WRITE
	MOV	DI,0		;OFFSET ZERO
	MOV	SI,DMASET	;FROM DMA THAT WAS SET
	MOV	DS,DMASEG
	CALL	MOVBYT		;DO THE MEMORY MOVE
	MOV	AL,00H		;SET GOOD STATUS
	JMP	VDISKX
;
VREAD:	MOV	ES,DMASEG	;TO DMA THAT WAS SET
	MOV	DI,DMASET
	MOV	SI,0		;FROM VDISK SECTOR TO READ
	MOV	DS,VSEG
	CALL	MOVBYT		;DO THE MEMORY MOVE
	MOV	AL,00H		;SET GOOD STATUS
;
VDISKX:	POP	DS		;RESTORE DS
	JMP	EXIT		;DONE
;
;	MEMMOV - MEMORY MOVE FUNCTION (DH=01DH)
;		Entry, H(BH) and L(BL) point to 5-word array:
;		   /From Offset/Segment/To Offset/Segment/Byte Count/
;
MEMMOV:
	PUSH	DS		;PRESERVE DS OVER THIS FUNCTION
	MOV	BH,HIN		;GET ARRAY POINTER IN SI
	MOV	BL,LIN	
	MOV	SI,BX
	MOV	DI,OFFSET FROFS	;POINTER TO WORK AREA
	MOV	CX,5		;ARRAY WORD COUNT
	MOV	AX,RPMSEG	;Array comes from RPM segment
	MOV	SSEG,AX
	MOV	DSEG,DS
	CALL	MOVARRAY	;MOVE ARRAY TO WORK AREA
;
	MOV	SI,FROFS	;FROM OFFSET ADDRESS
	MOV	ES,TOSEG	;DESTINATION SEGMENT
	MOV	DI,TOOFS	;TO OFFSET ADDRESS
	MOV	CX,BYTCNT	;CHECK VALID BYTECOUNT
	OR	CX,CX
	JZ	MOVX		;NOTHING TO MOVE
	MOV	DS,FRSEG	;SOURCE SEGMENT (LOAD DS LAST THING)
	CALL	MOVBYT		;DO THE MEMORY MOVE
;
MOVX:	POP	DS		;RESTORE DS
	JMP	EXIT		;DONE
;
;
MOVBYT:	MOV	AL,[SI]		;GET BYTE
	.BYTE	ESPREFX		;ES: PREFIX
	MOV	[DI],AL		;PUT BYTE
	INC	SI		;BUMP POINTERS
	INC	DI
	DEC	CX		;DECREMENT COUNT
	JNZ	MOVBYT		;LOOP FOR BYTE COUNT
	RET			;DONE
;
VSEG	.WORD	0		;CURRENT VIRTUAL DISK SECTOR (SEGMENT)
ERVSEG	.WORD	0		;ERROR VIRTUAL SECTOR ADDRESS
;
FROFS	.WORD	0		;SOURCE OFFSET
FRSEG	.WORD	0		;SOURCE SEGMENT
TOOFS	.WORD	0		;DESTINATION OFFSET
TOSEG	.WORD	0		;DESTINATION SEGMENT
BYTCNT	.WORD	0		;BYTE COUNT
;
;	UNLOCK - UNLOCKS THE INTERRUPT EXECUTE FUNCTION (DH=01EH)
;
UNLOCK:
	MOV	BYTE PTR LOCK,01H	;UNLOCK INTERRUPT FUNCTION
	JMP	UNLOCKX			;SPECIAL UNLOCK EXIT
;
;
;	INTERRUPT EXECUTION FUNCTION (DH=01FH)
;		Entry, H(BH) and L(BL) points to 16-word INT array:
;		   #WRDS/INT#,AX,BX,CX,DX,ES,SI,DI,DS (To   INT)
;		   16bitFLAGS,AX,BX,CX,DX,ES,SI,DI,DS (From INT)
;
INTRPT:	TEST	BYTE PTR LOCK,01H	;INT MUST BE UNLOCKED
	JNZ	INTRPT1			;OK TO DO INTERRUPT
	JMP	EXIT			;INT IS LOCKED - JUST EXIT
;
INTRPT1:
	MOV	BH,HIN		;GET POINTER TO ARRAY
	MOV	BL,LIN
	MOV	INTARY,BX
	MOV	SI,BX
	MOV	DI,OFFSET WRDCNT	;POINT TO OUR WORK ARRAY
	MOV	ES,RPMSEG	;Establish pointer to user's segment
	.BYTE	ESPREFX		;Prefix to user's segment
	MOV	CL,[SI]		;GET WORD COUNT FROM CALLER
	AND	CL,01FH		;mask count
	CMP	CL,10		;limit count to 9 words
	JS	INTRPT2		;UNDER 9 - CONTINUE
	MOV	CL,9		;SET MAX COUNT TO 9 WORDS
INTRPT2:
	MOV	AX,RPMSEG	;Array comes from RPM segment
	MOV	SSEG,AX
	MOV	DSEG,DS
	CALL	MOVARRAY	;MOVE ARRAY TO WORK AREA
;
	MOV	AL,INTNO	;GET INTERRUPT NUMBER
	MOV	INTNUM,AL	;SET INTERRUPT INSTRUCTION
	CMP	AL,021H		;check if DOS INT 21H
	JNZ	INTRPT2A		;no
	MOV	AX,AXIN
	CMP	AH,00H		;if so, check if PGM TERMINATE
	JNZ	INTRPT2A		;no
	JMP	GODOS		;if so, do GODOS
;
INTRPT2A:	EQU	$
	MOV	AX,AXIN		;LOAD REGISTERS FOR INTERRUPT
	MOV	BX,BXIN
	MOV	CX,CXIN
	MOV	DX,DXIN
	MOV	ES,ESIN
	MOV	SI,SIIN
	MOV	DI,DIIN
;
	TEST	BYTE PTR WRDCNT,080H	;SEE IF OUT TO PORT
	JZ	INTRPT3			;NO
	JMP	OUT88		;DO OUT
INTRPT3:	EQU	$
	TEST	BYTE PTR WRDCNT,040H	;SEE IF IN FROM PORT
	JZ	DOINT			;NO
	JMP	IN88		;DO IN
;
DOINT:	EQU	$
	PUSH	DS		;SAVE DS OVER INTERRUPT
	MOV	DS,DSIN		;DS TO INTERRUPT CALLED
;
	INT	012H		;012H = ROM BIOS MEMORY CHECK
INTNUM:	EQU	$-1
;
	MOV	BP,DS		;TEMP HOLD OF DS FROM INTERRUPT
	POP	DS		;RESTORE OUR OWN DS REGISTER
	MOV	DSOUT,BP	;DS RETURNED BY INTERRUPT
;
INOUTX:	EQU	$		;EXIT FROM DOING IN OR OUT 
	MOV	AXOUT,AX	;REGISTERS FROM INTERRUPT
	MOV	BXOUT,BX	;BACK TO CALLER
	MOV	CXOUT,CX
	MOV	DXOUT,DX
	MOV	ESOUT,ES
	MOV	SIOUT,SI
	MOV	DIOUT,DI
	PUSHF			;GET FLAGS
	POP	AX		;AND SAVE
	MOV	FLAGS,AX	;FOR CALLER
;
	MOV	SI,OFFSET FLAGS	;POINTER TO REGISTERS TO BE RETURNED
	MOV	DI,INTARY	;LOCATION OF CALLER'S ARRAY
	MOV	CH,0
	MOV	CL,WRDCNT	;CALLER'S ARRAY WORD COUNT
	AND	CL,01FH		;MASK COUNT
	SHL	CL		;SHIFT TO BYTE COUNT
	ADD	DI,CX		;TO ADDRESS CALLER'S RETURN ARRAY
	MOV	CL,WRDCNT	;WORD COUNT TO RETURN TO USER
	AND	CL,01FH		;MASK COUNT
	MOV	AX,SSEG		;Reverse source/destination segments
	MOV	BX,DSEG		;  to return register array to
	MOV	SSEG,BX		;  caller.
	MOV	DSEG,AX
	CALL	MOVARRAY	;RETURN REGISTERS TO CALLER
;
	JMP	EXIT
;
;	IN FROM PORT (IN AL,DX) VIA INT ARRAY FUNCTION DH=01FH
;
IN88:	EQU	$
	IN	AL,DX		;GET BYTE IN AL FROM PORT DX
	JMP	INOUTX		;RETURN RESULTS TO CALLER
;
;	IN FROM PORT (IN AL,DX) VIA CBIOS88 FUNCTION DH=12H
;
PORTIN:	EQU	$
	MOV	DX,CX		;Put Port from (BC) in DX
	IN	AL,DX		;Get byte in AL (A) from Port DX (BC)
	JMP	EXIT
;
;	OUT TO PORT (OUT DX,AL) VIA INT ARRAY FUNCTION DH=1FH
;
OUT88:	EQU	$
	OUT	DX,AL		;SEND BYTE IN AL TO PORT DX
	JMP	INOUTX		;RETURN RESULTS TO CALLER
;
;	OUT TO PORT (OUT DX,AL) VIA CBIOS88 FUNCTION DH=13H
;
PORTOUT:	EQU	$
	MOV	DX,CX		;Put Port from (BC) in DX
	MOV	AL,AIN  	;Get byte to output.
	OUT	DX,AL		;Send byte in AL (A) to Port DX (BC)
	JMP	EXIT
;
;	MOVE ARRAY TO WORK AREA
;		Entry, SI = source offset, DI = destination offset
;			CL = word count
;			SSEG setup with source segment address
;			DSEG setup with destination segment address
;
MOVARRAY:
	AND	CL,CL		;qualify word count
	JZ	MOVARX		;if zero, no operation
MOVAR1:	EQU	$
	PUSH	DS		;save DS
	MOV	DS,SSEG		;get source segment in DS
	MOV	AX,[SI]		;GET WORD
	POP	DS		;Restore and save DS again
	PUSH	DS
	MOV	DS,DSEG		;get destination segment in DS
	MOV	[DI],AX		;PUT WORD
	POP	DS		;restore DS
	ADD	SI,2		;BUMP POINTERS
	ADD	DI,2
	DEC	CL		;DECREMENT WORD COUNT
	JNZ	MOVAR1		;Loop for Count
MOVARX:	EQU	$		;exit if word count is zero (nop)
	RET
;
;	INTERRUPT ARRAYS - WORK AREA
;
LOCK	.BYTE	0		;INT LOCK:  00H=LOCKED, 01H=UNLOCKED
;
INTARY	.WORD	0		;POINTER TO CALLER'S ARRAY
;
SSEG	.WORD	0		;Source Segment Address for MOVARRAY
DSEG	.WORD	0		;Destination Segment for MOVARRAY
;
;
;	INTERRUPT / IN-OUT FUNCTIONS ARRAY
;
WRDCNT	.BYTE	0		;COUNT OF REGS+1 TO/FROM INT
INTNO	.BYTE	0		;INTERRUPT NUMBER TO EXECUTE
AXIN	.WORD	0		;REGISTERS PASSED TO INT PROCESS
BXIN	.WORD	0
CXIN	.WORD	0
DXIN	.WORD	0
ESIN	.WORD	0
SIIN	.WORD	0
DIIN	.WORD	0
DSIN	.WORD	0
;
FLAGS	.WORD	0		;FLAGS AND REGISTERS
AXOUT	.WORD	0		;RETURNED TO CALLER
BXOUT	.WORD	0
CXOUT	.WORD	0
DXOUT	.WORD	0
ESOUT	.WORD	0
SIOUT	.WORD	0
DIOUT	.WORD	0
DSOUT	.WORD	0
;
;	TIMER INTERRUPT HANDLER - INT 01CH
;		Entry from ROM BIOS Timer Tick Interrupt
;			18.2 times each second.
;
TIMER:	CLI			;DISABLE INTERRUPTS DURING THIS
	PUSH	DS		;SAVE ROM BIOS DS REGISTER
	PUSH	ES
	PUSH	SI
	PUSH	DI		;save registers
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	AX,CS		;PICK UP CODE SEGMENT
	MOV	DS,AX		;IN DATA SEGMENT REGISTER
	INC	TICKS		;BUMPED 18.2 TIMES/SECOND (NOT RESET)
;
TIMSEC:	INC	TICKSEC		;BUMPED 18.2 TIMES/SECOND
	MOV	AX,TICKSEC	;CHECK SECOND TIMER
	CMP	AX,18		;WHEN SECOND HAS OCCURED
	JNS	INCSEC		;YES
	JMP	TIMMIN		;NO - GO INCREMENT MINUTE TICKS
;
INCSEC:	MOV	AL,SECONDS	;BUMP SECONDS COUNT
	CALL	BCDADD
	MOV	SECONDS,AL
	MOV	TICKSEC,0	;RESET SECONDS TICK COUNTER
;
TIMMIN:	INC	TICKMIN		;BUMPED 18.2 TIMES/SECOND
	MOV	AX,TICKMIN
	CMP	AX,1092		;CHECK WHEN A MINUTE HAS OCCURED
	JNS	INCMIN		;YES
	JMP	TEXIT		;OTHERWISE, EXIT
;
INCMIN:	MOV	TICKMIN,0	;YES - RESET MINUTE TICK COUNTER
	MOV	AL,MINUTES	;AT 60 SECONDS, BUMP MINUTES
	CALL	BCDADD
	MOV	MINUTES,AL
	MOV	SECONDS,00H	;RESET SECONDS
	CMP	AL,060H		;CHECK ROLLOVER AT 60 BCD MINUTES
	JNS	INCHRS		;YES
	JMP	TEXIT		;OTHERWISE, EXIT
;
INCHRS:	MOV	AL,HOURS	;AT 60 SECONDS, BUMP HOURS
	CALL	BCDADD
	MOV	HOURS,AL
	MOV	MINUTES,00H	;RESET MINUTES
	CMP	AL,024H		;CHECK ROLLOVER AT 24 BCD HOURS
	JNS	INCDAY		;YES
	JMP	TEXIT		;OTHERWISE, EXIT
;
INCDAY:	MOV	AL,DAY		;AT 24 HOURS, BUMP DAY
	CALL	BCDADD
	MOV	DAY,AL
	MOV	HOURS,00H	;RESET HOURS
	MOV	AH,MONTH	;CHECK WHICH MONTH
	CMP	AH,02H		;CHECK IF FEBRUARY
	JZ	SET29		;YES
	CMP	AH,08H
	JNS	FLIP		;AUG-DEC
	AND	AH,01H		;DETERMINING BIT
	JMP	SETDAY
FLIP:	AND	AH,01H
	XOR	AH,01H
SETDAY:	OR	AH,AH		;CHECK DETERMINATION BIT
	JZ	SET31
	MOV	DL,032H		;MONTHS 1,3,5,7,8,10,12 = 31 DAYS
	JMP	CHKDAY
SET31:	MOV	DL,031H		;MONTHS 4,6,9,11 = 30 DAYS
	JMP	CHKDAY
SET29:	MOV	DL,029H		;FEBRUARY = 28 DAYS TO ROLLOVER
	MOV	AL,YEAR		;CHECK FOR LEAP YEAR
	MOV	AH,00H
	MOV	CL,04H		;DIVIDE BY 4
	DIV	AX,CL
	OR	AH,AH		;CHECK IF ANY REMAINDER
	JNZ	CHKDAY		;NOT LEAP YEAR
	MOV	DL,030H		;LEAP YEAR - 29 DAYS TO ROLLOVER
CHKDAY:
	MOV	AL,DAY
	CMP	AL,DL		;CHECK MONTH-END ROLLOVER
	JNS	INCMON		;YES
	JMP	TEXIT		;OTHERWISE, EXIT
;
INCMON:	MOV	AL,MONTH	;AT NEW MONTH, BUMP BCD MONTH
	CALL	BCDADD
	MOV	MONTH,AL
	MOV	DAY,01H		;RESET DAY TO FIRST OF MONTH
	CMP	AL,013H		;CHECK ROLLOVER AT 13 BCD MONTHS
	JNS	INCYR		;YES
	JMP	TEXIT		;OTHERWISE, EXIT
;
INCYR:	MOV	AL,YEAR		;AT 13 MONTHS, BUMP YEAR
	CALL	BCDADD
	MOV	YEAR,AL
	MOV	MONTH,01H	;RESET MONTH TO JANUARY
;
TEXIT:	EQU	$
	STI			;ENABLE INTERRUPTS
	POP	DX
	POP	CX
	POP	BX		;restore registers
	POP	AX		
	POP	DI
	POP	SI
	POP	ES
	POP	DS		;RESTORE ROM BIOS DS REGISTER
IRETX:	EQU	$		;DOS INT 23H comes here.
	.BYTE	0CFH		;IRET FROM THIS INTERRUPT
;
;	BCDADD - INCREMENTS BCD BYTE BY ONE
;		Entry, AL contains the BCD byte to increment.
;		Exit, AL contains the incremented BCD byte.
;
BCDADD:	ADD	AL,ONE		;INCREMENT BY ONE
	DAA			;DECIMAL ADJUST FOR ADDITION
	RET
;
ONE	.BYTE	01H		;BCD ONE
;
