/* stack.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

typedef struct Stack Stack;
typedef Stack *StackPtr;
struct Stack {
	unsigned count;
	unsigned maxElement;
	unsigned elementSize;
	char *insert;
};

extern StackPtr
	StackReset(StackPtr stackPtr,
	           void *elements,
	           unsigned maxElement,
	           unsigned elementSize);

extern unsigned StackCount(StackPtr stackPtr);

extern int StackPush(StackPtr stackPtr, void *element);

extern int StackPop(StackPtr stackPtr, void *element);
