/* uSim cpu.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#ifdef Z80
#define CPU "Z80"
#else
#define CPU "i8080"
#endif

struct CpuState {
	WordBytes af;
	WordBytes bc;
	WordBytes de;
	WordBytes hl;
	WordBytes sp;
	WordBytes pc;
#ifdef Z80
	WordBytes ix;
	WordBytes iy;
	struct {
		WordBytes af;
		WordBytes bc;
		WordBytes de;
		WordBytes hl;
	} prime;
	Byte i;
	Byte r;
	Byte im;
#endif
};

enum {
	CARRY		= 0x01,
	SUBTRACT	= 0x02,
	PARITY		= 0x04,
	OVERFLOW	= 0x04,
	MAGIC1		= 0x08,
	HALFCARRY	= 0x10,
	MAGIC2		= 0x20,
	ZERO		= 0x40,
	SIGN		= 0x80
};

extern void Cpu(void);
