/* uSim clock.c
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#include <time.h>

#include "clock.h"

#ifdef BSD
#include <sys/types.h>
#endif

/**********************************************************************/
#pragma mark *** CLOCK ***

static unsigned long gClockOffset;

/* GetClock() returns the current clock value. */
unsigned long GetClock(void)
{

	return time(0) - gClockOffset;

}

/* ResetClock() resets the clock. */
void ResetClock(unsigned long newClock)
{

	gClockOffset = time(0) + newClock;

}

/**********************************************************************/
#pragma mark *** TIME OF DAY ***

/* GetTimeOfDay() gets the current time of day. */
void GetTimeOfDay(TimeOfDayPtr timeOfDay)
{
    time_t now;
    struct tm *t;
    unsigned days;
    unsigned y;

	/* Get the current time of day. */
    time(&now);

	/* Convert to local time. */
    t = localtime(&now);

	/* Compute the number of days since 1978. */
    days = (t->tm_year - 78) * 365 + t->tm_yday + 1;

	/* Add in extra days for the leap years. */
    for (y = 78; y < t->tm_year; y++)
		if (((y % 4) == 0) && (((y % 100) != 0) || ((y % 400) == 0)))
		    days++;

	/* Fill in the TimeOfDay. */
	timeOfDay->days = days;
	timeOfDay->hours = t->tm_hour;
	timeOfDay->minutes = t->tm_min;
	timeOfDay->seconds = t->tm_sec;

}
