	TITLE	'CP/M CONSOLE COMMAND PROCESSOR (CCP), VER 2.2'

; VERSION 2.2 FEBRUARY, 1980
; COPYRIGHT (C) 1976, 1977, 1978, 1979, 1980
; DIGITAL RESEARCH
; BOX 579, PACIFIC GROVE,
; CALIFORNIA, 93950

; Reorganized and reserialized May 9, 2000 by Tsurishaddai Williamson
; Based on the February 27, 1981 reconstruction by Clark A. Calkins

; 63.5K CP/M LOCATIONS
MEMSIZ	EQU	64			; MEMORY SIZE, KILOBYTES
CPMVER	EQU	22			; CP/M VERSION
CCP	EQU	3200H+(MEMSIZ-20)*1024	; CCP BASE ADDRESS
BDOS	EQU	CCP+0800H		; BDOS BASE ADDRESS
BIOS	EQU	CCP+1600H		; BIOS BASE ADDRESS
DATA	EQU	BIOS+(2300H-1F80H)	; BIOS UNINITIALIZED DATA ADDRESS
REBOOT	EQU	0000H			; "JMP REBOOT" TO REBOOT
IOBYTE	EQU	0003H			; ADDRESS OF I/O BYTE VARIABLE
USRDSK	EQU	0004H			; ADDRESS OF USER NUMBER / CURRENT VARIABLE
SYSTEM	EQU	0005H			; "CALL SYSTEM" FOR SYSTEM CALL
USRFCB	EQU	005CH			; ADDRESS OF DEFAULT FILE CONTROL BLOCK
USRBUF	EQU	0080H			; ADDRESS OF DEFAULT I/O BUFFER
USRTPA	EQU	0100H			; ADDRESS OF TRANSIANT PROGRAM AREA

; KEYBOARD CODES
CTLC	EQU	03H			; CONTROL-C (REBOOT)
CTLE	EQU	05H			; CONTROL-E (END OF LINE)
BS	EQU	08H			; CONTROL-H (BACKSPACE)
TAB	EQU	09H			; CONTROL-I (TAB)
LF	EQU	0AH			; CONTROL-J (LINE FEED)
FF	EQU	0CH			; CONTROL-L (FORM FEED)
CR	EQU	0DH			; CONTROL-M (CARRIAGE RETURN)
CTLP	EQU	10H			; CONTROL-P (TOGGLE PRINT)
CTLR	EQU	12H			; CONTROL-R (RETYPE LINE)
CTLS	EQU	13H			; CONTROL-S (START/STOP OUTPUT)
CTLU	EQU	15H			; CONTROL-U (CANCEL LINE)
CTLX	EQU	18H			; CONTROL-X (CANCEL)
CTLZ	EQU	1AH			; CONTROL-Z (END OF FILE)
DEL	EQU	7FH			; CONTROL-? (DELETE)

	ORG	CCP

	JMP	CCPCMD
	JMP	NEWCMD

BUFSIZ	EQU	127
CMDBUF:	DB	BUFSIZ
BUFLEN:	DB	0
BUFDAT:	DB	'                '
	DB	'COPYRIGHT (C) 1979, DIGITAL RESEARCH  '
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0
BUFPTR:	DW	BUFDAT
CMDERR:	DW	0

; PRINT A CHARACTER
; IN: A = CHAR
PCHAR1:	MOV	E,A
	MVI	C,2
	JMP	SYSTEM

; PRINT A CHARACTER
; IN: A = CHAR
; PRESERVED: BC
PCHAR2:	PUSH	B
	CALL	PCHAR1
	POP	B
	RET

; PRINT A CRLF
; PRESERVED: BC
PCRLF:	MVI	A,CR
	CALL	PCHAR2
	MVI	A,LF
	JMP	PCHAR2

; PRINT A SPACE
; PRESERVED: BC
PSPACE	MVI	A,' '
	JMP	PCHAR2

; PRINT A LINE
; BC = ADDRESS OF NULL-TERMINATED STRING
PLINE:	PUSH	B
	CALL	PCRLF
	POP	H
PLINE2:	MOV	A,M
	ORA	A
	RZ
	INX	H
	PUSH	H
	CALL	PCHAR1
	POP	H
	JMP	PLINE2

; RESET THE DISK SYSTEM
RESDSK:	MVI	C,13
	JMP	SYSTEM

; SELECT DISK
; IN: A = DISK NUMBER
SELDSK:	MOV	E,A
	MVI	C,14
	JMP	SYSTEM

; CALL SYSTEM FUNCTION AND SAVE THE RESULT CODE
; OUT: Z SET IF -1 RESULT
SYSSAV:	CALL	SYSTEM
	STA	RESULT
	INR	A
	RET

; OPEN A FILE
; IN: DE = FCB ADDRESS
OPNFIL:	MVI	C,15
	JMP	SYSSAV

; OPEN A FILE USING THE CCPFCB
OPNFCB:	XRA	A
	STA	CCPFCB+32
	LXI	D,CCPFCB
	JMP	OPNFIL

; CLOSE A FILE
; IN: DE = FCB ADDRESS
CLSFIL:	MVI	C,16
	JMP	SYSSAV

; SEARCH FOR THE FIRST FILE
; IN: DE = FCB ADDRESS
SCHFST:	MVI	C,17
	JMP	SYSSAV

; SEARCH FOR THE NEXT FILE
; IN: DE = FCB ADDRESS
SCHNXT:	MVI	C,18
	JMP	SYSSAV

; SEARCH FOR THE FIRST FILE USING THE CCPFCB
SCHFCB:	LXI	D,CCPFCB
	JMP	SCHFST

; DELETE A FILE
; IN: DE = FCB ADDRESS
DELFIL:	MVI	C,19
	JMP	SYSTEM

; CALL SYSTEM FUNCTION AND CHECK FOR ZERO STATUS
; OUT: Z SET IF ZERO RESULT
SYSZER	CALL	SYSTEM
	ORA	A
	RET

; READ THE NEXT RECORD FROM A FILE
; IN: DE = FCB ADDRESS
RDFILE:	MVI	C,20
	JMP	SYSZER

; READ THE NEXT RECORD FROM A FILE USING THE CCPFCB
RDFCB:	LXI	D,CCPFCB
	JMP	RDFILE

; WRITE THE NEXT RECORD TO A FILE
; IN: DE = FCB ADDRESS
WRFILE:	MVI	C,21
	JMP	SYSZER

; CREATE A FILE
; IN: DE = FCB ADDRESS
CRFILE:	MVI	C,22
	JMP	SYSSAV

; RENAME A FILE
; IN: DE = FCB ADDRESS
; NOTE: FCB+16 CONTAINS NEW NAME
RENFIL:	MVI	C,23
	JMP	SYSTEM

; GET THE CURRENT USER CODE
; OUT: A = USER CODE
GETUSR:	MVI	E,0FFH

; SET THE CURRENT USER CODE
; IN: E = USER CODE
SETUSR:	MVI	C,32
	JMP	SYSTEM

; SET THE CURRENT USRDSK
SETDSK:	CALL	GETUSR
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	LXI	H,CCPDSK
	ORA	M
	STA	USRDSK
	RET

; COPY CCPDSK TO USRDSK
SETUD:	LDA	CCPDSK
	STA	USRDSK
	RET

; CONVERT CHARACTER TO UPPERCASE
; IN: A = CHAR
; OUT: A = UPPERCASE CHAR
UPCHAR:	CPI	'a'
	RC
	CPI	'{'
	RNC
	ANI	5FH
	RET

; GET THE NEXT COMMAND LINE
; READ THE INPUT FROM "A:$$$.SUB" IF BATCH MODE
GETCMD:	LDA	BATFLG
	ORA	A
	JZ	GETINP	; INPUT COMMAND IF BATFLG CLEAR
	LDA	CCPDSK
	ORA	A
	MVI	A,0
	CNZ	SELDSK	; SELECT A:
	LXI	D,BATFCB
	CALL	OPNFIL
	JZ	GETINP	; INPUT COMMAND IF NO FILE
	LDA	BATFCB+15
	DCR	A
	STA	BATFCB+32
	LXI	D,BATFCB
	CALL	RDFILE	; READ THE LAST RECORD
	JNZ	GETINP	; INPUT COMMAND IF EMPTY FILE
	LXI	D,BUFLEN
	LXI	H,USRBUF
	MVI	B,BUFSIZ+1
	CALL	MEMCPY
	LXI	H,BATFCB+14
	MVI	M,0
	INX	H
	DCR	M
	LXI	D,BATFCB
	CALL	CLSFIL	; DONE WITH BATCH FILE
	JZ	GETINP
	LDA	CCPDSK
	ORA	A
	CNZ	SELDSK	; RETURN TO THE CURRENT DISK
	LXI	H,BUFDAT
	CALL	PLINE2	; ECHO THE COMMAND LINE
	CALL	CONIN
	JZ	UPLINE	; ABORT BATCH IF ANY KEY PRESSED
	CALL	DELBAT	; DELETE THE BATCH FILE
	JMP	NXTCMD	; INPUT NEXT COMMAND
GETINP	CALL	DELBAT	; DELETE THE BATCH FILE
	CALL	SETDSK	; SET THE CURRENT USRDSK
	MVI	C,10
	LXI	D,CMDBUF
	CALL	SYSTEM	; INPUT COMMAND LINE
	CALL	SETUD	; COPY CCPDSK TO USRDSK
UPLINE:	LXI	H,BUFLEN
	MOV	B,M
UPLIN1:	INX	H
	MOV	A,B
	ORA	A
	JZ	UPLIN2
	MOV	A,M
	CALL	UPCHAR
	MOV	M,A
	DCR	B
	JMP	UPLIN1
UPLIN2:	MOV	M,A
	LXI	H,BUFDAT
	SHLD	BUFPTR	; RESET BUFFER POINTER
	RET

; CHECK FOR CONSOLE INPUT
; OUT: Z SET IF NONE
; OUT: A = INPUT CHAR
CONIN:	MVI	C,11
	CALL	SYSTEM
	ORA	A
	RZ
	MVI	C,1
	CALL	SYSTEM
	ORA	A
	RET

; GET THE CURRENT DISK NUMBER
GETDSK	MVI	C,25
	JMP	SYSTEM

; SET THE DMA POINTER TO USRBUF
SETBUF:	LXI	D,USRBUF

; SET THE DMA POINTER
; IN: DE = DMA ADDRESS
SETDMA	MVI	C,26
	JMP	SYSTEM

; DELETE THE BATCH FILE CREATED BY SUBMIT
DELBAT:	LXI	H,BATFLG
	MOV	A,M
	ORA	A
	RZ		; DO NOTHING IF NOT BATCH MODE
	MVI	M,0
	XRA	A
	CALL	SELDSK	; SELECT A:
	LXI	D,BATFCB
	CALL	DELFIL	; DELETE THE BATCH FILE
	LDA	CCPDSK
	JMP	SELDSK	; RETURN TO THE CURRENT DISK

; CHECK THAT THE SERIAL NUMBERS MATCH
CKSN:	LXI	D,SN1
	LXI	H,SN2
	MVI	B,6
CKSN1:	LDAX	D
	CMP	M
	JNZ	BADSN
	INX	D
	INX	H
	DCR	B
	JNZ	CKSN1
	RET

; PRINT "<FILE>?" IN RESPONSE TO A SYNTAX ERROR
SYNERR	CALL	PCRLF
	LHLD	CMDERR
SYNER1	MOV	A,M
	CPI	' '
	JZ	SYNER2
	ORA	A
	JZ	SYNER2
	PUSH	H
	CALL	PCHAR1
	POP	H
	INX	H
	JMP	SYNER1
SYNER2	MVI	A,'?'
	CALL	PCHAR1
	CALL	PCRLF
	CALL	DELBAT	; DELETE ANY BATCH FILE
	JMP	NXTCMD	; INPUT NEXT COMMAND

; CHECK FOR COMMAND CHARACTER
; IN: DE = ADDRESS OF CHARACTER
; OUT: Z SET IF CHARACTER IS DELIMITER "=-.:;<>"
CHECK	LDAX	D
	ORA	A
	RZ
	CPI	' '
	JC	SYNERR
	RZ
	CPI	'='
	RZ
	CPI	'_'
	RZ
	CPI	'.'
	RZ
	CPI	':'
	RZ
	CPI	';'
	RZ
	CPI	'<'
	RZ
	CPI	'>'
	RZ
	RET

; SKIP SPACE
; IN: DE = ZERO-TERMINATED STRING
; OUT: A = NEXT NON-SPACE CHARACTER
SKIPSP:	LDAX	D
	ORA	A
	RZ
	CPI	' '
	RNZ
	INX	D
	JMP	SKIPSP

; HL = HL + A
ADDHL	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET

; FIX UP THE FIRST FILE NAME IN CCPFCB
; OUT: A = 0 IF UNAMBIGEOUS FILE NAME
FNAME1:	MVI	A,0
; IN: A = NAME POSITION, 0 OR 16
FNAME2:	LXI	H,CCPFCB
	CALL	ADDHL
	PUSH	H
	PUSH	H
	XRA	A
	STA	CHGDSK
	LHLD	BUFPTR
	XCHG
	CALL	SKIPSP
	XCHG
	SHLD	CMDERR
	XCHG
	POP	H
	LDAX	D
	ORA	A
	JZ	FNAME3
	SBI	'A'-1
	MOV	B,A
	INX	D
	LDAX	D
	CPI	':'
	JZ	FNAME4
	DCX	D
FNAME3:	LDA	CCPDSK
	MOV	M,A
	JMP	FNAME5
FNAME4:	MOV	A,B
	STA	CHGDSK
	MOV	M,B
	INX	D
FNAME5:	MVI	B,08H
FNAME6:	CALL	CHECK
	JZ	FNAMEA
	INX	H
	CPI	'*'
	JNZ	FNAME7
	MVI	M,'?'
	JMP	FNAME8
FNAME7:	MOV	M,A
	INX	D
FNAME8:	DCR	B
	JNZ	FNAME6
FNAME9:	CALL	CHECK
	JZ	FNAMEB
	INX	D
	JMP	FNAME9
FNAMEA:	INX	H
	MVI	M,' '
	DCR	B
	JNZ	FNAMEA
FNAMEB:	MVI	B,03H
	CPI	'.'
	JNZ	FNAMEG
	INX	D
FNAMEC:	CALL	CHECK
	JZ	FNAMEG
	INX	H
	CPI	'*'
	JNZ	FNAMED
	MVI	M,'?'
	JMP	FNAMEE
FNAMED:	MOV	M,A
	INX	D
FNAMEE:	DCR	B
	JNZ	FNAMEC
FNAMEF:	CALL	CHECK
	JZ	FNAMEH
	INX	D
	JMP	FNAMEF
FNAMEG:	INX	H
	MVI	M,' '
	DCR	B
	JNZ	FNAMEG
FNAMEH:	MVI	B,3
FNAMEI:	INX	H
	MVI	M,0
	DCR	B
	JNZ	FNAMEI
	XCHG
	SHLD	BUFPTR
	POP	H
	LXI	B,11
FNAMEJ:	INX	H
	MOV	A,M
	CPI	'?'
	JNZ	FNAMEK
	INR	B
FNAMEK:	DCR	C
	JNZ	FNAMEJ
	MOV	A,B
	ORA	A
	RET

; TABLE OF CCP COMMANDS
MAXCMD	EQU	6
CMDTAB:	DB	'DIR '
	DB	'ERA '
	DB	'TYPE'
	DB	'SAVE'
	DB	'REN '
	DB	'USER'

; THE FIRST COPY OF THE SERIAL NUMBER, SEE CKSN
SN1:	DB	020H,055H,053H,049H,04DH,020H
SN2	EQU	BDOS

; MATCH A NAME IN THE CMDTAB
; OUT: C = COMMAND NUMBER, MAXCMD+1 IF NO MATCH
MATCH:	LXI	H,CMDTAB
	MVI	C,0
MATCH1:	MOV	A,C
	CPI	MAXCMD
	RNC
	LXI	D,CCPFCB+1
	MVI	B,4
MATCH2:	LDAX	D
	CMP	M
	JNZ	MATCH3
	INX	D
	INX	H
	DCR	B
	JNZ	MATCH2
	LDAX	D
	CPI	' '
	JNZ	MATCH4
	MOV	A,C
	RET
MATCH3:	INX	H
	DCR	B
	JNZ	MATCH3
MATCH4:	INR	C
	JMP	MATCH1

; ENTER THE CCP FOR A NEW COMMAND, CLEAR THE COMMAND BUFFER
; IN: C = USRDSK
NEWCMD:	XRA	A
	STA	BUFLEN

; ENTER THE CCP WITH THE CURRENT COMMAND BUFFER
; IN: C = USRDSK
CCPCMD:	LXI	SP,STACK
	PUSH	B
	MOV	A,C
	RAR
	RAR
	RAR
	RAR
	ANI	0FH
	MOV	E,A
	CALL	SETUSR
	CALL	RESDSK
	STA	BATFLG
	POP	B
	MOV	A,C
	ANI	0FH
	STA	CCPDSK
	CALL	SELDSK
	LDA	BUFLEN
	ORA	A
	JNZ	DOCMD
NXTCMD:	LXI	SP,STACK
	CALL	PCRLF
	CALL	GETDSK
	ADI	'A'
	CALL	PCHAR1
	MVI	A,'>'
	CALL	PCHAR1
	CALL	GETCMD
DOCMD:	LXI	D,USRBUF
	CALL	SETDMA
	CALL	GETDSK
	STA	CCPDSK
	CALL	FNAME1
	CNZ	SYNERR
	LDA	CHGDSK
	ORA	A
	JNZ	COM
	CALL	MATCH
	LXI	H,CMDADR
	MOV	E,A
	MVI	D,0
	DAD	D
	DAD	D
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	PCHL

; COMMAND ADDRESS TABLE, SEE CMDTAB
CMDADR:	DW	DIR
	DW	ERA
	DW	TYPE
	DW	SAVE
	DW	REN
	DW	USER
	DW	COM

; HALT THE SYSTEM IF A BAD SERIAL NUMBER IS DETECTED
BADSN	LXI	H,76F3H
	SHLD	CCP
	LXI	H,CCP
	PCHL

; NOTE READ ERROR
RDERR	LXI	B,RDERRM
	JMP	PLINE
RDERRM:	DB	'READ ERROR',0

; NOTE NO FILE FOUND
NOFILE	LXI	B,NOFILM
	JMP	PLINE
NOFILM:	DB	'NO FILE',0

; PARSE A COMMAND OF THE FORM "FILE NUMBER [ FILE ]"
; OUT: A = NUMBER
PARSE:	CALL	FNAME1
	LDA	CHGDSK
	ORA	A
	JNZ	SYNERR
	LXI	H,CCPFCB+1
	LXI	B,11
PARSE1:	MOV	A,M
	CPI	' '
	JZ	PARSE3
	INX	H
	SUI	'0'
	CPI	10
	JNC	SYNERR
	MOV	D,A
	MOV	A,B
	ANI	0E0H
	JNZ	SYNERR
	MOV	A,B
	RLC
	RLC
	RLC
	ADD	B
	JC	SYNERR
	ADD	B
	JC	SYNERR
	ADD	D
PARSE2:	JC	SYNERR
	MOV	B,A
	DCR	C
	JNZ	PARSE1
	RET
PARSE3:	MOV	A,M
	CPI	' '
	JNZ	SYNERR
	INX	H
PARSE4:	DCR	C
	JNZ	PARSE3
	MOV	A,B
	RET

; COPY THREE BYTES
; IN: HL = SOURCE ADDRESS
; IN: DE = DESTINATION ADDRESS
MEMCP3:	MVI	B,3

; COPY MEMORY
; IN: HL = SOURCE ADDRESS
; IN: DE = DESTINATION ADDRESS
; IN: B = COUNT
MEMCPY:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MEMCPY
	RET

; HL = USRBUF + A + C
; OUT: A = BYTE AT HL
GETHL:	LXI	H,USRBUF
	ADD	C
	CALL	ADDHL
	MOV	A,M
	RET

; SELECT A NEW DISK, CCPFCB WILL USE CURRENT DISK
NEWDSK:	XRA	A
	STA	CCPFCB
	LDA	CHGDSK
	ORA	A
	RZ
	DCR	A
	LXI	H,CCPDSK
	CMP	M
	RZ
	JMP	SELDSK

; SELECT THE OLD DISK
OLDDSK:	LDA	CHGDSK
	ORA	A
	RZ
	DCR	A
	LXI	H,CCPDSK
	CMP	M
	RZ
	LDA	CCPDSK
	JMP	SELDSK

; THE "DIR" COMMAND
DIR:	CALL	FNAME1
	CALL	NEWDSK
	LXI	H,CCPFCB+1
	MOV	A,M
	CPI	' '
	JNZ	DIR2
	MVI	B,11
DIR1:	MVI	M,'?'
	INX	H
	DCR	B
	JNZ	DIR1
DIR2:	MVI	E,0
	PUSH	D
	CALL	SCHFCB
	CZ	NOFILE
DIR3:	JZ	DIR11
	LDA	RESULT
	RRC
	RRC
	RRC
	ANI	60H
	MOV	C,A
	MVI	A,10
	CALL	GETHL
	RAL
	JC	DIR10
	POP	D
	MOV	A,E
	INR	E
	PUSH	D
	ANI	03H
	PUSH	PSW
	JNZ	DIR4
	CALL	PCRLF
	PUSH	B
	CALL	GETDSK
	POP	B
	ADI	'A'
	CALL	PCHAR2
	MVI	A,':'
	CALL	PCHAR2
	JMP	DIR5
DIR4:	CALL	PSPACE
	MVI	A,':'
	CALL	PCHAR2
DIR5:	CALL	PSPACE
	MVI	B,1
DIR6:	MOV	A,B
	CALL	GETHL
	ANI	7FH
	CPI	' '
	JNZ	DIR8
	POP	PSW
	PUSH	PSW
	CPI	3
	JNZ	DIR7
	MVI	A,9
	CALL	GETHL
	ANI	7FH
	CPI	' '
	JZ	DIR9
DIR7:	MVI	A,' '
DIR8:	CALL	PCHAR2
	INR	B
	MOV	A,B
	CPI	12
	JNC	DIR9
	CPI	9
	JNZ	DIR6
	CALL	PSPACE
	JMP	DIR6
DIR9:	POP	PSW
DIR10:	CALL	CONIN
	JNZ	DIR11
	CALL	SCHNXT
	JMP	DIR3
DIR11:	POP	D
	JMP	DONE1

; THE "ERA" COMMAND
ERA:	CALL	FNAME1
	CPI	11
	JNZ	ERA1
	LXI	B,ERA2
	CALL	PLINE
	CALL	GETCMD
	LXI	H,BUFLEN
	DCR	M
	JNZ	NXTCMD
	INX	H
	MOV	A,M
	CPI	'Y'
	JNZ	NXTCMD
	INX	H
	SHLD	BUFPTR
ERA1:	CALL	NEWDSK
	LXI	D,CCPFCB
	CALL	DELFIL
	INR	A
	CZ	NOFILE
	JMP	DONE1
ERA2:	DB	'ALL (Y/N)?',0

; THE "TYPE" COMMAND
TYPE	CALL	FNAME1
	JNZ	SYNERR
	CALL	NEWDSK
	CALL	OPNFCB
	JZ	TYPE5
	CALL	PCRLF
	LXI	H,NBYTES
	MVI	M,0FFH
TYPE1	LXI	H,NBYTES
TYPE2	MOV	A,M
	CPI	128
	JC	TYPE3
	PUSH	H
	CALL	RDFCB
	POP	H
	JNZ	TYPE4
	XRA	A
	MOV	M,A
TYPE3	INR	M
	LXI	H,USRBUF
	CALL	ADDHL
	MOV	A,M
	CPI	CTLZ
	JZ	DONE1
	CALL	PCHAR1
	CALL	CONIN
	JNZ	DONE1
	JMP	TYPE1
TYPE4	DCR	A
	JZ	DONE1
	CALL	RDERR
TYPE5	CALL	OLDDSK
	JMP	SYNERR

; THE "SAVE" COMMAND
SAVE:	CALL	PARSE
	PUSH	PSW
	CALL	FNAME1
	JNZ	SYNERR
	CALL	NEWDSK
	LXI	D,CCPFCB
	PUSH	D
	CALL	DELFIL
	POP	D
	CALL	CRFILE
	JZ	SAVE3
	XRA	A
	STA	CCPFCB+32
	POP	PSW
	MOV	L,A
	MVI	H,0
	DAD	H
	LXI	D,USRTPA
SAVE1:	MOV	A,H
	ORA	L
	JZ	SAVE2
	DCX	H
	PUSH	H
	LXI	H,128
	DAD	D
	PUSH	H
	CALL	SETDMA
	LXI	D,CCPFCB
	CALL	WRFILE
	POP	D
	POP	H
	JNZ	SAVE3
	JMP	SAVE1
SAVE2:	LXI	D,CCPFCB
	CALL	CLSFIL
	INR	A
	JNZ	SAVE4
SAVE3:	LXI	B,SAVE5
	CALL	PLINE
SAVE4:	CALL	SETBUF
	JMP	DONE1
SAVE5:	DB	'NO SPACE',0

; THE "REN" COMMAND
REN:	CALL	FNAME1
	JNZ	SYNERR
	LDA	CHGDSK
	PUSH	PSW
	CALL	NEWDSK
	CALL	SCHFCB
	JNZ	REN6
	LXI	H,CCPFCB
	LXI	D,CCPFCB+16
	MVI	B,16
	CALL	MEMCPY
	LHLD	BUFPTR
	XCHG
	CALL	SKIPSP
	CPI	'='
	JZ	REN1
	CPI	'_'
	JNZ	REN5
REN1:	XCHG
	INX	H
	SHLD	BUFPTR
	CALL	FNAME1
	JNZ	REN5
	POP	PSW
	MOV	B,A
	LXI	H,CHGDSK
	MOV	A,M
	ORA	A
	JZ	REN2
	CMP	B
	MOV	M,B
	JNZ	REN5
REN2:	MOV	M,B
	XRA	A
	STA	CCPFCB
REN3:	CALL	SCHFCB
	JZ	REN4
	LXI	D,CCPFCB
	CALL	RENFIL
	JMP	DONE1
REN4:	CALL	NOFILE
	JMP	DONE1
REN5:	CALL	OLDDSK
	JMP	SYNERR
REN6:	LXI	B,REN7
	CALL	PLINE
	JMP	DONE1
REN7:	DB	'FILE EXISTS',0

; THE "USER" COMMAND
USER:	CALL	PARSE
	CPI	16
	JNC	SYNERR
	MOV	E,A
	LDA	CCPFCB+1
	CPI	' '
	JZ	SYNERR
	CALL	SETUSR
	JMP	DONE2

; LOAD AND EXECUTE A "*.COM" COMMAND
COM:	CALL	CKSN
	LDA	CCPFCB+1
	CPI	' '
	JNZ	COM1
	LDA	CHGDSK
	ORA	A
	JZ	DONE2
	DCR	A
	STA	CCPDSK
	CALL	SETUD
	CALL	SELDSK
	JMP	DONE2
COM1:	LXI	D,CCPFCB+9
	LDAX	D
	CPI	' '
	JNZ	SYNERR
COM2:	PUSH	D
	CALL	NEWDSK
	POP	D
	LXI	H,COM12
	CALL	MEMCP3
	CALL	OPNFCB
	JZ	COM9
	LXI	H,USRTPA
COM3:	PUSH	H
	XCHG
	CALL	SETDMA
	LXI	D,CCPFCB
	CALL	RDFILE
	JNZ	COM4
	POP	H
	LXI	D,128
	DAD	D
	LXI	D,CCP
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JNC	COM10
	JMP	COM3
COM4:	POP	H
	DCR	A
	JNZ	COM10
	CALL	OLDDSK
	CALL	FNAME1
	LXI	H,CHGDSK
	PUSH	H
	MOV	A,M
	STA	CCPFCB
	MVI	A,16
	CALL	FNAME2
	POP	H
	MOV	A,M
	STA	CCPFCB+16
	XRA	A
	STA	CCPFCB+32
	LXI	D,USRFCB
	LXI	H,CCPFCB
	MVI	B,33
	CALL	MEMCPY
	LXI	H,BUFDAT
COM5:	MOV	A,M
	ORA	A
	JZ	COM6
	CPI	' '
	JZ	COM6
	INX	H
	JMP	COM5
COM6:	MVI	B,0
	LXI	D,USRBUF+1
COM7:	MOV	A,M
	STAX	D
	ORA	A
	JZ	COM8
	INR	B
	INX	H
	INX	D
	JMP	COM7
COM8:	MOV	A,B
	STA	USRBUF
	CALL	PCRLF
	CALL	SETBUF
	CALL	SETDSK
	CALL	USRTPA
	LXI	SP,BATFLG
	CALL	SETUD
	CALL	SELDSK
	JMP	NXTCMD
COM9:	CALL	OLDDSK
	JMP	SYNERR
COM10:	LXI	B,COM11
	CALL	PLINE
	JMP	DONE1
COM11:	DB	'BAD LOAD',0
COM12:	DB	'COM'

; ALL DONE WITH A COMMAND
DONE1:	CALL	OLDDSK
DONE2:	CALL	FNAME1
	LDA	CCPFCB+1
	SUI	' '
	LXI	H,CHGDSK
	ORA	M
	JNZ	SYNERR
	JMP	NXTCMD

; THE CCP STACK
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
STACK	EQU	$

BATFLG:	DB	0
BATFCB:	DB	0,'$$$     SUB',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
CCPFCB:	DB	0,'           ',0,0,0,0,0,'           ',0,0,0,0,0
RESULT:	DB	0
CCPDSK:	DB	0
CHGDSK:	DB	0
NBYTES:	DW	0

PAD:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

CODSIZ	EQU	$ - CCP
NXTADR	EQU	$

