	title	'Character I/O Module for the Modular CP/M 3 BIOS'

;	CP/M-80 Version 3	-- Modular BIOS
;	Character I/O Module for Z80-Simulator
;	Initial version 1.0
;	Copyright (C) 1989 by Udo Munk

	public	?cinit,?ci,?co,?cist,?cost
	public	@ctbl

	maclib z80	; define Z80 op codes
	maclib ports	; define port addresses
	maclib modebaud	; define mode bits and baud eqautes

max$devices	equ 3

	cseg

?cinit:
	ret	; Z80-Simulator character I/O needs no initialization

?ci:		; character input
	mov a,b ! cpi max$devices+1 ! jnc null$input	; check device
	mov l,b ! mvi h,0		; make device number 16 bits
	lxi d,status$ports ! dad d	; make pointer to port address
	mov c,m ! inr c ! inp a		; get data
	ret

null$input:
	mvi a,1Ah			; return a ctl-Z for no device
	ret

?cist:		; character input status
	mov a,b ! cpi max$devices+1 ! jnc null$status	; check device
	mov l,b ! mvi h,0		; make device number 16 bits
	lxi d,status$ports ! dad d	; make pointer to port address
	mov c,m ! inp a			; read from status port
	ret

null$status:
	xra a ! ret

?co:		; character output
	mov a,b ! cpi max$devices+1 ! jnc null$output	; check device
	mov a,c ! push psw		; save character from <C>
	mov l,b ! mvi h,0		; get device number in <HL>
	lxi d,status$ports ! dad d	; make address of port address
	mov c,m ! inr c			; get port address
	pop psw ! outp a		; send data

null$output:
	ret

?cost:		; character output status
	mov a,b ! cpi max$devices+1 ! jnc null$status	; check device
	mvi a,0FFh			; output devices of Z80-simulator
	ret				; are always ready

status$ports:		; status ports by physical device number
	db	p$crt$stat,p$lpt$stat,p$host$stat

@ctbl	db 'CRT   '	; device 0
	db mb$in$out
	db baud$none
	db 'LPT   '	; device 1
	db mb$output
	db baud$none
	db 'HOST  '	; device 2
	db mb$in$out
	db baud$none
	db 0		; table terminator

	end
