*********************************************************************
*
*       This routine reads the real time clock on a CompuPro System 
* Support 1 board and outputs it in 24 hour format to the console 
* device.
*
*               written by Bob Harbour
*                          3/22/88
*
************************************************************************
        .text
        .globl _clock

clcom   equ     $0FF005A                * real time clock command addr
cldata  equ     $0FF005B                * "           "   data addr

read    equ     $10                     * clock commands
hold    equ     $40

d_off   equ     $30                     * bcd to ascii offset
space   equ     $20                     * ascii constants
term    equ     $24                     * string terminator

outlin  equ     09                      * bdos string print function

mask    equ     $0F                     * normal digit mask
smask   equ     03                      * short digit mask

numdig  equ     10                      * number of digits to read
bufsiz  equ     20                      * output buffer size


_clock  move.l  #outstr,A0              * set pointer to output buffer
        move.l  #digadd,A1              * "            " digit addresss
        move.l  #delim,A2               * "            " field delim's
        move.l  #numdig,D3              * load digit counter

top     move.b  (A1)+,D0                * get digit address
        bsr     getdig                  * get digit from clock
        and     #mask,D1                * scrub out any garbage 

        cmpi.b  #numdig-2,D3            * see if day tens digit
        bne     notdten                 * no, skip this 
        andi    #smask,D1               * yes, clean more garbage
        bra     nothten                 * skip next part

notdten cmpi.b  #numdig-6,D3            * see if hour tens digit
        bne     nothten                 * same as above
        andi    #smask,D1

nothten addi.b  #d_off,D1               * make bcd into ascii
        move.b  D1,(A0)+                * put it in output buffer
        move.b  (A2)+,D1                * get the delimiter char
        beq     none                    * if =  0, ignore
        move.b  D1,(A0)+                * else put it in buffer too

none    subq.b  #1,D3                   * pass finished, dec counter
        bne     top                     * if count left, go again

        clr.b   D1
        move.b  D1,clcom                * remove hold command

* To make this a C callable function, uncomment the three lines below. 
* This function would be called from C as:
* char *clock(), *timestring;
* timestring = clock();
* Copy the contents of the returned string out, since this function
* owns the memory the string lives in, and successive calls to this function
* will change the data as time passes. BH 12/97
*
*      move.b	#0,(A0)			* put C string terminator on
*      move.l	#outstr,D0		* setup return value
*      rts

        moveq   #term,D0                * put string terminator on
        move.b  D0,(A0)+

        move.l  #outstr,D1              * setup for bdos call
        move.w  #outlin,D0              * get print string f number
        trap    #2                      * call bdos

        rts                             * done, adios

*      This routine reads the real time clock. all command bit
* handling is accomodated here. Pass in digit address in register d0 
* and digit is returned in register d1. d0 is changed, all others
* are returned intact.

getdig  or      #hold,D0                * put command bits in
        or      #read,D0
        move.b  D0,clcom                * send it to the clock
        move.b  cldata,D1               * get response from clock
        move.b  #hold,D0                * remove read command
        move.b  D0,clcom
        rts


        .data
        .even
delim   .dc.b   0,'/',0,'/',0,space,0,':',0,0,0
digadd  .dc.b   $0A,09,08,07,$0C,$0B,05,04,03,02

        .bss
        .even
outstr  .ds.b   bufsiz

        .end

