/*	WMUTIL.C	09/08/83 - 10/27/83	LEE JAY LORENZEN	*/

/*** INCLUDE FILES ******************************************************/

#include <portab.h>
#include <fields.h>


/*** DEFINES ***********************************************************/

#define UP 0xff0b
#define DOWN 0xff10
#define LEFT 0xff0d
#define RIGHT 0xff0e

#define VS_TOP_LEFT 2
#define VS_BOT_RIGHT 4
#define VS_WIN_SIZE 12
#define VS_CRT_SEG 24
#define VS_ATTRIB 28
#define VS_CUR_TRACK 30
#define VS_TRUE_VIEW 42

#define Q_OPEN 0x87
#define Q_READ 0x89
#define Q_WRITE 0x8b
#define S_OSVER 0xa3

#define VERSION 0x31

#define IO_SWITCH 0x07


/*** STRUCTURES DECLARATIONS ******************************************/


/*** EXTERNAL FUNCTION DECLARATIONS ***********************************/

EXTERN VOID WM_PK();				/* in WWCALL.A86	*/
EXTERN VOID WM_CALL();
EXTERN VOID IO_CALL();


/*** GLOBAL VARIABLES *************************************************/

BYTE	*ptrack[] =
{
	"No ",
	"Row"
};


BYTE	*pdisp[] =
{
	" B&W ",
	"Color"
};


BYTE	*pcolors[] =
{
	"Black  ",
	"Blue   ",
	"Green  ",
	"Cyan   ",
	"Red    ",
	"Magenta",
	"Yellow ",
	"White  "
};



/*** SUB FUNCTIONS ****************************************************/


/*** VERSION CHecK routine ********************************************/
	
	WORD
version_chk()
{
	UWORD		ret;
						/* do something	that	*/
						/*   verifies this is	*/
						/*   Concurrent CP/M	*/
						/*   3.1 with an XIOS	*/
						/*   that supports 	*/
						/*   windows		*/
	ret = __BDOS(S_OSVER, 0x00);
	if ( ret != VERSION )
	  return(FALSE);
	else
	{
	  return(TRUE);
	}
}


/*** Up Down Left and Right ADJUST routine ********************************/
	
	VOID
udlr_adjust(ax, puvalue, pdvalue, plvalue, prvalue)
	WORD		ax;
	WORD		*puvalue,
			*pdvalue,
			*plvalue,
			*prvalue;
{
	*puvalue = ( ax == UP ) ? (*puvalue - 1) : (*puvalue);
	*pdvalue = ( ax == DOWN ) ? (*pdvalue + 1) : (*pdvalue);
	*plvalue = ( ax == LEFT ) ? (*plvalue - 1) : (*plvalue);
	*prvalue = ( ax == RIGHT ) ? (*prvalue + 1) : (*prvalue);

	return;
}


/*** ARROW routine *****************************************************/
	
	WORD
arrow(ax, selection)
	WORD		ax;
	WORD		selection;
{
	udlr_adjust(ax, &selection, &selection, &selection, &selection);
	return(selection);
}


/*** WRAP routine *****************************************************/

	WORD
wrap(low, test, high)
	WORD		low,
			test,
			high;
{
	if ( test < low )
	  return(high);

	if ( test > high )
	  return(low);

	return(test);
}


/*** between routine *****************************************************/

	WORD
between(low, test, high)
	WORD		low,
			test,
			high;
{
	if ( test <= low )
	  return(low);

	if ( test >= high )
	  return(high);

	return(test);
}


/*** D2_FORMAT routine *************************************************/

	VOID
d2_format(number, pnumber)
	BYTE		number;
	BYTE		*pnumber;
{
						/* generate 2 digit	*/
						/*   decimal chars with */
						/*   high bits so they	*/
						/*   get highlighted	*/
	pnumber[1] = 0x0080 | ('0' + (number % 10));
	pnumber[0] = 0x0080 | ('0' + (number / 10));

	return;
}


/*** Window Manager Number of Rows and Number of Columns routine **********/

	VOID
wm_nrnc(vc, pnr, pnc)
	WORD		vc;
	WORD		*pnr;
	WORD		*pnc;
{
	WORD		value,tl,br;

	WM_PK(0, vc, VS_TOP_LEFT, &tl);
	WM_PK(0, vc, VS_BOT_RIGHT, &br);
	WM_PK(0, vc, VS_WIN_SIZE, &value);

	*pnc = value & 0x00ff;
 	*pnr = (value & 0xff00) >> 8;

	if ( ( tl == 0x0000 ) &&
	     ( br == 0x174f )   )
	{
	  *pnc = 80;
	  *pnr = 24; 
	}

	return;
}


/*** Window Manager View Row and View Column routine **********************/

	VOID
wm_vrvc(vc, pvr, pvc)
	WORD		vc;
	WORD		*pvr;
	WORD		*pvc;
{
	WORD		value;

	WM_PK(0, vc, VS_TRUE_VIEW, &value);

	*pvc = (value & 0x00ff) + 1;
 	*pvr = ((value & 0xff00) >> 8) + 1;

	return;
}


/*** Window Manager SYNChronize screen image and vc image ***************/

	VOID
wm_sync(number)
	UWORD		number;
{
	UWORD		ax, bx, cx, dx;
	UWORD		imhere, nvc, top;
	UWORD		vr, vc, nr, nc;
						/* if vc is full	*/
						/*   screen and on top	*/
						/*   make sure image and*/
						/*   screen are in sync	*/

	WM_CALL(&imhere, &nvc, &top);
	if ( top == number )
	{
	  wm_nrnc(number, &nr, &nc);
	  wm_vrvc(number, &vr, &vc);
	  if ( (nr == 24) &&
	       (nc == 80) &&
	       (vr == 1) &&
	       (vc == 1)   )
	  {
	    ax = IO_SWITCH;
	    bx = cx = 0;
	    dx = number;
	    IO_CALL(&ax, &bx, &cx, &dx);
	  }
	}
}


/*** COPY_BYTES routine **************************************************/

	VOID
copy_bytes(pdest, psrc, cnt)
	BYTE		*pdest;
	BYTE		*psrc;
	WORD		cnt;
{
	while ( 0 < cnt-- )
	  *pdest++ = *psrc++;
	return; 
}


/*** DZ2_FORMAT routine **************************************************/

	VOID
dz2_format(number, pnumber)
	BYTE		number;
	BYTE		*pnumber;
{
	pnumber[1] = '0' + (number % 10);
	pnumber[0] = '0' + (number / 10);
	if ( pnumber[0] == '0' )
	  pnumber[0] = ' ';
	return;
}


/*** FORMAT_FLD routine **************************************************/

	VOID
format_fld(vc, fld, pos, pline)
	BYTE		vc;
	BYTE		fld;
	UWORD		pos;
	BYTE		*pline;
{
	WORD		index;
	WORD		value;
	WORD		r,c;

	switch (fld)
	{
	  case NUMBER:				/* Number		*/
		pline[pos] = '0' + vc;
		break;
	  case PROW:				/* Physical Row		*/
		WM_PK(0, vc, VS_TOP_LEFT, &value);
		dz2_format(((value & 0xff00) >> 8) + 1, &pline[pos]);
		break;
	  case PCOL:				/* Physical Column	*/
		WM_PK(0, vc, VS_TOP_LEFT, &value);
		dz2_format((value & 0x00ff) + 1, &pline[pos]);
		break;
	  case NROWS:				/* Number of Rows	*/
		wm_nrnc(vc, &r, &c);
		dz2_format(r, &pline[pos]);
		break;
	  case NCOLS:				/* Number of Columns	*/
		wm_nrnc(vc, &r, &c);
		dz2_format(c, &pline[pos]);
		break;
	  case VROW:				/* Virtual Row		*/
		wm_vrvc(vc, &r, &c);
		dz2_format(r, &pline[pos]);
		break;
	  case VCOL:				/* Virtual Column	*/
		wm_vrvc(vc, &r, &c);
		dz2_format(c, &pline[pos]);
		break;
	  case TRACKING:			/* Tracking Style	*/
		WM_PK(0, vc, VS_CUR_TRACK, &value);
		index = value & 0x0001;
		copy_bytes(&pline[pos], ptrack[index], strlen(ptrack[index]));
		break;
	  case DISPLAY:				/* Display to use	*/
		WM_PK(0, vc, VS_CRT_SEG, &value);
		index = (value == 0xb000) ? 0 : 1;
		copy_bytes(&pline[pos], pdisp[index], strlen(pdisp[index]));
		break;
	  case FGCOLOR:				/* Foreground Color	*/
		WM_PK(0, vc, VS_ATTRIB, &value);
		index = value & 0x0007;
		copy_bytes(&pline[pos], pcolors[index], strlen(pcolors[index]));
		break;
	  case BGCOLOR:				/* Background Color	*/
		WM_PK(0, vc, VS_ATTRIB, &value);
		index = (value & 0x0070) >> 4;
		copy_bytes(&pline[pos], pcolors[index], strlen(pcolors[index]));
		break;
	} /* switch */

	return; 
}


