/*	SAMPLE.C	11/10/83-11/11/83	LEE JAY LORENZEN	*/

/*** INCLUDE FILES ******************************************************/

#include <portab.h>
#include <caparm.h>


/*** DEFINES ***********************************************************/

#define ESCAPE 0x1b
#define BACKSPACE 0x08
#define UP 0x05
#define DOWN 0x18
#define LEFT 0x13
#define RIGHT 0x04

#define P_TERMCPM 0x00
#define C_WRITE 0x02
#define C_RAWIO 0x06
#define C_WRITEBLK 0x6f
#define C_WRITESTR 0x09
#define C_GET 0x99
#define S_OSVER 0xa3

#define VERSION 0x31

#define VS_TOP_LEFT 2
#define VS_BOT_RIGHT 4
#define VS_WIN_SIZE 12
#define VS_VC_SEG 22
#define VS_TRUE_VIEW 42

#define IO_SWITCH 0x07
#define IO_NEW_WINDOW 0x14


/*** STRUCTURES DECLARATIONS ******************************************/

struct chcb
{
	BYTE		*c_offset;
	WORD		c_segment;
	WORD		c_length;
}; 


/*** EXTERNAL FUNCTION DECLARATIONS ***********************************/

EXTERN VOID GENCOPY();				/* in WMCA.A86		*/
EXTERN VOID GENALT();

EXTERN VOID WM_PK();				/* in WWCALL.A86	*/
EXTERN VOID WM_CALL();
EXTERN VOID IO_CALL();
EXTERN VOID WM_MXQ();


/*** GLOBAL VARIABLES *************************************************/

WORD	vc_number;
WORD	vc_segment;
WORD	ds;

	 	
/*** SUB FUNCTIONS *******************************************************/



/*** VERSION CHecK routine ********************************************/
	
	WORD
version_chk()
{
	UWORD		ret;
						/* do something	that	*/
						/*   verifies this is	*/
						/*   Concurrent CP/M	*/
						/*   3.1 with an XIOS	*/
						/*   that supports 	*/
						/*   windows		*/
	ret = __BDOS(S_OSVER, 0x0);
	if ( ret != VERSION )
	  return(FALSE);
	else
	{
	  return(TRUE);
	}
}


/*** Window Manager Number of Rows and Number of Columns routine **********/

	VOID
wm_nrnc(vc, pnr, pnc)
	WORD		vc;
	WORD		*pnr;
	WORD		*pnc;
{
	WORD		value,tl,br;

	WM_PK(0, vc, VS_TOP_LEFT, &tl);
	WM_PK(0, vc, VS_BOT_RIGHT, &br);
	WM_PK(0, vc, VS_WIN_SIZE, &value);

	*pnc = value & 0x00ff;
 	*pnr = (value & 0xff00) >> 8;

	if ( ( tl == 0x0000 ) &&
	     ( br == 0x174f )   )
	{
	  *pnc = 80;
	  *pnr = 24; 
	}

	return;
}


/*** Window Manager View Row and View Column routine **********************/

	VOID
wm_vrvc(vc, pvr, pvc)
	WORD		vc;
	WORD		*pvr;
	WORD		*pvc;
{
	WORD		value;

	WM_PK(0, vc, VS_TRUE_VIEW, &value);

	*pvc = (value & 0x00ff) + 1;
 	*pvr = ((value & 0xff00) >> 8) + 1;

	return;
}


/*** Window Manager SYNChronize screen image and vc image ***************/

	VOID
wm_sync(number)
	UWORD		number;
{
	UWORD		ax, bx, cx, dx;
	UWORD		imhere, nvc, top;
	UWORD		vr, vc, nr, nc;
						/* if vc is full	*/
						/*   screen and on top	*/
						/*   make sure image and*/
						/*   screen are in sync	*/

	WM_CALL(&imhere, &nvc, &top);
	if ( top == number )
	{
	  wm_nrnc(number, &nr, &nc);
	  wm_vrvc(number, &vr, &vc);
	  if ( (nr == 24) &&
	       (nc == 80) &&
	       (vr == 1) &&
	       (vc == 1)   )
	  {
						/* IO SWITCH to the vc	*/
						/*   that is on top will*/
						/*   cause the vc buffer*/
						/*   to be updated with	*/
						/*   what is on the 	*/
						/*   physical		*/
	    ax = IO_SWITCH;
	    bx = cx = 0;
	    dx = number;
	    IO_CALL(&ax, &bx, &cx, &dx);
	  }
	}
}


/*** DRAW routine *******************************************************/

draw(row, col, length, pstring)
	WORD		row;
	WORD		col;
	WORD		length;
	BYTE		*pstring;
{
	struct ca_parm	src,dest;
	WORD		temp;

	if ( length == 0 )
	  return;
						/* make sure we don't	*/
						/*   wrap		*/
	if ((col + length) > 80)
	  length = 80 - col;
						/* set up copy src	*/
						/*   to point at string	*/
	temp = ((row * 80) + col) * 2;
	src.ca_choffset = pstring;
	src.ca_chsegment = ds;
	src.ca_atoffset = "\007";
	src.ca_atsegment = ds;
	src.ca_chcoladj = 1;
	src.ca_atcoladj = 0;
	src.ca_chrowadj = 0;
	src.ca_atrowadj = 0;
						/* set up copy dest.	*/
						/*   to point to local	*/
						/*   buffer		*/
	temp = ((row * 80) + col) * 2;
	dest.ca_choffset = temp;
	dest.ca_chsegment = vc_segment;
	dest.ca_atoffset = temp + 1;
	dest.ca_atsegment = vc_segment;
	dest.ca_chcoladj = 2;
	dest.ca_atcoladj = 2;
	dest.ca_chrowadj = 0;
	dest.ca_atrowadj = 0;
						/* get mxq		*/
	WM_MXQ(0, vc_number);
						/* do the copy		*/
	GENCOPY(&src, &dest, 1, length);
						/* free up mxq		*/
	WM_MXQ(1, vc_number);
}


/*** ERASE routine ******************************************************/

erase(row, col, length)
	WORD		row;
	WORD		col;
	WORD		length;
{
	struct ca_parm	dest;
	WORD		temp;

	if ( length == 0 )
	  return;
						/* make sure we don't	*/
						/*   wrap		*/
	if ((col + length) > 80)
	  length = 80 - col;
						/* set up alter dest.	*/
						/*   to point to cell	*/
						/*   in vc buffer	*/
	temp = ((row * 80) + col) * 2;
	dest.ca_choffset = temp;
	dest.ca_chsegment = vc_segment;
	dest.ca_atoffset = temp + 1;
	dest.ca_atsegment = vc_segment;
	dest.ca_chcoladj = 2;
	dest.ca_atcoladj = 2;
	dest.ca_chrowadj = 0;
	dest.ca_atrowadj = 0;
						/* get mxq		*/
	WM_MXQ(0, vc_number);
						/* do the copy		*/
	temp = ' ';
	GENALT(&dest, 1, length, 0x0000, (temp << 8) + 0x07);
						/* free up mxq		*/
	WM_MXQ(1, vc_number);
}


/*** DRAW CHaracter routine *********************************************/

draw_ch(row, col, ch)
	WORD		row;
	WORD		col;
	BYTE		ch;
{
	struct ca_parm	dest;
	WORD		temp;

	if ( col > 79 )
	  return;
						/* set up alter dest.	*/
						/*   to point to cell	*/
						/*   in vc buffer	*/
	temp = ((row * 80) + col) * 2;
	dest.ca_choffset = temp;
	dest.ca_chsegment = vc_segment;
	dest.ca_atoffset = temp + 1;
	dest.ca_atsegment = vc_segment;
	dest.ca_chcoladj = 0;
	dest.ca_atcoladj = 0;
	dest.ca_chrowadj = 0;
	dest.ca_atrowadj = 0;
						/* get mxq		*/
	WM_MXQ(0, vc_number);
						/* do the copy		*/
	temp = ch;
	GENALT(&dest, 1, 1, 0x0000, (temp << 8) + 0x07);
						/* free up mxq		*/
	WM_MXQ(1, vc_number);
}


/*** UPDATE PHYSical routine ********************************************/

	VOID
update_phys()
{
	WORD		ax,bx,cx,dx;

	WM_PK(0, vc_number, VS_TOP_LEFT, &cx);
	WM_PK(0, vc_number, VS_BOT_RIGHT, &bx);
	ax = IO_NEW_WINDOW;
	dx = vc_number;
	IO_CALL(&ax, &bx, &cx, &dx);
}


/*** MAIN FUNCTION ******************************************************/

main()
{
	WORD		ret;
	WORD		i;
	BYTE		*ptemp;
	BYTE		curr_string[80];
	BYTE		ch;
	WORD		ch_index;
	WORD		row;
	WORD		col;
	WORD		escape_hit;

						/* do OS version check	*/
	ret = version_chk();
						/* handle error case	*/
						/*   if not right	*/
						/*   version		*/
	if ( !ret )
	{
	  __BDOS(C_WRITESTR, "Need CCP/M version 3.1 to use windows.\r\n$");
	  return;
	}
						/* figure out your	*/
						/*   current data	*/
						/*   segment		*/
	ptemp = 9;
	ds = *ptemp++ + (*ptemp << 8);
						/* get virtual console	*/
						/*   number		*/
	vc_number = __BDOS(C_GET, 0x0);
						/* get segment to your	*/
						/*   virtual console	*/
						/*   screen buffer, the	*/
						/*   offset is always	*/
						/*   0x0		*/
	WM_PK(0, vc_number, VS_VC_SEG, &vc_segment);
						/* if vc is full	*/
						/*   screen and on top	*/
						/*   make sure image and*/
						/*   screen are in sync	*/
	wm_sync(vc_number);
						/* loop until escape is	*/
						/*   hit		*/
	row = 0;
	col = 0;
	ch_index = 0;
	escape_hit = FALSE;
	while ( !escape_hit )
	{
						/* get character	*/
	  ch = __BDOS(C_RAWIO, 0xfd);
						/* do appropriate thing	*/
	  switch(ch)
	  {
	    case ESCAPE:
		escape_hit = TRUE;
		break;
	    case BACKSPACE:
		ch_index--;
		if ( ch_index < 0 )
		  ch_index++;
		else
		{
		  draw_ch(row, col + ch_index, ' ');
		  update_phys();
		}
		break;
	    case UP:
		row--;
		if ( row < 0 )
		  row++;
		else
		{
		  erase(row + 1, col, ch_index); 
		  draw(row, col, ch_index, &curr_string[0]);
		  update_phys();
		}
		break;
	    case DOWN:
		row++;
		if ( row > 23 )
		  row--;
		else
		{
		  erase(row - 1, col, ch_index); 
		  draw(row, col, ch_index, &curr_string[0]);
		  update_phys();
		}
		break;
	    case LEFT:
		col--;
		if ( col < 0 )
		  col++;
		else
		{
		  erase(row, col + 1, ch_index); 
		  draw(row, col, ch_index, &curr_string[0]);
		  update_phys();
		}
		break;
	    case RIGHT:
		col++;
		if ( col > 79 )
		  col--;
		else
		{
		  erase(row, col - 1, ch_index); 
		  draw(row, col, ch_index, &curr_string[0]);
		  update_phys();
		}
		break;
	  }  /* switch */
						/* put out single char	*/
	  if ( (ch >= ' ') &&
	       (ch <= '~') &&
	       (ch_index < 79)  )
	  {
	     draw_ch(row, col + ch_index, ch);
	     curr_string[ch_index++] = ch;
	     update_phys();
	  }

	}  /* while */
}


/*** _MAIN routine *******************************************************/

_main()
{
						/* this minimizes which	*/
						/*   part of the run-	*/
						/*   time library is	*/
						/*   linked in		*/
	main();
	__BDOS(P_TERMCPM, 0);
}

