/* Program to show all files on a specific drive, either CP/M media
   or PC-DOS media.
   This program was compiled under DRC 1.11, requires Concurrent PC-DOS.
   It is designed as a .CMD file, and cannot be used (without modification)
   as a .EXE file.
   Sample usage: TREE		shows the tree of the current drive
                 TREE D:        shows the tree of drive D:

   Dave Rand
   72 Longfellow St.
   Thousand Oaks, CA  91360
   805-493-1987
   76244,51
   Written: 07/10/85

   Modified 8/4/85 Bob Thrush CompuServe PPN 74146,12
      Allow redirection of stdout. This has not been tested with DOS type
      media.
   8/11/85 Bob Thrush
      Added Harry Van Tassel suggestion for \\... CP/M names.
*/

#include <stdio.h>
#include <ctype.h>
#define MAXF 1024  /* Maximum number of files in any directory */
int isdos;
MLOCAL char defdrv,defusr,target_drv;

main(argc,argv)
int argc;
char **argv;
{
 /* Get our default drive/user */
    get_current(&defdrv,&defusr);
    target_drv = defdrv;
    if (argc > 1) {
/* If a drive is supplied, select it */
	target_drv = (argv[1][0] & 0x1f)-1;
	set_du(target_drv,defusr);
    }    

    isdos = media(); /* Determine the media type */
    if (isdos)
	tree("\\");      /* Tree that drive ! */
    else
	tree("User 0");  /* On CPM media, start at user 0 */
    set_du(defdrv,defusr);/* Select the log file drive/user */
}

tree(s) 
char *s;
{
    char *files[MAXF],temp[100];
    int ff,x,t,user;
    static char *mask = " ????????.???";
    
    if (isdos)
	*mask = 0x80;
    else {
	*mask = 0x00;
	sscanf(s,"User %d",&user);
	set_du(target_drv,user);
    }
    
    ff = search(mask,files,MAXF);
    if (ff) {
	sortit(files,ff);
	set_du(defdrv,defusr);
	printf("Current directory: \"%s\"  Number of files = %d",s,ff);
    
	for (x=0 ; x<ff ; x++) {
	    if ((x % 5) == 0)
		printf("\n");
	    printf("%s",files[x]);
	    for (t=15 - strlen(files[x]) ; t>0; t--)
		printf(" ");
	}
	
	printf("\n\n");
	set_du(target_drv,user);

	if (isdos) {
	    for (x=0 ; x<ff ; x++) {
		if ((files[x][0] == '\\') && ((strcmp(files[x],"\\.") != 0)
		    && (strcmp(files[x],"\\..") != 0))) {
		    if (strcmp(s,"\\") != 0)
		        strcpy(temp,s);
		    else
		        strcpy(temp,"");
		    strcat(temp,files[x]);
		    chdir(files[x]);
		    tree(temp);
	        }
	        free(files[x]);
	    }
        }
    }
    if (isdos)
	chdir("\\..");
    else {
	if (user < 15) {
	    sprintf(temp,"User %d",user + 1);
	    tree(temp);
	}
    }
}

chdir(s)
char *s;
{
    char *fcb,*t,*myalloc();
    int x;
    
    fcb = myalloc(32);
    for(x=1 ; x<13; x++)
	fcb[x]=' ';
    
    t=fcb;
    
    *t++ = 0x80;
    s++;
    
    while (*s) *t++ = *s++;
    
    __BDOS(15,fcb);
    free(fcb);
}

char *myalloc(x)
int x;
{
    char *zalloc(),*s;
    
    if ((s=zalloc(x))==NULL) {
	myprintf("Can't allocate %d bytes.\n",x);
	exit(1);
	set_du(defdrv,defusr);
    }
    return(s);
}

int search(mask,files,max)
char *mask;
char **files;
int max;
{
    char fcb[40],*myalloc(),buffer[128],buf1[100];
    int temp,ret,curoff;
	    
    curoff = 0;
    ret = 0;
    if (makfcb_(fcb,mask)==0) {
	__BDOS(26,buffer);
	temp = __BDOS(17,fcb);
	while (temp != 0xff && ret < max) {
	    move_(buf1,&buffer[temp * 32]);
	    files[curoff] = myalloc(strlen(buf1)+1);
	    strcpy(files[curoff],buf1);
	    curoff++;
	    ret++;
	    *fcb = *mask;
	    temp = __BDOS(18,fcb);
	}
    }
    return(ret);
}

makfcb_(d,s)
char *s,*d;
{
    register char c;
    int x;
    
    *d++= *s++;
    
    for (x=0;x<8;x++) {
	c=toupper(*s);
	if (c!='.' && c!='\0') {
	    *d++=c;
	    s++;
	} else
	    *d++=' ';
    }
    if (c)
	s++;
    
    for (x=0;x<3;x++) {
	c=toupper(*s);
	if (c!='\0') {
	    *d++=c;
	    s++;
	} else
	    *d++=' ';
    }
    for (x=12;x<36;x++)
	*d++='\0';
    return(0);
}	
	    
	
VOID move_(d,s)
char *s,*d;
{
    register int c;
    int x;

    if (isdos && (s[0x10] & 0x40))
	*d++ = '\\';

    s++;
    for (x=0;x<8;x++) {
	c=*s++ & 127;
	if (c!=' ')
	    *d++=c;
    }
    if (( *s & 127) != ' ')
	*d++='.';
    
    for (x=0;x<3;x++) {
	c=*s++ & 127;
	if (c!=' ') 
	    *d++=c;
    }
    
    *d='\0';
    
}
	
sortit(files,number)
char **files;
int number;
{
    int comp_();
    qsort(files,number,sizeof(char *),comp_);
}

comp_(a,b)
char **a,**b;
{
    return(strcmp(*a,*b));
}

media() {
    int med;
    static char *fcb="????????????                              ";
    char buff[128];
    
    __BDOS(26,buff);
    
    for (med = 12; med < 35; med++)
	fcb[med]='\0';

    med = 0;  /* Assume CPM media */
    
    if (__BDOS(17,fcb) != 255) {
    
	if (buff[0] == 0x20) {  /* we got a label, check further */
	    if (buff[15] == 0x80)
		med = 1;        /* we have PC DOS media in place! */
	}
    }
    return(med);
}

/* Obtain the current drive/user combo */
VOID get_current(cdrv,cuser)
char *cdrv,*cuser;
{
    *cdrv = __BDOS(25);		/* Get our current drive */    
    *cuser = __BDOS(32,0xff);	/* Get our current user */
}
/* Set the drive/user combo */
VOID set_du(ndrv,nuser)
char ndrv,nuser;
{
    __BDOS(14,ndrv);	/* Reselect the drive */
    __BDOS(32,nuser);	/* Reselect the user */
}

/* Special printf that logs to default drive/user before printing
 * and then returns to original drive/user.
 * The reason for this guy is to allow redirection of stdout and
 * allow the application to reselect the drive/user.
 * **** NOTE **** This routine will only work correctly with up to
 * 4 'int' type arguments. 
 */
myprintf(fmt,a1,a2,a3,a4)
char	*fmt;
int	a1,a2,a3,a4;
{
    char curdrv,curusr;

    if (isdos == 0) {
	get_current(&curdrv,&curusr);
	set_du(defdrv,defusr);
	printf(fmt,a1,a2,a3,a4);
	set_du(curdrv,curusr);
    }
    else printf(fmt,a1,a2,a3,a4);

}
