@echo off
rem
rem Aufruf (unter Windows):
rem wbackup [Backup-Nummer]
rem (Der Parameter in eckigen Klammern ist optional.)
rem
rem (c) Marco Vieth, 1998
rem
rem 1.1  18.06.1998
rem 1.2  31.01.1999
rem 1.3  06.02.1999
rem 1.4  22.05.1999
rem 1.5  17.08.2000 (only wcd.bat has changed)
rem 1.6  21.08.2001 allow backup on any drive
rem
echo WinBackup (v1.6) - speichert C:\WINDOWS und C:\Programme [PROGRA~1]
echo unter LW:\BAK_WINx bzw. LW:\BAK_PRGx
echo Marco Vieth, 21.08.2001 (http://www.benchmarko.de/)

rem Check that we are running under Windows
if "%winbootdir%"==""  goto E_NO_WIN

rem Check that TMP directory exists
if not exist "%TMP%\NUL"  echo Warnung: TMP-Verzeichnis existiert nicht.

rem Check that WINDOWS and Programme exist
if not exist C:\WINDOWS\NUL goto E_NO_WDIR
if not exist C:\Programme\NUL goto E_NO_PRGDIR

rem Check that no wininit.ini exist
if exist C:\WINDOWS\WININIT.INI  goto E_WINIT_EX
:START1

rem We do not expect more than 1 parameter
if not "%2"==""  echo Warnung: Parameter "%2" ignoriert!

set DRIVE_L=C

rem Optional parameter 1: backup number
set BACKUP_NUM=%1
if not "%1"==""  goto WBACKUP0

echo.
echo Bitte Ziellaufwerk eingeben (normalerweise C)
set DRIVE_L=0
choice /c:ABCDEFGHIJKLMNOPQRSTUVWXYZ "Laufwerkbuchstabe "
rem the following IFs are ">=" comparisions
if errorlevel 1  set DRIVE_L=A
if errorlevel 2  set DRIVE_L=B
if errorlevel 3  set DRIVE_L=C
if errorlevel 4  set DRIVE_L=D
if errorlevel 5  set DRIVE_L=E
if errorlevel 6  set DRIVE_L=F
if errorlevel 7  set DRIVE_L=G
if errorlevel 8  set DRIVE_L=H
if errorlevel 9  set DRIVE_L=I
if errorlevel 10 set DRIVE_L=J
if errorlevel 11 set DRIVE_L=K
if errorlevel 12 set DRIVE_L=L
if errorlevel 13 set DRIVE_L=M
if errorlevel 14 set DRIVE_L=N
if errorlevel 15 set DRIVE_L=O
if errorlevel 16 set DRIVE_L=P
if errorlevel 17 set DRIVE_L=Q
if errorlevel 18 set DRIVE_L=R
if errorlevel 19 set DRIVE_L=S
if errorlevel 20 set DRIVE_L=T
if errorlevel 21 set DRIVE_L=U
if errorlevel 22 set DRIVE_L=V
if errorlevel 23 set DRIVE_L=W
if errorlevel 24 set DRIVE_L=X
if errorlevel 25 set DRIVE_L=Y
if errorlevel 26 set DRIVE_L=Z


rem Now we use BACKUP_NUM as selection list
if exist %DRIVE_L%:\BAK_WIN0\NUL  set BACKUP_NUM=%BACKUP_NUM% 0
if exist %DRIVE_L%:\BAK_WIN1\NUL  set BACKUP_NUM=%BACKUP_NUM% 1
if exist %DRIVE_L%:\BAK_WIN2\NUL  set BACKUP_NUM=%BACKUP_NUM% 2
if exist %DRIVE_L%:\BAK_WIN3\NUL  set BACKUP_NUM=%BACKUP_NUM% 3
if exist %DRIVE_L%:\BAK_WIN4\NUL  set BACKUP_NUM=%BACKUP_NUM% 4
echo.
echo Existierende Backups auf Laufwerk %DRIVE_L%: %BACKUP_NUM%
echo.
choice /C:01234e "Nummer des zu erstellenden Backups (E=Ende) "
rem the following IFs are ">=" comparisions
set BACKUP_NUM=0
if errorlevel 1  set BACKUP_NUM=0
if errorlevel 2  set BACKUP_NUM=1
if errorlevel 3  set BACKUP_NUM=2
if errorlevel 4  set BACKUP_NUM=3
if errorlevel 5  set BACKUP_NUM=4
if errorlevel 6  goto EXIT

:WBACKUP0
set BACKUP_WIN=%DRIVE_L%:\BAK_WIN%BACKUP_NUM%
set BACKUP_PRG=%DRIVE_L%:\BAK_PRG%BACKUP_NUM%

if exist %BACKUP_WIN%\NUL goto BACKUP1
if not exist %BACKUP_PRG%\NUL goto BACKUP2
:BACKUP1
echo Warnung: Backup %BACKUP_NUM% existiert bereits.
choice "berschreiben "
rem "ja"
rem if errorlevel 1 goto ???
rem "nein"
if errorlevel 2 goto EXIT

echo Lsche zuerst altes Backup %BACKUP_WIN%, %BACKUP_PRG%...
deltree /Y %BACKUP_WIN%
if errorlevel 1  echo Fehler beim Lschen von "%BACKUP_WIN%"
deltree /Y %BACKUP_PRG%
if errorlevel 1  echo Fehler beim Lschen von "%BACKUP_PRG%"

:BACKUP2
rem
rem Now we can create the backup.
rem We cannot use a subdirectory (e.g. C:\BACKUP\WINDOWS) since we
rem cannot move it to C:\WINDOWS in case of restoration.
rem So we use C:\BAK_WIN? (and C:\BAK_PRG?).
rem

echo Kopiere Verzeichnis C:\WINDOWS nach %BACKUP_WIN%...
echo (Die folgende Fehlermeldung zu Datei win386.sys ist normal!)
xcopy C:\WINDOWS\*.* %BACKUP_WIN%\*.* /s/e/h/c/k > %TMP%\WBACKUP.TMP
if errorlevel 2  goto E_XCOPY
set BACKUP_LOG=%BACKUP_WIN%\WBACKUP.LOG
if exist %BACKUP_LOG%  goto BACKUP3
echo *** Backup log started as "%BACKUP_LOG%" > %BACKUP_LOG%
:BACKUP3
type %TMP%\WBACKUP.TMP >> %BACKUP_LOG%
del %TMP%\WBACKUP.TMP
echo *** Backup %BACKUP_NUM% created on... >> %BACKUP_LOG%
rem Fast hack to show date/time
dir %BACKUP_LOG% >> %BACKUP_LOG%

echo Kopiere Verzeichnis C:\Programme" nach %BACKUP_PRG%...
xcopy C:\Programme\*.* %BACKUP_PRG%\*.* /s/e/h/c/k > %TMP%\WBACKUP.TMP
if errorlevel 2  goto E_XCOPY
set BACKUP_LOG=%BACKUP_PRG%\WBACKUP.LOG
if exist %BACKUP_LOG%  goto BACKUP4
echo *** Backup log started as "%BACKUP_LOG%" > %BACKUP_LOG%
:BACKUP4
type %TMP%\WBACKUP.TMP >> %BACKUP_LOG%
del %TMP%\WBACKUP.TMP
echo *** Backup %BACKUP_NUM% created on... >> %BACKUP_LOG%
rem Fast hack to show date/time
dir %BACKUP_LOG% >> %BACKUP_LOG%

rem Set read only and hidden attributes...
rem (4dos attrib needs /D option, so force to use DOS "attrib")
"attrib" +R +H %BACKUP_WIN%
"attrib" +R +H %BACKUP_PRG%

echo Fertig.
goto EXIT


:E_NO_WIN
echo Fehler: Backup bitte nur unter Windows erstellen, damit lange
echo Dateinamen mitgesichert werden!
goto ERREXIT

:E_NO_WDIR
echo Fehler: Verzeichnis "C:\WINDOWS" nicht gefunden.
goto ERREXIT

:E_NO_PRGDIR
echo Fehler: Verzeichnis "C:\Programme" nicht gefunden.
goto ERREXIT

:E_WINIT_EX
echo Warnung: Die Datei "C:\WINDOWS\WININIT.INI" existiert, d.h.
echo Windows mchte Dateien beim Neustart aktualisieren.
echo Mchten Sie trotzdem ein Backup erzeugen?
choice
rem "nein"
if errorlevel 2 goto EXIT
rem "ja"
if errorlevel 1 goto START1
goto ERREXIT

:E_XCOPY
if errorlevel 5  goto E_XCOPY5
if errorlevel 4  goto E_XCOPY4
if errorlevel 2  goto E_XCOPY2
echo Fehler bei xcopy.
goto ERREXIT

:E_XCOPY5
echo xcopy-Schreibfehler.
goto ERREXIT

:E_XCOPY4
echo xcopy-Initialisierungsfehler (kein Speicher?).
goto ERREXIT

:E_XCOPY2
echo Abbruch durch Benutzer.
goto ERREXIT

:ERREXIT
echo Es ist ein Fehler aufgetreten im Programm "%0"
rem pause
goto EXIT

:EXIT
rem Unset the variables
set DRIVE_L=
set BACKUP_NUM=
set BACKUP_WIN=
set BACKUP_PRG=
set BACKUP_LOG=
