//: SYMTAB.H - Symbol Table
//.
// Marco Vieth, 17.12.1995
//

#ifndef SYMTAB_H_
#define SYMTAB_H_

#include "sna2_gen.h"

class symtab {
 int max_code;	// actual code for next name to insert
 enum { TABLSZ = 23 };
 struct name {
   char *string;
   int code;
   name *next;
 };
 name *table[TABLSZ];
public:
  int /* near */ look(const char *s, int insert = 0);
  int insert(const char *s) { return(look(s, 1)); }
  symtab(void);
  ~symtab(void);
};


#endif				// SYMTAB_H_
//end of SYMTAB.H
