//: SCAN.H - Scan the Configuration
//.
// Marco Vieth, 17.12.1995
//

#ifndef SCAN_H_
#define SCAN_H_

#include "sna2_gen.h"	// general prototypes, defines
#include <fstream.h>	// ifstream

class scan : public ifstream {
private:
  enum { TABSIZE = 8 };
  int number;			// number, if token is one
  char name[MAXSTRLEN];		// name, if token is a string
  int col, line;		// actual column, line
  int t_col;			// scan start column
  int errors;			// number of errors/warnings

  int near get_number(const int radix);
  void update_linecol(const char ch) {
    col++;
    if (ch == '\n') { col = 0; line++; }
    else if (ch == '\t')  col += TABSIZE - (col % TABSIZE);
  };
public:
  enum scan_e { NOTOK, NAME, NUMBER, STRING, EQUAL, COMMA, ENDTOK };
  scan_e get_scan(void);
  char near *get_str(void) { return(name); }
  int near get_num(void) { return(number); }
  void flush_line(void);
#ifdef DEBUG
  void near test_tok(enum scan_e te);
#endif
//  static ErrCode errout(const char *message);
  int warnout(const char *msg1, const char *tok_txt = "");
  int get_errors(void) { return (errors); }
  scan(void);
  ~scan(void);
};

#endif				// SCAN_H_
//end of SCAN.H
