//: DATA.H - Read Data File
//.
// Marco Vieth, 27.1.1997
//

#ifndef SNA2_D1_H_
#define SNA2_D1_H_

#include "sna2_gen.h"	// general prototypes, defines
#include "sna2_s1.h"

class data : scan {
  static char *d_data_file;
  int d_errors;			// number of errors found
public:
  enum { MAXTOKEN = 7 };
private:
  enum TOKENS {
    NOTOKEN,
    KEYTAB_UK, KEYTAB_GR, KEYTAB_FR, KEYTAB_SP,
    RGB_PAL_GREEN, RGB_PAL_COLOUR
  };
  static char *data_token[MAXTOKEN];
  ErrCode near accept_equal(void);
  ErrCode near accept_comma(const enum TOKENS tok);
  ErrCode near read_one_num(int *num, const enum TOKENS tok);
  ErrCode near read_pal(const enum TOKENS tok);
  ErrCode near read_keytab(const enum TOKENS tok);
  ErrCode read(void);
public:
  static const char *get_datafile(void) { return(d_data_file); }
  static ErrCode set_datafile(const char *fname);
  data(void);
  int errors(void) { return(d_errors); }
  ~data(void);
};

#endif				// SNA2_D1_H_
//end of sna2_d1.H
