//: SNA2_D1.CPP (v1.1) (data part)
//. Part of SNA2GIF
//
// Marco Vieth, 27.1.1997
//

#include <stdio.h> 	// sprintf(), perror()
#include <string.h>	// for strlen()
#include <iostream.h>

#include "sna2_d1.h"
#include "sna2_gen.h"
#include "sna2_s1.h"	// scan
#include "sna2gif.h"	// screen
#include "sna2_s2.h" 	// symtab



//#define DEBUG

char *data::d_data_file = (char *)0;
char *data::data_token[data::MAXTOKEN] = {
  "NO TOKEN", "KEYTAB_UK", "KEYTAB_GR", "KEYTAB_FR", "KEYTAB_SP",
  "RGB_PAL_GREEN", "RGB_PAL_COLOUR"
};


class keyboard {
public:
  enum { keytab_size = 4*117 };
};


ErrCode data::set_datafile(const char *name) {
  if (d_data_file != (char *)0) {
    delete d_data_file;
  }
  d_data_file = new char[strlen(name)+1];
  if (d_data_file == (char *)0) return ERROR;	// no mem!
  strcpy(d_data_file, name);
  return OK;
}


data::data(void) : scan() {
  d_errors = 0;
  cout << "DATA: Using " << d_data_file << endl;
  open(d_data_file);
  if (ios::fail()) { perror(d_data_file); d_errors++; }
  else {
    d_errors = data::read();
    if (d_errors) {
      cout << "DATA: " << d_errors << " errors found." << endl;
    }
  }
}

data::~data(void) {
}



// same as in config
ErrCode near data::accept_equal(void) {
  if (get_scan() != scan::EQUAL) {
    warnout("'=' expected");
    return ERROR;
  }
  return OK;
}

// same as in config
ErrCode near data::accept_comma(const enum TOKENS tok) {
  if (get_scan() != scan::COMMA) {
    warnout("',' expected", data_token[tok]);
    return ERROR;
  }
  return OK;
}


// same as in config
ErrCode near data::read_one_num(int *num, const enum TOKENS tok) {
  if (get_scan() == scan::NUMBER) {
    *num = scan::get_num();
    return OK;
  }
  else {
    warnout("not a value", data_token[tok]);
    return ERROR;
  }
}


ErrCode near data::read_pal(const enum TOKENS tok) {
  byte pal_tab[screen::paltab_size];
  int x1;
  for (int i = 0; i < screen::paltab_size; i++) {
    if (read_one_num(&x1, tok)) return ERROR;
    if ((i + 1) < screen::paltab_size) {
      if (accept_comma(tok)) return ERROR;
    }
    pal_tab[i] = x1;
  }
  const int colour_flg = ((tok == RGB_PAL_COLOUR) ? 1 : 0);
  screen::set_paltab(colour_flg, pal_tab);
  return OK;
}


ErrCode near data::read_keytab(const enum TOKENS tok) {
//  byte key_tab[keyboard::keytab_size];
  int x1;
  for (int i = 0; i < keyboard::keytab_size; i++) {
    if (read_one_num(&x1, tok)) return ERROR;
    if ((i + 1) < keyboard::keytab_size) {
      if (accept_comma(tok)) return ERROR;
    }
//    key_tab[i] = x1;
  }
  //const int lang =  ((tok == KEYTAB_UK) ? 0 : (tok == KEYTAB_GR) ? 1 :
  // (tok == KEYTAB_FR) ? 2 : 3);
  // keyboard::set_keytab(lang, key_tab);
  return OK;
}



ErrCode data::read(void) {
  symtab st;
  for (int i = 0; i < MAXTOKEN; i++) {
    int code = st.insert(data_token[i]);  // insert keywords in symbol table
    if (code != i)  cerr << "Error: Wrong hashcode " << i << endl;
  }


#ifdef DEBUG
  cout << "data::read:  tellg()=" << tellg() << endl;
  cout << "peek()=" << peek() << endl;
#endif

  enum scan::scan_e te;
  while (((te = get_scan()) != scan::ENDTOK) && (scan::get_errors() < 32)) {
    enum TOKENS curr_tok;		// current token
    if (te != scan::NAME) {
      warnout("no keyword");
      scan::flush_line();
      curr_tok = NOTOKEN;
    }
    else if ((curr_tok = (enum TOKENS)st.look(scan::get_str())) == NOTOKEN) {
      char buf[MAXSTRLEN];
      sprintf(buf, "unknown keyword %s", scan::get_str());
      warnout(buf);
      scan::flush_line();
    }

    if (curr_tok != NOTOKEN) {
      if (accept_equal())  { curr_tok = NOTOKEN; }
    }
    switch (curr_tok) {
      case NOTOKEN:
      break;

      case KEYTAB_UK:
      case KEYTAB_GR:
      case KEYTAB_FR:
      case KEYTAB_SP:
	if (read_keytab(curr_tok)) scan::flush_line();
      break;

      case RGB_PAL_GREEN:
      case RGB_PAL_COLOUR:
	if (read_pal(curr_tok)) scan::flush_line();
      break;

      default:
	warnout("error token");
      break;
    }
  }
  return(scan::get_errors());
}

// -----------


// End of SNA2_D1.CPP
