;RAMDISC (v1.0) - Die RamDisc (Laufwerk C)
;12.4.1990
;
;fuer CPC 6128 bzw. CPC 464/664 mit Speichererweiterung
;
nolist
;write"RAMDISC.BIN"

;
ORG #A000
;RAMDISCINIT
LD HL,DISCPATCH;Patch fuer Disc-Routinen
LD (&BE80),HL;eintragen
LD A,&C3
LD (&BE7F),A;Jp-Code
LD HL,KERNELBUFF
LD BC,RSXTABELL
JP &BCD1;KL LOG EXT (RSX-Erweiterung einhaengen)
;
;Grundproceduren im zentralen Ram
;

RAMSET
PUSH BC;SICH
LD B,#7F
OUT (C),A;SET
POP BC;ZUR.
RET

RAMNOR;normales Ram wiedereinschalten
PUSH AF
LD A,#C0
CALL RAMSET
POP AF
RET

RAMSELECT
PUSH AF
LD A,&C4;Ram mit Steuerprogramm
CALL RAMSET
POP AF
RET

RAMDICALL; Ram Di
CALL RAMNOR;normales Ram &C0
CALL &000E;Call (BC) = Routine ausfuehren
JP RAMSELECT;Steuerram &C4 select

RAMDIJP
CALL RAMNOR
JP (BC)
;
;Byte C aus 2.Speicher get(HL=Banadr,A=Bank)
BYTEGET
CALL RAMSET
LD C,(HL);Byte nach C
JP RAMNOR
;Byte C in 2.Speicher put(HL=Banadr,A=Bank)
BYTEPUT
CALL RAMSET
LD (HL),C
JP RAMNOR
;
;
;fuer gepatchte Disc-Routinen
DISCPATCH CALL RAMSELECT
JP DPATCH2;im Steuerram
;
RSXTABELL
DEFW TABLE;ADR KOMMANDOTABELLE
JP DRIVEC;Laufwerk C select
JP DRIVE
JP DIR
JP ERA
JP REN
;
KERNELBUFF DEFS 4
;
TABLE
DEFB "C"+&80
DEFM "DRIV"
DEFB "E"+&80
DEFM "DI"
DEFB "R"+&80
DEFM "ER"
DEFB "A"+&80
DEFM "RE"
DEFB "N"+&80
DEFB 0;ENDE TABELLE
;
;

;unbedingt im Ram
RAMCO3
JP 0;RAMCO4 ODER RAMCO5
;
;
;aus INCLUDE2
;** ROM - taugliche Prozeduren **
;(bei RAM -- im zentralen RAM ab #8000 !!!)

RAMCOPY
CALL RAMSET;SELECT
RAMCO1
PUSH HL;ZIELADR SICH
LD HL,#8000;MAX.ADR
OR A
SBC HL,DE;-ZIELBLOCKADR
PUSH HL;DIFFERENZ SICH
SBC HL,BC;VGL.MIT LAENGE
POP HL;DIFFERENZ
JR C,RAMCO2;WIRKL.LG GROESSER
POP HL;STARTBLOCKADR
JP NZ,RAMCO3;COPY+RET
CALL RAMCO3
RAMINC
LD DE,#4000;NEUER ANFANG
INC A;RAM+1
CP #C8;*** ERWEITERT
JR C,RAMSET;<#C8
LD A,#C4;*** ERW
RAMSET
PUSH BC;SICH
LD B,#7F
OUT (C),A;SET
POP BC;ZUR.
RET
RAMCO2 LD (BCSICH),BC;WIRKL.LG SICH
LD B,H
LD C,L;AKT.LG NACH BC
EX (SP),HL;HL=STARTADR/(SP)=AKT.LG
CALL RAMCO3;KOPIEREN
RAMCOH
EX DE,HL;HL SICH
POP BC;AKT.LG
LD HL,(BCSICH);WIRKL.LG
OR A
SBC HL,BC
LD B,H
LD C,L;REST NACH BC
EX DE,HL;HL ZUR.
CALL RAMINC;NEXT
JR RAMCO1;NOCHMAL

RAMCO4
CALL &B91B;normal Ldir mit Rom's aus
RAMCO5
EX DE,HL
CALL &B91B;Ldir mit Rom's aus
EX DE,HL
RET

RAMPUT
PUSH HL;SICH
LD HL,RAMCO4
LD (RAMCO3+1),HL
POP HL
CALL RAMCOPY
JR RAMNOR

RAMGET
PUSH HL;SICH
LD HL,RAMCO5
LD (RAMCO3+1),HL
POP HL
CALL RAMCOPY
;direkt danach
RAMNOR;NORMALES RAM WIEDEREINSCHALTEN
PUSH AF
LD A,#C0
CALL RAMSET
POP AF
RET
;
;
;
;aus INCLUDE3 (auch im Rom)
;Bankadresse in Adresse wandeln
BANADR
CP #C0;NORMALES RAM?
RET Z;JA=NICHT UMWANDELN
SUB #C4;1.Ramnummer abziehen
AND %00000011;nur Bit 0,1
RRCA
RRCA;nach Bit 6,7
XOR H
AND %11000000;in Adresse hineinschieben
XOR H
LD H,A;setzen
RET

;Adresse in Bankadresse wandeln
ADRBAN
LD A,(RAMON);2.RAM NEHMEN ERLAUBT?
OR A
LD A,#C0;NORMALES RAM
RET NZ;<>0=NICHT ERLAUBT
LD A,H;Adresse HI
AND #C0;nur Bits 6,7
RLCA
RLCA;nach Bit 0,1
ADD A,#C4;1.Ramnummer dazu
PUSH AF;Ram-Konfig.sichern
LD A,H;nochmal Adr HI
AND #3F;MAX.BIS #7FXX
OR #40;6 SET
LD H,A
POP AF
RET
;
;
;Disc-Patch (Disc-Rom ist Ei)
DPATCH2
