#!/usr/bin/perl -w
# bmftp1.pl - BM PerlGen v1.0 - FTP transfer
# Benchmarko Perl Generator for Websites - FTP upload to server
# (c) Marco Vieth, 2001
#
# 1.00  25.09.2001 initial release
# 1.01  28.03.2004 adapted to use Bm package; FTP delete implemented; to do: find over links
# 1.011 22.07.2006 put in one script
#
# Note:
# For some Servers: Use FTP_PASSIVE=1 to use FTP passive mode! (see Net::FTP)
#
  my $VERSION = '1.011';
  use 5.004;
  use strict;

  use Getopt::Std ();
  use File::Find (); # find
  use Net::FTP ();

  #use Bm ();
  #use Bm_finalstat ();

  $::g_debug = 0;

#############



my $bm_nodelete = '^(.*\.log)$'; # do not delete log files

#my %g_rfiles = (); # remote files (not needed any more?)

sub print_entry($$$) {
  my($name, $entry, $out_f) = @_;
  my($ts, $id) = split(' ', $entry, 2);
  printf $out_f "%-12d $id $name\n", $ts;
}


my $g_para_r = {}; # needed for find function

# Called by File::Find::find
# $File::Find::dir   - current directory
# $_                 - current filename within that directory
# $File::Find::name  - complete pathname to the file.
sub ftp_copy_filenames() {
  if (-f $_) {
  #if (-f $File::Find::name) { #??
    my $f_stat = $g_para_r->{'f_stat'};
     $f_stat->add_val('30 - files checked', 1);
    if ($::g_debug) { Bm::debug_msg("ftp_copy_filenames: processing file '$File::Find::name'...", 3); }
    my $ftp = $g_para_r->{'ftp'};
    my $dir = $g_para_r->{'basedir'} .'/'. $File::Find::dir;
    my $out_f = $g_para_r->{'out_f'};

    my $check_new_f = 0;
    if ($File::Find::dir ne $g_para_r->{'lastdir'}) { # new directory?
      Bm::print_msg("Checking dir '$File::Find::dir'...");
      $check_new_f = 1;
      $g_para_r->{'lastdir'} = $File::Find::dir;
    }

    my $entry_sign = '';

    if (!$check_new_f || $ftp->cwd($dir)) {
      if ($check_new_f) { # first time in this directory?
        my $entry_p = $ftp->ls() || []; # empty directory returns also undef! # (Bm::warn_msg("FTP->ls(): '$out_fn'"), return);
        if ($::g_debug) { Bm::debug_msg("ftp: dir='$dir', ls='". ((defined $entry_p) ? join(' ', @$entry_p) : '<undef>') ."'.", 3); }
        foreach my $f1 (@$entry_p) {
          if ($f1 =~ /^\.\.?/o) { next; }
          if (! -r $f1) { # does something not exist locally?
            if ($::g_debug) { Bm::debug_msg("ftp: file does not exist locally: '$f1'.", 1); }
            if ($f1 =~ /$bm_nodelete/o) {
              #$g_rfiles{"$File::Find::dir/$f1"} = "x". " L"; 
              print_entry("$File::Find::dir/$f1", '-1 L', $out_f);
              $f_stat->add_val('41 - files not deleted (nodelete)', 1);
              if ($::g_debug) { Bm::debug_msg("ftp: do not delete file '$File::Find::dir/$f1'", 1); }
            } else {
              #$g_rfiles{"$File::Find::dir/$f1"} = "-1". " D"; # we can delete this file/dir!
              $ftp->delete($f1) || (Bm::warn_msg("FTP->delete($f1)"), return);
              print_entry("$File::Find::dir/$f1", '-1 D', $out_f);
              $f_stat->add_val('40 - files deleted', 1);
            }
          }
        }
      }

      my $time1 = $ftp->mdtm($_) || '0'; # maybe not there
      my($time2) = (stat($_))[9] || '0';
      if ($::g_debug) { Bm::debug_msg("ftp_copy_filenames: modification time: '$time1' (FTP), '$time2' (file '$_')", 4); }
      if ($g_para_r->{'force_flg'} || ($time1 < $time2)) {
        Bm::print_msg( (($time1 > 0) ? "Updating" : "Copying") . " file '$File::Find::name'...");
        $ftp->put($_) || (Bm::warn_msg("FTP->put($_)"), return);
        if ($::g_debug) { Bm::debug_msg("ftp_copy_filenames: file ". (($time1 > 0) ? 'updated' : 'copied') .": '$_'", 0); }
        # $time1 > 0 => got a timestamp from remote file?

        my $t1 = $ftp->mdtm($_) || (Bm::warn_msg("FTP->mdtm($_)"), return);
        #$g_rfiles{$File::Find::name} = $t1 .' '. (($time1 > 0) ? 'U' : 'C');
        $entry_sign = $t1 .' '. (($time1 > 0) ? 'U' : 'C');
        if ($time1 > 0) {
          $f_stat->add_val('32 - files updated', 1);
        } else {
          $f_stat->add_val('31 - files copied', 1);
        }
      } else {
        #$g_rfiles{$File::Find::name} = $time1 .' I';
        $entry_sign = $time1 .' I';
        $f_stat->add_val('34 - files ignored', 1);
      }

    } else {   # if ($g_para{'force_flg'} || (! -f $dest) || -M $src < -M $dest) { }
      my $newdir = $dir;
      $ftp->mkdir($newdir, 1) || (Bm::warn_msg("FTP->mkdir($newdir)"), return);
      if ($::g_debug) { Bm::debug_msg("ftp_copy_filenames: remote directory created: '$newdir'", 0); }
      $ftp->cwd($newdir) || (Bm::warn_msg("FTP->cwd($newdir)"), return);
      Bm::print_msg("Copying file '$File::Find::name'...");
      $ftp->put($_) || (Bm::warn_msg("FTP->put($_)"), return);
      if ($::g_debug) { Bm::debug_msg("ftp_copy_filenames: file copied: '$_'", 0); }
      my $t1 = $ftp->mdtm($_) || (Bm::warn_msg("FTP->mdtm($_)"), return);
      #$g_rfiles{$File::Find::name} = $t1 .' C';
      $entry_sign = $t1 .' C';
      $f_stat->add_val('31 - files copied', 1); 
    }
    ##$ftp->cwd($pwd) || (Bm::warn_msg("FTP->cwd($pwd)"), return);
    #$g_para_r->{'lastdir'} = $File::Find::dir;

    # print entry...
    #print_entry($File::Find::name, $g_rfiles{$File::Find::name}, $out_f);
    print_entry($File::Find::name, $entry_sign, $out_f);
  }
  return 1;
}


sub do_bmftp1($$$$$$) {
  my($ftp_host, $ftp_user, $ftp_passwd, $ftp_location, $d_dir, $force_flg) = @_;
  my $f_stat = Bm_finalstat->new();

  Bm::print_msg("Using source directory '$d_dir'");
  if (! -d $d_dir) {
    Bm::warn_msg("Directory does not exist: '$d_dir'");
    return;
  }

  my $out_fn = "$d_dir/inc_ftp.txt";
  my $out_f = Bm::file_open(">$out_fn") || (Bm::warn_msg("$!: '$out_fn'"), return);
  Bm::file_autoflush($out_f); # we want to see something...
  print $out_f "# Filelist of '$ftp_host:$ftp_location' at '". Bm::get_ltime() ."'\n";


  my $ftp = Net::FTP->new($ftp_host, Debug => 0) || (Bm::warn_msg("FTP->new($ftp_host): $!"), return);
  $ftp->login($ftp_user, $ftp_passwd) || (Bm::warn_msg("FTP->login($ftp_user,<passwd>)"), return);
  if (!$ftp->cwd($ftp_location)) { # dir does not exist?
    $ftp->mkdir($ftp_location, 1) || (Bm::warn_msg("FTP->mkdir($ftp_location)"), return);
    if ($::g_debug) { Bm::debug_msg("remote directory created: '$ftp_location'", 0); }
    $ftp->cwd($ftp_location) || (Bm::warn_msg("FTP->cwd($ftp_location)"), return);
  }
  $ftp->binary() || (Bm::warn_msg("FTP->binary()"), return);
  my $pwd = $ftp->pwd() || (Bm::warn_msg("FTP->pwd()"), return);

  $g_para_r = {
      'basedir' => $pwd,
      'lastdir' => '', # set during find
      'ftp' => $ftp,
      'force_flg' => $force_flg,
      #'ldir' => $ftp_location,
      'out_f' => $out_f,
      'f_stat' => $f_stat,
  };
  File::Find::find(\&ftp_copy_filenames, $d_dir);
  $ftp->quit();

  #my $print_sorted_flg = 0; # unused
  #if ($print_sorted_flg) {
  #  foreach (sort keys %g_rfiles) {
  #    my @ps = split(' ', $g_rfiles{$_});
  #    printf $out_f "%-12d %s %s\n", $ps[0], $ps[1], $_;
  #  }
  #}
  Bm::file_close($out_f) || (Bm::warn_msg("$!: '$out_fn'"), return);
  Bm::print_msg("Filelist written to '$out_fn'.");

  Bm::print_msg("Summary:");
  $f_stat->print_all();
  return 1;
}


#
# main
#
sub main() {
  my %opts = (
   'f' => 0,
   'r' => '',
   'u' => 'anonymous',
   'p' => 'anonymous',
   'l' => "./",
  );
  if (!Getopt::Std::getopts("fr:u:p:l:hd:D", \%opts) or (@ARGV == 0) or exists($opts{'h'})) {
    require File::Basename;
    print STDERR "Usage: ". File::Basename::basename($0) ." [options] <destination dir>\n";
    print STDERR "-r host   : remote host (default: '$opts{'r'}')\n";
    print STDERR "-u user   : user (default: '$opts{'u'}')\n";
    print STDERR "-p passwd : password (default: '$opts{'p'}')\n";
    print STDERR "-l loc    : location directory (default: '$opts{'l'}')\n";
    print STDERR "-f        : force copy\n";
    print STDERR "-D        : dup STDOUT to STDERR\n";
    print STDERR "-h        : help\n";
    print STDERR "-d level  : debug level (0=off, 1=normal, >1=extended)\n";
    print STDERR "\n";
    exit 1;
  }

  if ($opts{'D'}) { # dup flag
    open(STDERR, ">&STDOUT") || (warn("Cannot dup STDOUT to STDERR!\n"));
    select((select(*STDERR), $| = 1)[0]); # needed on some weird Perl 5.6.1 on Windows...
    $| = 1; # set autoflush for STDOUT (normally not needed, but to see messages at correct places...)
  }

  Bm::set_debug($opts{'d'});
  Bm::script_msg();

  if ($::g_debug > 0) {
    print STDERR "DEBUG: Debugging switched on.\n";
    print STDERR "DEBUG: remote host: '$opts{'r'}', user: '$opts{'u'}', passwd: '$opts{'p'}'\n";
    print STDERR "DEBUG: location: '$opts{'l'}'\n";
  }

  my $rc = do_bmftp1($opts{'r'}, $opts{'u'}, $opts{'p'}, $opts{'l'}, $ARGV[0], $opts{'f'});
  return Bm::get_exit_code();
}

exit(main());


# Bm.pm - Module with basic functionality (simplified)
#
# Marco Vieth, 04.04.2004
#
# 1.03  18.03.2004  separated from Bm_base.pm
#
package Bm;
  #$VERSION = '1.03';
  use strict;

######################################

sub set_debug($) {
  #my($debug) = @_;
  if (defined $_[0]) { $::g_debug = $_[0]; } # overwrite only if defined
}


{
  my $prg_preamble_func = sub { '' };
  my @msg_counts = (0, 0, 0, 0, 0, 0); # number of messages (debug, notes, warnings, errors, other, prints) (not initialized?)

  sub set_msg_counts($$$$$$) {
    #my($debug_cnt, $note_cnt, $warn_cnt, $err_cnt, $other_cnt, $print_cnt) = @_;
    @msg_counts = @_;
  }
  # get message counts
  sub get_msg_counts() {
    return @msg_counts;
  }

  sub _msg_out1($$$$) {
    #my($message, $msg_level, $preamble, $out_f) = @_;
    print { $_[3] } ($prg_preamble_func ? &{$prg_preamble_func} : '') . $_[2] . $_[0] ."\n";
    $msg_counts[$_[1]]++;
  }

  # debug_msg - print a debug message
  sub debug_msg($$;$) {
    #my($message, $level, $preamble) = @_;
    if (($::g_debug > ($_[1] || 0)) && $_[0]) { # level > debug level, message not empty?
      _msg_out1($_[0], 0, ($_[2]) ? $_[2] .': ' : 'DEBUG('. (($_[1] || 0) + 1) .'): ', *STDERR);
    }
  }

  # note_msg - print a notice message
  sub note_msg($) {
    #my($message) = @_;
    if ($_[0]) { # only if message is not empty
      _msg_out1($_[0], 1, 'NOTE: ', *STDERR);
    }
  }

  # warn_msg - print a warn message
  sub warn_msg($) {
    #my($message) = @_;
    if ($_[0]) {
      _msg_out1($_[0], 2, 'WARNING: ', *STDERR);
    }
  }

  # err_msg - print an error message
  sub err_msg($) {
    #my($message) = @_;
    if ($_[0]) {
      _msg_out1($_[0], 3, 'ERROR: ', *STDERR);
    }
  }

  # print_msg - print a standard message (to stdout)
  sub print_msg($) {
    #my($message) = @_;
    if ($_[0]) {
      _msg_out1($_[0], 5, '', *STDOUT);
    }
  }
}

#
# get_ltime -  get local time
# IN : [timeval]
# OUT: ($sec, $min, $hour, $day, $mon, $year)
# Get the current local time time, either as a string or in components.
#
sub get_ltime(;$) {
  #my($val) = @_;
  my ($sec, $min, $hour, $day, $month, $year) = localtime((defined $_[0]) ? $_[0] : time());
  if (wantarray) {
    return (sprintf("%02d", $sec), sprintf("%02d", $min), sprintf("%02d", $hour), sprintf("%02d", $day),
      sprintf("%02d", $month + 1), sprintf("%04d", $year + 1900));
  } else {
    return sprintf("%02d.%02d.%04d %02d:%02d:%02d", $day, $month + 1, $year + 1900, $hour, $min, $sec);
  }
}


sub file_open($) {
  #my($fname) = @_;
  local *FH;
  open(FH, $_[0]) || return;
  return *FH;
}

sub file_autoflush($) {
  #my($fh) = @_;
  select((select($_[0]), $| = 1)[0]);
}

sub file_close($) {
  #my() = @_;
  CORE::close($_[0]);
}


sub dir_open($) {
  #my($dname) = @_;
  local *FH;
  opendir(FH, $_[0]) || return undef();
  return *FH;
}

sub get_exit_code() {
  #my() = @_;
  my($warn_cnt, $err_cnt) = (get_msg_counts())[2,3]; # get number of warnings, errors
  return (wantarray) ? ($err_cnt, $warn_cnt) : $err_cnt + $warn_cnt;
}

sub script_msg(;$$) {
  #my($stop_f, $script) = @_;
  if (!$_[0]) {
    set_msg_counts(0, 0, 0, 0, 0, 0); # initialize
  }
  return get_exit_code();
}

1;


#
# Bm_finalstat.pm - Final Statistics
#
# Marco Vieth, 04.04.2004
#
# 0.01  04.04.2004 taken from Mystat
# 0.011 22.07.2006 simplified
#
package Bm_finalstat;
  #$VERSION = '0.011';
  use strict;

######################################


sub new {
  my $class = shift;
  my $self = bless({}, $class);
  $self->_init(@_);
}

#($)
sub _init {
  my $self = shift;
  return $self;
}


#($$)
sub set_val {
  my($self, $key, $value) = @_;
  $self->{$key} = $value;
  return 1;
}

#($$)
sub add_val {
  my($self, $key, $value) = @_;
  $self->{$key} += $value;
  return 1;
}


#($)
sub get_val {
  my($self, $key) = @_;
  return $self->{$key};
}


#()
sub print_all {
  my($self) = @_;
  foreach my $i (sort keys %$self) {
    print "$i: $self->{$i}\n";
  }
}

1;

__END__
