#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/inode.h"
#include "../h/buf.h"
#include "../h/signal.h"
#include "../h/370.h"

#define PTEXT (PZERO - 2)

/*
 * relinquish use of the shared text segment
 * of a process.
 */
xfree()
{
	register struct text *xp;
	register struct inode *ip;

	if((xp=u.u_procp->p_textp) == NULL)
		return;
	xlock(xp);
	xp->x_flag &= ~XLOCK;
	u.u_procp->p_textp = NULL;
	u.u_tseg.u_pages = NULL;
	u.u_tseg.u_size = 0;
	ip = xp->x_iptr;
	if(--xp->x_count==0 && (ip->i_mode&ISVTX)==0) {
		xp->x_iptr = NULL;
		freesgs(&xp->x_tseg);
		ip->i_flag &= ~ITEXT;
		if (ip->i_flag&ILOCK)
			ip->i_count--;
		else
			iput(ip);
	}
}

/*
 * Attach to a shared text segment.
 * If there is no shared text, just return.
 * If there is, hook up to it:
 * if it is not currently being used, it has to be read
 * in from the inode (ip); the written bit is set to force it
 * to be written out as appropriate.
 * If it is being used, but is not currently in core,
 * a swap has to be done to get it back.
 */
xalloc(ip)
register struct inode *ip;
{
	register struct text *xp;
	register unsigned ts;
	register struct text *xp1;

	if(u.u_exdata.ux_tsize == 0)
		return;
	xp1 = NULL;
	for (xp = &text[0]; xp < &text[NTEXT]; xp++) {
		if(xp->x_iptr == NULL) {
			if(xp1 == NULL)
				xp1 = xp;
			continue;
		}
		if(xp->x_iptr == ip) {
			xp->x_count++;
			while (xp->x_allin == 0)
				sleep((caddr_t) xp, PTEXT);
			u.u_procp->p_textp = xp;
			u.u_tseg = xp->x_tseg;
			return;
		}
	}
	if((xp=xp1) == NULL) {
		printf("out of text\n");
		psignal(u.u_procp, SIGKILL);
		return;
	}
	xp->x_flag = XLOAD|XLOCK;
	xp->x_count = 1;
	xp->x_iptr = ip;
	xp->x_allin = 0;
	ip->i_flag |= ITEXT;
	ip->i_count++;
	ts = btoc(u.u_exdata.ux_tsize);
	u.u_procp->p_textp = xp;
	u.u_tseg.u_pages = NULL;
	u.u_tseg.u_size = 0;
	sbreak1((int) ts, &u.u_tseg);
	if (ip->i_mode&ISVTX) {
		u.u_dseg.u_pages = NULL;
		u.u_dseg.u_size = 0;
		sbreak1((int) btoc(u.u_exdata.ux_dsize), &u.u_dseg);
		xp->x_exdata = u.u_exdata;
	}
	mkstab(&u, 0);     /* for readi/copyout/lra - new segment table not needed due to software lra */
	u.u_count = u.u_exdata.ux_tsize;
	u.u_offset = sizeof (u.u_exdata);
	u.u_base = 0;
	u.u_segflg = 0;
	readi(ip);
	xp->x_tseg = u.u_tseg;
	if (ip->i_mode&ISVTX) {
		u.u_base = (caddr_t) ctob(stoc(ctos(ts)));
		u.u_offset = sizeof (struct u_header) + u.u_exdata.ux_tsize;
		u.u_count = u.u_exdata.ux_dsize;
		readi(ip);
		xp->x_dseg = u.u_dseg;
		u.u_dseg.u_pages = NULL;
		u.u_dseg.u_size = 0;
	}
	xp->x_allin = 1;
	wakeup((caddr_t) xp);
	xp->x_flag = XWRIT;
	protect(&xp->x_tseg, TEXTKEY);
}

/*
 * Lock and unlock a text segment from swapping
 */
xlock(xp)
register struct text *xp;
{

	while(xp->x_flag&XLOCK) {
		xp->x_flag |= XWANT;
		sleep((caddr_t)xp, PSWP);
	}
	xp->x_flag |= XLOCK;
}

xunlock(xp)
register struct text *xp;
{

	if (xp->x_flag&XWANT)
		wakeup((caddr_t)xp);
	xp->x_flag &= ~(XLOCK|XWANT);
}

/*
 * free the swap image of all unused saved-text text segments
 * which are from device dev (used by umount system call).
 */
xumount(dev)
register dev;
{
	register struct text *xp;

	for (xp = &text[0]; xp < &text[NTEXT]; xp++) 
		if (xp->x_iptr!=NULL && dev==xp->x_iptr->i_dev)
			xuntext(xp);
}

/*
 * remove a shared text segment from the text table, if possible.
 */
xrele(ip)
register struct inode *ip;
{
	register struct text *xp;

	if ((ip->i_flag&ITEXT) == 0)
		return;
	for (xp = &text[0]; xp < &text[NTEXT]; xp++)
		if (ip==xp->x_iptr)
			xuntext(xp);
}

/*
 * remove text image from the text table.
 * the use count must be zero.
 */
xuntext(xp)
register struct text *xp;
{
	register struct inode *ip;

	xlock(xp);
	if (xp->x_count) {
		xunlock(xp);
		return;
	}
	ip = xp->x_iptr;
	xp->x_flag &= ~XLOCK;
	xp->x_iptr = NULL;
	freesgs(&xp->x_tseg);
	if (ip->i_mode & ISVTX)
		freesgs(&xp->x_dseg);
	ip->i_flag &= ~ITEXT;
	if (ip->i_flag&ILOCK)
		ip->i_count--;
	else
		iput(ip);
}

/*
 * Check whether ip points to a sticky file already in core.
 */
struct text *
xcheck(ip)
register struct inode *ip;
{
	register struct text *xp;

	for(xp = &text[0]; xp < &text[NTEXT]; xp++)
		if (xp->x_iptr == ip)
			if ((ip->i_mode) & ISVTX && xp->x_allin)
				return(xp);
			else
				return(0);
	return(0);
}

/*
 * Check whether ip points to a non-sticky file already in use.
 */
xinuse(ip)
register struct inode *ip;
{
	register struct text *xp;

	for(xp = &text[0]; xp < &text[NTEXT]; xp++)
		if (xp->x_iptr == ip)
			if (ip->i_mode & ISVTX)
				return(0);
			else
				return(1);
	return(0);
}
