#define BLANK           ' '             /* an ascii blank */
#define ASTERISK        '*'             /* node is defined elsewhere */
#define EOS             '\0'            /* end-of-string */
#define TRUE            't'
#define FALSE           'f'
#define FNLEN           8               /* length of a function name */
#define SON             's'             /* previous node was a parent */
#define BRO             'b'             /* previous node was a brother */

#define VERT_SPACE      3               /* num of columns between boxes */
#define HORIZ_SPACE     3               /* num of lines between boxes */

#define BOX_HEIGHT      3               /* height of box in lines */
#define BOX_WIDTH       (FNLEN + 3)     /* width of box in columns */

#define PAGE_HEIGHT     66              /* number of lines/page */
#define PAGE_WIDTH      132             /* number of cols/page */

#define NODE_HEIGHT     (VERT_SPACE + BOX_HEIGHT)  /* log node height */
#define NODE_WIDTH      (HORIZ_SPACE + BOX_WIDTH)  /* log node width  */

#define NROW            (PAGE_HEIGHT / NODE_HEIGHT)/* # log node rows/page */
#define NCOL            (PAGE_WIDTH / NODE_WIDTH)  /* # log node cols/page */

/*
*  The node structure
*/
struct node {
        struct  node    *n_bro; /* brother pointer */
        struct  node    *n_son; /* son pointer */
        char    n_name[FNLEN+1];/* node's name */
        char    n_comp;         /* flag - T: node is completely defined */
};

/*
*  The display node structure
*/
struct  display {
	struct  node    *d_node;/* ptr to the node */
	char    d_line;         /* type of connecting line */
};
/*
*  Types of connecting lines for a node
*/
#define NOLINE          0               /* just a filler */
#define BROONLY         1               /* only a brother line, no node */
#define SONONLY         2               /* son only */
#define FIRSTSON        3               /* son line and right brother */
#define MIDBRO          4               /* brothers on both sides */
#define LASTBRO         5               /* brother on left only */
#define NLINES          6               /* number of line types */

/*
*  The page image structure
*/
struct page {
        struct  page    *p_down;        /* next page down */
        struct  page    *p_up;          /* next page up */
        struct  page    *p_right;       /* next page right */
        struct  page    *p_left;        /* next page left */
        struct  display p_disp[NROW][NCOL];    /* display blocks */
        int     p_col[NROW];            /* col of next node on this row */
        short   p_prow;         /* row number of position of page */
        short   p_pcol;         /* column number of position of page */
};

/*
*  The cross reference structure
*/
struct xref {
        struct  xref    *x_next;   /* ptr to next xref node */
        struct  xref    *x_same;   /* ptr to duplicate xref nodes */
        short   x_prow;         /* row number of position of page */
        short   x_pcol;         /* column number of position of page */
        short   x_nrow;         /* logical node row number */
        short   x_ncol;         /* logical node column number */
        char    *x_name;        /* node's name */
        char    *x_tree;        /* root of tree containing fully defined node */
};
