/*
 * Read the tape label.
 * Compare the name therein contained with the name supplied.
 * If the same, return NULL
 * If different, return a pointer to it
 * If absent, return -1
 */
#include <stdio.h>
#include <ctype.h>

#define LABELLEN        6               /* chars in a standard label */
#define EOS             '\0'
#define BLANK           ' '

extern char etatab[];

char *
labelchk(fd, name)
int fd;
char *name;
{
	int i;
	int len;
	char cardimag[81];
	static char tname[11];
	char pname[11];

	strcpy(pname, name);
	len = strlen(name);
	while (len < LABELLEN)
                pname[len++] = BLANK;
	pname[LABELLEN] = EOS;

	if (read(fd, cardimag, 80) != 80)
		return((char *) -1);
	strncpy(tname, cardimag, 10);
	for(i = 0; i < 10; i++) {
		tname[i] = etatab[tname[i]];
		if(isupper(tname[i]))
			tname[i] = tolower(tname[i]);
	}
	tname[10] = EOS;
	if(strncmp(tname, "vol1", 4) != 0)
		return((char *) -1);
	if(strcmp(tname+4, pname) != 0)
		return(tname+4);
	return(NULL);
}
