
#include <stdio.h>
#include "sym.h"
#include "opcodes.h"
#include "assem.h"
#include "numlab.h"
#include "error.h"
#include "scanner.h"

/*
 * pass 1 of assembler
 */

int oplen[] = { 0,2,4,4,4,4,4,4,6,6,6,4,2 };
int nsects, fbflag;
int allab = 0;                          /* label entry in symbol table must be aligned */
static SYM *lab;

pass1() {

	char *opn;
	register SYM *symp, *op;
	TOKEN nxttoke;
	struct exp e;
	int r, n, opv, c;
	register TOKEN *tp;

	tp = &curtoke;
	lab = NULL;
	scan1(tp, 0);
	while (tp->t_state != END){
		onerror();
		if (tp->t_state == ID){
			if (tp->t_val == -1) op = NULL;
			else op = tp->t_sym;
			opn = tp->t_name;
			scan1(&nxttoke, 1);
			switch(nxttoke.t_state) {
				case ':':
					if (lab == NULL) n = -1;
					else n = (int) lab;
					lab = tp->t_sym;
					if (op != NULL) lab = lookup(opn, USYM);
					if (lab == NULL)
						lab = usersym(opn, UNDEFINED,0,0);
                                        else if (lab->s_symno == -1)
                                                mkusym(lab);
					if ((lab->s_type & LOCAL) > ABSOLUTE){
						lab = NULL;
						error(0, "Multiply defined: %s",
							tp->t_name);
						}
					lab->s_type &= ~LOCAL;
					lab->s_type |= dotrel;
					lab->s_val = dot;
					lab->s_len = n;
					scan1(tp, 0);
					continue;
				case '=':
				        /*
					 * S, SS, and SI instruction names are reserved
					 * keywords and cannot be used in equates
					 */
					if (op!=NULL && (op->s_type==S ||
					      op->s_type==SI1 || op->s_type==SI2 ||
					      op->s_type==SS1 || op->s_type==SS2 ||
					      op->s_type==SS3)) {
						fprintf(stderr, "%s\n%d: Warning: '%s' is considered an instruction, not an equate symbol\n", *curarg, lineno, opn);
						goto norm;
					}
					symp = tp->t_sym;
					if (op != NULL) symp = lookup(opn, USYM);
					if (symp == NULL)
						symp = usersym(opn,dotrel,0,0);
                                        else if (symp->s_symno == -1)
                                                mkusym(symp);
					scan1(tp, 1);
					if (expres(&e) != NEWLINE)
						error(0, "Bad expression");
					symp->s_type = e.e_type;
					symp->s_val = e.e_val;
					symp->s_len = e.e_len;
					if (e.e_symp != NULL)
						symp->s_val += e.e_symp->s_val;
					break;
				default:
				    norm:
					move((char *)&nxttoke, (char *)tp, sizeof(nxttoke));
					if (op != NULL) do1(op);
					else error(0, "Unknown opcode");
					break;
				}
			}
		else if (tp->t_state == DIG){
			n = tp->t_val;
			scan1(&nxttoke, 1);
			if (nxttoke.t_state == ':'){
				curfb[n].fb_addr = dot;
				curfb[n].fb_rel = dotrel;
				putc(n, fbfil);
				putc(dotrel, fbfil);
				putw(dot, fbfil);
				scan1(tp, 0);
				fbflag++;
				continue;
				}
			error(0, "Missing opcode or colon");
			}
		else if (tp->t_state == ADOT){
			scan1(tp, 1);
			if (tp->t_state != '=')
				error(0, "Syntax error");
			scan1(tp, 1);
			if (expres(&e) != NEWLINE)
				error(0, "Bad expression");
			if (e.e_type == UNDEFINED)
				error(0, "Expression undefined");
			dot = e.e_val;
			if (e.e_symp != NULL)
				dot += (e.e_symp)->s_val;
			if (dot < 0) error(0, "Dot underflow");
			}
		else if (tp->t_state == NEWLINE){
			scan1(tp, 0);
			continue;
			}
		else {

			}
		while (lab != NULL){
			n = lab->s_len;
			lab->s_len = dot-(lab->s_val);
			if (n != -1) lab = (SYM *) n;
			else lab = NULL;
			}
		lab = NULL;
		fbflag = 0;
		scan1(tp, 0);
		}
	while (lab != NULL){
		n = lab->s_len;
		lab->s_len = dot-(lab->s_val);
		if (n != -1) lab = (SYM *) n;
		else lab = NULL;
		}
	lab = NULL;
	fbflag = 0;
	chdot(TEXTSEG);
	ltorg();
	}

/*
 * pass 1 processing of an opcode
 * basically interpret pseudo-ops
 */

do1(op)
register SYM *op;{

	char cval[LINESIZE];
	int r, n, opv;
	int storage;
	int class;
	struct exp e;
	register SYM *symp;
	register TOKEN *tp;

	tp = &curtoke;
	if (tp->t_state == ID) symp = tp->t_sym;
	opv = op->s_val;
	switch(opv) {
		case TEXT:
			chdot(TEXTSEG);
			break;
		case DATA:
			chdot(DATASEG);
			break;
		case BSS:
			chdot(BSSSEG);
			break;
		case CSECT:
		case DSECT:
			if (symp->s_type == UNDEFINED){
				if (nsects++ >= MAXSECTS-2)
					error(0, "Too many sections");
				symp->s_type = EXTERN+BSSSEG+nsects;
				symp->s_val = 0;
				symp->s_len = opv;
				}
			if (symp->s_len != opv)
					error(0, "Multiply defined: %s",
						symp->s_name);
			else chdot(symp->s_type);
			if (opv == DSECT)
				size[nsects+2] = -1;
			break;
		case COMM:
			if (symp->s_symno == -1)
				mkusym(symp);
			if ((symp->s_type & LOCAL) > ABSOLUTE) {
				if((symp->s_type & EXTERN) == 0)
                                        error(0, "Multiply defined: %s", symp->s_name);
			} else {
                                symp->s_type = EXTERN;
			}
			scan1(tp, 1);
			if (tp->t_state != ',')
				error(0, "Syntax error");
			scan1(tp, 1);
			if (expres(&e) != NEWLINE)
				error(0, "Syntax error");
			if (e.e_type != ABSOLUTE)
				error(0, "Expression not absolute");
			if ((symp->s_type & LOCAL) > ABSOLUTE && symp->s_len != e.e_val)
				error(0, "Multiply defined: %s", symp->s_name);
			symp->s_len = e.e_val;
			symp->s_val = 0;
			break;
		case WXTRN:
		case EXTRN:
		case ENTRY:
			while (tp->t_state == ID){
				if (symp->s_symno == -1)
					mkusym(symp);
				symp->s_type |= EXTERN;
				if (symp->s_len == NUMLAB) symp->s_len = 0;
				scan1(tp, 1);
				if (tp->t_state != ',') break;
				scan1(tp, 1);
				symp = tp->t_sym;
				}
			break;
		case DENTRY:
			while (tp->t_state == ID) {
				if (symp->s_symno == -1)
					mkusym(symp);
				symp->s_type |= DLINK;
				if (symp->s_len == NUMLAB) symp->s_len = 0;
				scan1(tp, 1);
				if (tp->t_state != ',') break;
				scan1(tp, 1);
				symp = tp->t_sym;
				}
			break;
		case DC:
			deletesym(symp->s_name);
			allab = 1;
			for (;;) {
				dc1(&e, cval);
				if ((e.e_type & LOCAL) < DABS)
					dot = align(dot, e.e_len);
			        allab = 0;
				dot += e.e_val*e.e_len;
				if (tp->t_state != ',') break;
				scan1(tp, 1);
				}
			allab = 1;
			break;
		case LTORG:
			ltorg();
			break;
		case ENDOP:
			ltorg();
			dot = align(dot, BPD);
			chdot(TEXTSEG);
			break;
		case DS:
			deletesym(symp->s_name);
			for (;;) {
				ds1(&e);
				r = tp->t_name[0];
				if (r != 'b' && r != 'x' && r != 'c') {
                                        if (e.e_len == BPD)
                                                allab = 1;
                                        dot = align(dot, e.e_len);
                                        allab = 0;
                                }
				dot += e.e_val*e.e_len;
				scan1(tp, 1);
				if (tp->t_state != ',') break;
				scan1(tp, 1);
				}
			break;
		case CNOP:
			dot = align(dot, BPH);
			r = getabs(0, BPD-2);
			if (tp->t_state != ',')
				error(0, "Missing comma");
			scan1(tp, 1);
			n = getabs(BPW, BPD);
			if (r >= n || r%BPH != 0)
				error(0, "Bad offset in cnop");
			if (n != BPW && n != BPD)
				error(0, "Bad boundary in cnop");
			dot = align(dot, n)+r;
			break;
		case USING:
		case DROP:
			break;
		case CCW:
			allab = 1;
			dot = align(dot, BPD);
			allab = 0;
			for (r = 0; r < 4; r++){
				if (expres(&e) != ',') break;
				scan1(tp, 1);
				}
			if (r != 3) error(0, "Missing comma");
			dot += BPD;
			break;
	/*
	 * have to adjust symbol numbers in pass 1
	 */
		case CSYM:
			scan1(tp, 1);
			r = tp->t_val;  /* symbol number */
			scan1(tp, 1);   /* storage */
			storage = tp->t_val;
			scan1(tp, 1);   /* class */
			class = tp->t_val;
			scan1(tp, 1);   /* block, must be 1 for globals */
					/* the compiler's value for */
					/* external storage is 1 */
                                        /* the compiler's value for a */
                                        /* function is 5 */
                        if (tp->t_val == 1 || storage == 1) {
				tp->t_val = 1;
				symp->s_symno = r;
                                }
        /*
                        if (class == 5)
                                symp->s_symno = r;
        */
			gobble();
			break;
		case CLINENO:
		case CBLOCK:
		case CFUNC:
		case CFILE:
			gobble();
			break;
		default:
			n = op->s_type;
			dot = align(dot, BPH)+oplen[n];
			break;
		}
	gobble();
	}

/*
 * chdot - change the dot for a different section
 */

chdot(rel)
register char rel;{

	rel &= LOCAL;
	savdot[dotrel-TEXTSEG] = dot;
	dotrel = rel;
	prtype = rel;
	if (rel!=TEXTSEG && rel!=DATASEG && rel!=BSSSEG)
		/*
		 * print CSECTS in text segment
		 */
		prtype = TEXTSEG;
	dot = savdot[dotrel-TEXTSEG];
	}

/*
 * align the value on the next mod boundary,
 *      mod will generally be half-word, word, or double-word
 */

align(value, mod)
register int value, mod;{

	int new, fill;
	register SYM *symp;

	if (mod != BPD && mod != BPW && mod != BPH)
		return(value);
	new = ((value+mod-1)/mod)*mod;
	if (scan == scan2){
		fill = new-value;
		while (fill--) putob(0);
		return(new);
		}
	symp = lab;
	if(allab)
	        while (symp != NULL){
		        symp->s_val = new;
		        if (symp->s_len != -1) symp = (SYM *) symp->s_len;
		        else symp = NULL;
		}
	if (fbflag > 0 && new > value){
		putc(10, fbfil);
		putc(fbflag, fbfil);
		putw(new, fbfil);
		}
	return(new);
	}

gobble() {
	register TOKEN *tp;
	struct exp e;

	tp = &curtoke;
	while (tp->t_state != NEWLINE && tp->t_state != END){
		if (tp->t_state == '='){
			if (scan == scan1){
				scan1(tp, 1);
				lit(&e);
				continue;
				}
			else {
				getw(litfil);
				getw(litfil);
				}
			}
		(*scan)(tp, 1);
		}
	}
