/*
 * defines for assembler
 *
 * general constants first
 */
 
#define NAMESIZE 8
#define LINESIZE 256
#define BITS 32
#define BPW 4
#define BPD 8
#define BPH 2
#define MAXSECTS 34
#define POOLSIZE 3000
#define MAXUSING 16
#define MAXDISP 4096
#define NUMLAB -2
#define HDRSIZ sizeof(struct exec)
#define MAXLINE 520
 
struct exp {
	int e_type;
	int e_val;
	int e_len;
	SYM *e_symp;
	};
 
struct instruction {
	int i_opcode;
	int i_reg1;
	int i_reg2;
	int i_base1;
	int i_disp1;
	int i_base2;
	int i_disp2;
	};
 
struct using_table {
	int reg;
	int addr;
	int u_rel;
	};
 
typedef struct exp EXPR;
typedef struct instruction INST;

/*
 * globals
 */
 
char dotrel;
char orel;
char *poolp;
char pool[];
short uflag;
short sflag;
short compiled;
char *outfile;

int dot;
int savdot[];
int size[];
int oseek[];
int nsects;
int litstart;
int litrel;
int lntype, prtype, ready, comment, printc, listflg;    /* listing variables */
int litcount[];
int (*scan)();
extern int scan1();
extern int scan2();
extern char atetab[128];
int errflg;
int dcval;      /* set so that a label has the address of the first byte following it */
int symsiz;
int relsiz;
int entrie;
int oplen[];
FILE *infil, *outfil;
FILE *txtfil, *fbfil, *litfil, *relspace;
FILE *instfil, *listfil;
FILE *datafil, *textfil, *dataobj, *textobj, *bssfil, *bssobj, *litobj;
struct using_table using[];

/*
 * literal types
 */
 
#define LITD 0          /* double word          */
#define LITFA 1         /* full word, address   */
#define LITF 2          /* full word            */
#define LITHA 3         /* half word, address   */
#define LITH 4          /* half word            */
#define LITOA 5         /* others, address      */
#define LITO 6          /* others               */
#define LITTYPES 7      /* total                */
