/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.midiui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import uk.org.toot.midi.core.ConnectedMidiSystem;
import uk.org.toot.midi.core.MidiConnection;
import uk.org.toot.midi.core.MidiDevice;
import uk.org.toot.midi.core.MidiPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiConnectionMap
extends JPanel
implements Observer {
    private JList outPorts;
    private JList inPorts;
    private ConnectedMidiSystem system;

    public MidiConnectionMap(ConnectedMidiSystem system) {
        super(new BorderLayout());
        this.system = system;
        this.update(null, null);
        system.addObserver(this);
    }

    @Override
    public void update(Observable obs, Object arg) {
        this.removeAll();
        this.outPorts = this.createJList(true);
        this.outPorts.setCellRenderer(new RightAlignedListCellRenderer());
        this.add((Component)this.outPorts, "West");
        this.inPorts = this.createJList(false);
        this.add((Component)this.inPorts, "East");
        this.add((Component)this.createWiring(), "Center");
        this.add((Component)this.createControls(), "South");
        this.validate();
        this.repaint();
    }

    protected <T extends MidiPort> JList createJList(boolean isOut) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (MidiDevice device : this.system.getMidiDevices()) {
            List<MidiPort> ports = isOut ? device.getMidiOutputs() : device.getMidiInputs();
            for (MidiPort port : ports) {
                String name = port.getName();
                nameList.add(name);
            }
        }
        JList<Object> list = new JList<Object>(nameList.toArray());
        list.setFixedCellHeight(16);
        return list;
    }

    protected JComponent createWiring() {
        return new Wiring();
    }

    protected JComponent createControls() {
        JPanel panel = new JPanel();
        panel.add(new MapButton("Connect"));
        panel.add(new MapButton("Disconnect"));
        return panel;
    }

    protected void connect() {
        String txName = (String)this.outPorts.getSelectedValue();
        String rxName = (String)this.inPorts.getSelectedValue();
        if (txName == null || rxName == null) {
            return;
        }
        try {
            this.system.createMidiConnection(txName, rxName, 0);
        }
        catch (Exception e) {
            System.err.println("Failed to create Connection from " + txName + " to " + rxName);
        }
    }

    protected void disconnect() {
        String txName = (String)this.outPorts.getSelectedValue();
        String rxName = (String)this.inPorts.getSelectedValue();
        if (txName == null || rxName == null) {
            return;
        }
        try {
            this.system.closeMidiConnection(txName, rxName);
        }
        catch (Exception e) {
            System.err.println("Failed to close Connection from " + txName + " to " + rxName);
        }
    }

    protected class Wiring
    extends JComponent {
        private Dimension prefSize = new Dimension(128, 64);

        protected Wiring() {
        }

        public void paint(Graphics g) {
            for (MidiConnection connection : MidiConnectionMap.this.system.getMidiConnections()) {
                String txName = connection.getMidiOutput().getName();
                String rxName = connection.getMidiInput().getName();
                int txpos = -1;
                int rxpos = -1;
                int i = 0;
                while (i < MidiConnectionMap.this.outPorts.getModel().getSize()) {
                    if (txName.equals((String)MidiConnectionMap.this.outPorts.getModel().getElementAt(i))) {
                        txpos = i;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < MidiConnectionMap.this.inPorts.getModel().getSize()) {
                    if (rxName.equals((String)MidiConnectionMap.this.inPorts.getModel().getElementAt(i))) {
                        rxpos = i;
                        break;
                    }
                    ++i;
                }
                if (txpos < 0 || rxpos < 0) {
                    System.err.println("Can't paint Wiring for Connection from " + txName + "(" + txpos + ") to " + rxName + "(" + rxpos + ")");
                    continue;
                }
                Point txpoint = MidiConnectionMap.this.outPorts.indexToLocation(txpos);
                Point rxpoint = MidiConnectionMap.this.inPorts.indexToLocation(rxpos);
                txpoint.x = 0;
                txpoint.y += MidiConnectionMap.this.outPorts.getFixedCellHeight() / 2;
                rxpoint.x = this.getWidth() - 1;
                rxpoint.y += MidiConnectionMap.this.inPorts.getFixedCellHeight() / 2;
                Color color = !connection.isPlayback() ? (connection.isSystem() ? Color.orange.darker() : Color.red) : (connection.isSystem() ? Color.blue : Color.black);
                g.setColor(color);
                g.drawLine(txpoint.x, txpoint.y, rxpoint.x, rxpoint.y);
            }
        }

        public Dimension getPreferredSize() {
            return this.prefSize;
        }
    }

    protected class MapButton
    extends JButton
    implements ActionListener {
        public MapButton(String text) {
            super(text);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if ("Connect".equals(cmd)) {
                MidiConnectionMap.this.connect();
            } else if ("Disconnect".equals(cmd)) {
                MidiConnectionMap.this.disconnect();
            }
        }
    }

    private class RightAlignedListCellRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        private RightAlignedListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setHorizontalAlignment(4);
            return this;
        }
    }
}

