/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.controlui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import uk.org.toot.control.LawControl;

public class ControlKnob
extends JComponent
implements Observer {
    private static final int radius = 16;
    private static final int spotRadius = 4;
    private int value;
    private double theta;
    private double thetaPrev = 0.0;
    private double thetaMax = 2.6179938779914944;
    private Color knobColor = Color.gray;
    private Color spotColor = Color.white;
    private MouseController mouseController;
    private LawControl control;

    public ControlKnob(LawControl c) {
        this.control = c;
        this.setValue(c.getLaw().intValue(c.getValue()));
        this.mouseController = this.createMouseController();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    public void setValue(int value) {
        this.theta = (double)(value * 2) * this.thetaMax / (double)(this.control.getLaw().getResolution() - 1) - this.thetaMax;
    }

    public void addNotify() {
        super.addNotify();
        this.control.addObserver(this);
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
    }

    public void removeNotify() {
        this.removeMouseListener(this.mouseController);
        this.removeMouseMotionListener(this.mouseController);
        this.control.deleteObserver(this);
        super.removeNotify();
    }

    public void update(Observable obs, Object obj) {
        this.setValue(this.control.getLaw().intValue(this.control.getValue()));
        this.repaint();
    }

    protected MouseController createMouseController() {
        return new KnobMouseController();
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.knobColor);
        g.fillOval(0, 0, 32, 32);
        g.setColor(this.control.getInsertColor());
        g.fillOval(8, 8, 16, 16);
        Point pt = this.getSpotCenter();
        int xc = (int)pt.getX();
        int yc = (int)pt.getY();
        g.setColor(this.spotColor);
        g.fillOval(xc - 4, yc - 4, 8, 8);
    }

    public Dimension getPreferredSize() {
        return new Dimension(34, 34);
    }

    public Dimension getMinimumSize() {
        return new Dimension(34, 34);
    }

    public Dimension getMaximumSize() {
        return new Dimension(35, 35);
    }

    public double getTheta() {
        return this.theta;
    }

    protected void setTheta(double val) {
        this.theta = val;
        this.value = (int)((this.theta + this.thetaMax) * (double)(this.control.getLaw().getResolution() - 1) / (2.0 * this.thetaMax));
        this.control.setValue(this.control.getLaw().userValue(this.value));
    }

    private Point getSpotCenter() {
        int n = 12;
        int xcp = (int)(12.0 * Math.sin(this.theta));
        int ycp = (int)(12.0 * Math.cos(this.theta));
        int xc = 16 + xcp;
        int yc = 16 - ycp;
        return new Point(xc, yc);
    }

    public static interface MouseController
    extends MouseListener,
    MouseMotionListener {
    }

    public abstract class AbstractMouseController
    implements MouseController {
        protected boolean pressedOn = false;

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (this.pressedOn) {
                ControlKnob.this.control.setAdjusting(true);
            }
        }

        public void mouseReleased(MouseEvent e) {
            ControlKnob.this.control.setAdjusting(false);
            this.pressedOn = false;
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        protected double calculateTheta(int x, int y) {
            return Math.atan2(x - 16, 16 - y);
        }
    }

    private class SpotMouseController
    extends AbstractMouseController {
        private SpotMouseController() {
        }

        public void mousePressed(MouseEvent e) {
            this.pressedOn = this.isOnSpot(e.getPoint());
            super.mousePressed(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.pressedOn) {
                ControlKnob.this.setTheta(this.calculateTheta(e.getX(), e.getY()));
                ControlKnob.this.repaint();
            }
        }

        private boolean isOnSpot(Point pt) {
            return pt.distance(ControlKnob.this.getSpotCenter()) < 4.0;
        }
    }

    private class KnobMouseController
    extends AbstractMouseController {
        private double thetaDelta;

        private KnobMouseController() {
        }

        public void mousePressed(MouseEvent e) {
            this.pressedOn = true;
            this.thetaDelta = ControlKnob.this.theta - this.calculateTheta(e.getX(), e.getY());
            super.mousePressed(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.pressedOn) {
                double thetaNom = this.calculateTheta(e.getX(), e.getY()) + this.thetaDelta;
                if (thetaNom < -ControlKnob.this.thetaMax) {
                    thetaNom = -ControlKnob.this.thetaMax;
                } else if (thetaNom > ControlKnob.this.thetaMax) {
                    thetaNom = ControlKnob.this.thetaMax;
                }
                if (thetaNom > 0.0 && ControlKnob.this.thetaPrev < -1.5707963267948966) {
                    return;
                }
                if (thetaNom < 0.0 && ControlKnob.this.thetaPrev > 1.5707963267948966) {
                    return;
                }
                ControlKnob.this.thetaPrev = ControlKnob.this.theta;
                ControlKnob.this.setTheta(thetaNom);
                ControlKnob.this.repaint();
            }
        }
    }
}

