/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.controlui;

import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import java.util.Observable;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.CompoundControlChain;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSelector;
import uk.org.toot.swingui.controlui.ControlPanel;
import uk.org.toot.swingui.controlui.PanelFactory;

public class CompoundControlPanel
extends ControlPanel {
    protected ControlSelector controlSelector = null;
    protected PanelFactory panelFactory;
    protected CompoundControl control;
    protected Container target;
    protected JTabbedPane tabbedPane = null;
    protected int axis;
    protected boolean mutating = false;
    protected boolean pending = false;
    private Runnable recreator = new Runnable(){

        public void run() {
            CompoundControlPanel.this.recreate();
            CompoundControlPanel.this.revalidate();
            CompoundControlPanel.this.repaint();
        }
    };

    public CompoundControlPanel(CompoundControl control, int axis, ControlSelector controlSelector, PanelFactory panelFactory, boolean hasBorder, boolean hasHeader) {
        super(control);
        this.setLayout(new BoxLayout(this, axis));
        this.control = control;
        this.controlSelector = controlSelector;
        this.panelFactory = panelFactory;
        this.axis = axis;
        this.target = panelFactory.layout(control, axis, hasBorder, this, hasHeader);
        this.create();
    }

    public void update(Observable obs, Object obj) {
        if (obj instanceof CompoundControlChain.ChainMutation) {
            CompoundControlChain.ChainMutation mutation = (CompoundControlChain.ChainMutation)obj;
            switch (mutation.getType()) {
                case 1: 
                case 2: 
                case 3: {
                    this.pending = true;
                    break;
                }
                case 4: {
                    this.mutating = true;
                    this.pending = false;
                    break;
                }
                case 5: {
                    this.mutating = false;
                }
            }
            if (this.pending && !this.mutating) {
                SwingUtilities.invokeLater(this.recreator);
                this.pending = false;
            }
        }
    }

    protected boolean select(Control control) {
        if (control == null) {
            return false;
        }
        if (this.controlSelector == null) {
            return true;
        }
        return this.controlSelector.select(control);
    }

    protected void recreate() {
        if (this.target == null) {
            return;
        }
        this.target.removeAll();
        this.create();
    }

    protected void recreate(CompoundControl control) {
        this.control.deleteObserver(this);
        this.control = control;
        control.addObserver(this);
        this.recreate();
    }

    protected void create() {
        List<Control> controls = this.control.getControls();
        if (controls == null) {
            return;
        }
        if (this.axis == 1 && this.reverseIfYAxis()) {
            int i = controls.size() - 1;
            while (i >= 0) {
                this.addControlPanelConditionally(controls.get(i));
                --i;
            }
        } else {
            for (Control cont : controls) {
                this.addControlPanelConditionally(cont);
            }
        }
    }

    protected boolean reverseIfYAxis() {
        return false;
    }

    protected void addControlPanelConditionally(Control c) {
        CompoundControl cc;
        String alt;
        if (!this.select(c)) {
            return;
        }
        if (c.isHidden()) {
            return;
        }
        if (this.target == null) {
            return;
        }
        if (c instanceof CompoundControl && (alt = (cc = (CompoundControl)c).getAlternate()) != null) {
            JComponent comp;
            if (this.tabbedPane == null) {
                this.tabbedPane = new JTabbedPane(){

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.target.add(this.tabbedPane);
            }
            if ((comp = this.panelFactory.createComponent(c, this.axis, false)) == null) {
                return;
            }
            this.tabbedPane.addTab(cc.getName(), comp);
            return;
        }
        JComponent comp = this.panelFactory.createComponent(c, this.axis, true);
        if (comp == null) {
            return;
        }
        this.target.add(comp);
    }

    public CompoundControl getControl() {
        return this.control;
    }
}

