/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.audioui.mixerui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import uk.org.toot.audio.mixer.MixerControlsSnapshotAutomation;
import uk.org.toot.localisation.Localisation;

public class SnapshotAutomationPopupMenu
extends JPopupMenu
implements ActionListener {
    private MixerControlsSnapshotAutomation automation;

    public SnapshotAutomationPopupMenu(MixerControlsSnapshotAutomation automation) {
        this.automation = automation;
    }

    public void show(Component invoker, int x, int y) {
        this.removeAll();
        String[] names = this.automation.list();
        if (names != null) {
            JMenu recallMenu = new JMenu(Localisation.getString("Recall"));
            this.add(recallMenu);
            int i = 0;
            while (i < names.length) {
                String name = names[i].substring(0, names[i].lastIndexOf("."));
                JMenuItem item = new JMenuItem(name);
                recallMenu.add(item);
                item.addActionListener(this);
                ++i;
            }
        }
        JMenuItem storeItem = new JMenuItem(new StoreAction());
        this.add(storeItem);
        super.show(invoker, x, y);
    }

    public void actionPerformed(ActionEvent event) {
        this.automation.recall(event.getActionCommand());
    }

    protected class StoreAction
    extends AbstractAction {
        public StoreAction() {
            super(Localisation.getString("Store.As..."));
        }

        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog(Localisation.getString("Store.As..."));
            if (name != null) {
                SnapshotAutomationPopupMenu.this.automation.store(name);
            }
        }
    }
}

