/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class DisposablePanel
extends JPanel {
    protected boolean doDispose = false;
    private WindowListener wl = new WindowAdapter(){

        public void windowClosing(WindowEvent evt) {
            DisposablePanel.this.dispose();
            DisposablePanel.this.doDispose = true;
        }
    };

    public void addNotify() {
        super.addNotify();
        SwingUtilities.windowForComponent(this).addWindowListener(this.wl);
    }

    public void removeNotify() {
        SwingUtilities.windowForComponent(this).removeWindowListener(this.wl);
        if (this.doDispose) {
            this.wl = null;
        }
        super.removeNotify();
    }

    protected abstract void dispose();
}

