/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import uk.org.toot.project.ProjectListener;

public class SingleProject {
    private Properties currentProjectProperties = null;
    private String currentProjectTitle = "unknown";
    private String currentProjectArtist = "unknown";
    private File applicationPath;
    private File projectsPath;
    private File currentProjectPath;
    private List<ProjectListener> listeners;

    public SingleProject() {
        this("toot");
    }

    public SingleProject(String appDir) {
        this(new File(System.getProperty("user.home"), appDir));
    }

    public SingleProject(File appPath) {
        this.applicationPath = appPath;
        this.applicationPath.mkdirs();
        this.setProjectsRoot(this.applicationPath.getPath());
        this.listeners = new ArrayList<ProjectListener>();
    }

    public void openProject(String name) {
        if (name == null) {
            return;
        }
        this.currentProjectPath = new File(this.projectsPath, name);
        if (!this.currentProjectPath.exists()) {
            this.currentProjectPath.mkdirs();
        }
        this.currentProjectProperties = new Properties();
        File propertyFile = new File(this.currentProjectPath, "project.properties");
        if (propertyFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(propertyFile);
                this.currentProjectProperties.load(fis);
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException fis) {}
        } else {
            System.out.println(String.valueOf(propertyFile.getPath()) + " not found");
        }
        this.currentProjectTitle = this.currentProjectProperties.getProperty("title", name);
        this.currentProjectArtist = this.currentProjectProperties.getProperty("artist", "unknown");
        for (ProjectListener l : this.listeners) {
            l.open();
        }
    }

    public void saveProject() {
        if (!this.canSaveProject()) {
            return;
        }
        if (!this.projectsPath.exists()) {
            this.projectsPath.mkdirs();
            System.out.println("Created projects path " + this.projectsPath.getPath());
        }
        for (ProjectListener l : this.listeners) {
            l.save();
        }
    }

    public void saveAsProject(String name) {
        this.currentProjectPath = new File(this.projectsPath, name);
        this.saveProject();
    }

    public void importProject(String name, File file) {
        if (name == null) {
            return;
        }
        File projectPath = new File(this.projectsPath, name);
        if (projectPath.exists()) {
            return;
        }
    }

    public void exportProject(String name) {
        if (name == null) {
            return;
        }
        File projectPath = new File(this.projectsPath, name);
        if (!projectPath.exists()) {
            return;
        }
    }

    public boolean canOpenProject() {
        return true;
    }

    public boolean canSaveProject() {
        return this.currentProjectProperties != null;
    }

    public File getApplicationPath() {
        return this.applicationPath;
    }

    public String getCurrentProjectTitle() {
        return this.currentProjectTitle;
    }

    public String getCurrentProjectArtist() {
        return this.currentProjectArtist;
    }

    public File getCurrentProjectPath() {
        return this.currentProjectPath;
    }

    public void setProjectsRoot(String path) {
        this.projectsPath = new File(path, "projects");
    }

    public File getProjectsRoot() {
        return this.projectsPath;
    }

    public void addProjectListener(ProjectListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeProjectListener(ProjectListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

