/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.tonality;

import java.util.ArrayList;
import java.util.List;
import uk.org.toot.music.tonality.Scale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scales {
    private static List<Scale> scales = new ArrayList<Scale>();

    private static void checkScales() {
        if (scales.isEmpty()) {
            Conventional.init();
        }
    }

    public static List<Scale> getScales() {
        Scales.checkScales();
        return scales;
    }

    public static void add(Scale scale) {
        scales.add(scale);
    }

    public static List<String> getScaleNames() {
        Scales.checkScales();
        ArrayList<String> scaleNames = new ArrayList<String>();
        for (Scale scale : scales) {
            scaleNames.add(scale.getName());
        }
        return scaleNames;
    }

    public static Scale getInitialScale() {
        Scales.checkScales();
        return scales.get(0);
    }

    public static Scale getScale(String scaleName) {
        Scales.checkScales();
        for (Scale scale : scales) {
            if (scale.getName().indexOf(scaleName) < 0) continue;
            return scale;
        }
        return Scales.getInitialScale();
    }

    public static class Conventional {
        public static void init() {
            int[] nArray = new int[7];
            nArray[1] = 2;
            nArray[2] = 4;
            nArray[3] = 5;
            nArray[4] = 7;
            nArray[5] = 9;
            nArray[6] = 11;
            int[] major = nArray;
            Scales.add(new Scale("Major", major));
            int[] nArray2 = new int[7];
            nArray2[1] = 2;
            nArray2[2] = 3;
            nArray2[3] = 5;
            nArray2[4] = 7;
            nArray2[5] = 8;
            nArray2[6] = 10;
            int[] minorNatural = nArray2;
            Scales.add(new Scale("Natural Minor", minorNatural));
            int[] nArray3 = new int[7];
            nArray3[1] = 2;
            nArray3[2] = 3;
            nArray3[3] = 5;
            nArray3[4] = 7;
            nArray3[5] = 8;
            nArray3[6] = 11;
            int[] minorHarmonic = nArray3;
            Scales.add(new Scale("Harmonic Minor", minorHarmonic));
            int[] nArray4 = new int[8];
            nArray4[1] = 2;
            nArray4[2] = 3;
            nArray4[3] = 5;
            nArray4[4] = 6;
            nArray4[5] = 8;
            nArray4[6] = 9;
            nArray4[7] = 11;
            int[] diminished = nArray4;
            Scales.add(new Scale("Diminished", diminished));
            int[] nArray5 = new int[6];
            nArray5[1] = 3;
            nArray5[2] = 4;
            nArray5[3] = 7;
            nArray5[4] = 8;
            nArray5[5] = 11;
            int[] augmented = nArray5;
            Scales.add(new Scale("Augmented", augmented));
            int[] nArray6 = new int[6];
            nArray6[1] = 2;
            nArray6[2] = 4;
            nArray6[3] = 6;
            nArray6[4] = 8;
            nArray6[5] = 10;
            int[] wholeTone = nArray6;
            Scales.add(new Scale("Whole Tone", wholeTone));
            int[] nArray7 = new int[7];
            nArray7[1] = 2;
            nArray7[2] = 4;
            nArray7[3] = 6;
            nArray7[4] = 7;
            nArray7[5] = 9;
            nArray7[6] = 10;
            int[] lydianDominant = nArray7;
            Scales.add(new Scale("Lydian Dominant", lydianDominant));
            int[] nArray8 = new int[5];
            nArray8[1] = 2;
            nArray8[2] = 4;
            nArray8[3] = 7;
            nArray8[4] = 9;
            int[] pentatonicMajor = nArray8;
            Scales.add(new Scale("Pentatonic Major", pentatonicMajor));
            int[] nArray9 = new int[4];
            nArray9[1] = 3;
            nArray9[2] = 6;
            nArray9[3] = 11;
            int[] pentatonicMinor = nArray9;
            Scales.add(new Scale("Pentatonic Minor", pentatonicMinor));
            int[] nArray10 = new int[4];
            nArray10[1] = 3;
            nArray10[2] = 6;
            nArray10[3] = 9;
            int[] threeSemitone = nArray10;
            int[] nArray11 = new int[3];
            nArray11[1] = 4;
            nArray11[2] = 8;
            int[] fourSemitone = nArray11;
            int[] nArray12 = new int[6];
            nArray12[1] = 3;
            nArray12[2] = 5;
            nArray12[3] = 6;
            nArray12[4] = 7;
            nArray12[5] = 11;
            int[] blues = nArray12;
            Scales.add(new Scale("Blues", blues));
            int[] nArray13 = new int[8];
            nArray13[1] = 2;
            nArray13[2] = 4;
            nArray13[3] = 5;
            nArray13[4] = 7;
            nArray13[5] = 9;
            nArray13[6] = 10;
            nArray13[7] = 11;
            int[] bebop = nArray13;
            Scales.add(new Scale("Bebop", bebop));
            int[] nArray14 = new int[7];
            nArray14[1] = 1;
            nArray14[2] = 4;
            nArray14[3] = 6;
            nArray14[4] = 8;
            nArray14[5] = 10;
            nArray14[6] = 11;
            int[] enigmatic = nArray14;
            Scales.add(new Scale("Enigmatic", enigmatic));
        }
    }

    public static class LydianChromaticConcept {
        public static void init() {
            int[] nArray = new int[7];
            nArray[1] = 2;
            nArray[2] = 4;
            nArray[3] = 6;
            nArray[4] = 7;
            nArray[5] = 9;
            nArray[6] = 11;
            int[] lydian = nArray;
            Scales.add(new Scale("Lydian", lydian));
            int[] nArray2 = new int[7];
            nArray2[1] = 2;
            nArray2[2] = 4;
            nArray2[3] = 6;
            nArray2[4] = 8;
            nArray2[5] = 9;
            nArray2[6] = 11;
            int[] lydianAugmented = nArray2;
            Scales.add(new Scale("Lydian Augmented", lydianAugmented));
            int[] nArray3 = new int[7];
            nArray3[1] = 2;
            nArray3[2] = 3;
            nArray3[3] = 6;
            nArray3[4] = 7;
            nArray3[5] = 9;
            nArray3[6] = 11;
            int[] lydianDiminished = nArray3;
            Scales.add(new Scale("Lydian Diminished", lydianDiminished));
            int[] nArray4 = new int[7];
            nArray4[1] = 2;
            nArray4[2] = 4;
            nArray4[3] = 6;
            nArray4[4] = 7;
            nArray4[5] = 9;
            nArray4[6] = 10;
            int[] lydianFlatSeventh = nArray4;
            Scales.add(new Scale("Lydian Flat Seventh", lydianFlatSeventh));
            int[] nArray5 = new int[6];
            nArray5[1] = 2;
            nArray5[2] = 4;
            nArray5[3] = 6;
            nArray5[4] = 8;
            nArray5[5] = 10;
            int[] auxAugmented = nArray5;
            Scales.add(new Scale("Auxiliary Augmented", auxAugmented));
            int[] nArray6 = new int[8];
            nArray6[1] = 2;
            nArray6[2] = 3;
            nArray6[3] = 5;
            nArray6[4] = 6;
            nArray6[5] = 8;
            nArray6[6] = 9;
            nArray6[7] = 11;
            int[] auxDiminished = nArray6;
            Scales.add(new Scale("Auxiliary Diminished", auxDiminished));
            int[] nArray7 = new int[8];
            nArray7[1] = 1;
            nArray7[2] = 3;
            nArray7[3] = 4;
            nArray7[4] = 6;
            nArray7[5] = 7;
            nArray7[6] = 9;
            nArray7[7] = 10;
            int[] auxDiminishedBlues = nArray7;
            Scales.add(new Scale("Auxiliary Diminished Blues", auxDiminishedBlues));
            int[] nArray8 = new int[7];
            nArray8[1] = 2;
            nArray8[2] = 4;
            nArray8[3] = 5;
            nArray8[4] = 7;
            nArray8[5] = 9;
            nArray8[6] = 11;
            int[] major = nArray8;
            Scales.add(new Scale("Major", major));
            int[] nArray9 = new int[7];
            nArray9[1] = 2;
            nArray9[2] = 4;
            nArray9[3] = 5;
            nArray9[4] = 7;
            nArray9[5] = 9;
            nArray9[6] = 10;
            int[] majorFlatSeventh = nArray9;
            Scales.add(new Scale("Major Flat Seventh", majorFlatSeventh));
            int[] nArray10 = new int[7];
            nArray10[1] = 2;
            nArray10[2] = 4;
            nArray10[3] = 5;
            nArray10[4] = 8;
            nArray10[5] = 9;
            nArray10[6] = 11;
            int[] majorAugmentedFifth = nArray10;
            Scales.add(new Scale("Major Augmented", majorAugmentedFifth));
            int[] nArray11 = new int[10];
            nArray11[1] = 2;
            nArray11[2] = 3;
            nArray11[3] = 4;
            nArray11[4] = 5;
            nArray11[5] = 6;
            nArray11[6] = 7;
            nArray11[7] = 9;
            nArray11[8] = 10;
            nArray11[9] = 11;
            int[] africanAmericanBlues = nArray11;
            Scales.add(new Scale("African-American Blues", africanAmericanBlues));
        }
    }
}

