/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.tonality;

public class Interval {
    public static final int UNISON = 0;
    public static final int MINOR_SECOND = 1;
    public static final int MAJOR_SECOND = 2;
    public static final int MINOR_THIRD = 3;
    public static final int MAJOR_THIRD = 4;
    public static final int PERFECT_FOURTH = 5;
    public static final int AUGMENTED_FOURTH = 6;
    public static final int DIMINISHED_FIFTH = 6;
    public static final int PERFECT_FIFTH = 7;
    public static final int AUGMENTED_FIFTH = 8;
    public static final int MINOR_SIXTH = 8;
    public static final int MAJOR_SIXTH = 9;
    public static final int DIMINISHED_SEVENTH = 9;
    public static final int MINOR_SEVENTH = 10;
    public static final int MAJOR_SEVENTH = 11;
    public static final int OCTAVE = 12;

    private Interval() {
    }

    public static int classValue(int interval) {
        return interval % 12;
    }

    public static String name(int interval) {
        if (interval == 12) {
            return "Octave";
        }
        switch (Interval.classValue(interval)) {
            case 0: {
                return "Unison";
            }
            case 1: {
                return "Minor second";
            }
            case 2: {
                return "Major second";
            }
            case 3: {
                return "Minor third";
            }
            case 4: {
                return "Major third";
            }
            case 5: {
                return "Perfect fourth";
            }
            case 6: {
                return "Diminished fifth";
            }
            case 7: {
                return "Perfect fifth";
            }
            case 8: {
                return "Augmented fifth";
            }
            case 9: {
                return "Major sixth";
            }
            case 10: {
                return "Minor seventh";
            }
            case 11: {
                return "Major seventh";
            }
        }
        return "{" + String.valueOf(interval) + "}";
    }

    public static String numeral(int interval) {
        switch (Interval.classValue(interval)) {
            case 0: {
                return "I";
            }
            case 1: {
                return "ii";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "iii";
            }
            case 4: {
                return "III";
            }
            case 5: {
                return "IV";
            }
            case 6: {
                return "vo";
            }
            case 7: {
                return "V";
            }
            case 8: {
                return "V+";
            }
            case 9: {
                return "VI";
            }
            case 10: {
                return "vii";
            }
            case 11: {
                return "VII";
            }
        }
        return "{" + String.valueOf(interval) + "}";
    }

    public static String spell(int interval) {
        switch (interval) {
            case 0: {
                return "1";
            }
            case 1: {
                return "b2";
            }
            case 2: {
                return "2";
            }
            case 3: {
                return "b3";
            }
            case 4: {
                return "3";
            }
            case 5: {
                return "4";
            }
            case 6: {
                return "b5";
            }
            case 7: {
                return "5";
            }
            case 8: {
                return "#5";
            }
            case 9: {
                return "6";
            }
            case 10: {
                return "b7";
            }
            case 11: {
                return "7";
            }
            case 12: {
                return "8";
            }
            case 13: {
                return "b9";
            }
            case 14: {
                return "9";
            }
            case 15: {
                return "#9";
            }
            case 16: {
                return "b11";
            }
            case 17: {
                return "11";
            }
            case 18: {
                return "#11";
            }
            case 19: {
                return "12";
            }
            case 20: {
                return "b13";
            }
            case 21: {
                return "13";
            }
            case 22: {
                return "#13";
            }
            case 23: {
                return "14";
            }
        }
        return "?" + String.valueOf(interval);
    }

    public static String spell(int[] intervals) {
        StringBuffer spelling = new StringBuffer();
        int i = 0;
        while (i < intervals.length) {
            spelling.append(Interval.spell(intervals[i]));
            spelling.append(" ");
            ++i;
        }
        return spelling.toString();
    }

    public static int spelt(String s) {
        if (s.equals("1")) {
            return 0;
        }
        if (s.equals("b2")) {
            return 1;
        }
        if (s.equals("2")) {
            return 2;
        }
        if (s.equals("b3")) {
            return 3;
        }
        if (s.equals("3")) {
            return 4;
        }
        if (s.equals("4")) {
            return 5;
        }
        if (s.equals("#4")) {
            return 6;
        }
        if (s.equals("b5")) {
            return 6;
        }
        if (s.equals("5")) {
            return 7;
        }
        if (s.equals("#5")) {
            return 8;
        }
        if (s.equals("b6")) {
            return 8;
        }
        if (s.equals("6")) {
            return 9;
        }
        if (s.equals("bb7")) {
            return 9;
        }
        if (s.equals("b7")) {
            return 10;
        }
        if (s.equals("7")) {
            return 11;
        }
        if (s.equals("b9")) {
            return 13;
        }
        if (s.equals("9")) {
            return 14;
        }
        if (s.equals("#9")) {
            return 15;
        }
        if (s.equals("b11")) {
            return 16;
        }
        if (s.equals("11")) {
            return 17;
        }
        if (s.equals("#11")) {
            return 18;
        }
        if (s.equals("b13")) {
            return 20;
        }
        if (s.equals("13")) {
            return 21;
        }
        return -1;
    }
}

