/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.tonality;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.org.toot.music.tonality.Chord;
import uk.org.toot.music.tonality.Pitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chords {
    private static List<Chord> chords = new ArrayList<Chord>();
    private static Identifier chordIdentifier;

    static {
        Chords.addChords();
        chordIdentifier = new DefaultIdentifier();
    }

    private Chords() {
    }

    public static void setChordIdentifer(Identifier identifier) {
        chordIdentifier = identifier;
    }

    public static void add(Chord aChord) {
        chords.add(aChord);
    }

    public static void addChord(String aSymbol, String aSpelling, String aName) {
        Chords.add(new Chord(aSymbol, aSpelling, aName));
    }

    public static Chord withSymbol(String aSymbol) {
        for (Chord chord : chords) {
            if (!chord.getSymbol().equals(aSymbol)) continue;
            return chord;
        }
        return null;
    }

    public static Chord withSpelling(String aSpelling) {
        for (Chord chord : chords) {
            if (!chord.getSpelling().equals(aSpelling)) continue;
            return chord;
        }
        return null;
    }

    public static Chord withName(String aName) {
        for (Chord chord : chords) {
            if (!chord.getName().equals(aName)) continue;
            return chord;
        }
        return null;
    }

    public static Chord withIntervals(int[] someIntervals) {
        for (Chord chord : chords) {
            if (!chord.matchesIntervals(someIntervals)) continue;
            return chord;
        }
        return null;
    }

    public static List<Chord.Voicing> withIntervals(int[] someIntervals, int missing) {
        ArrayList<Chord.Voicing> voicings = new ArrayList<Chord.Voicing>();
        for (Chord chord : chords) {
            int[] missingIndices = chord.missingIntervals(someIntervals, missing);
            if (missingIndices == null) continue;
            voicings.add(new Chord.Voicing(chord, missingIndices));
        }
        return voicings;
    }

    public static List<Chord.PitchedVoicing> withNotes(int[] notes) {
        return chordIdentifier.withNotes(notes);
    }

    public static List<Chord> fromChordMode(int[] chordMode) {
        ArrayList<Chord> chordList = new ArrayList<Chord>();
        for (Chord chord : chords) {
            if (!chord.matchesChordMode(chordMode)) continue;
            chordList.add(chord);
        }
        return chordList;
    }

    public static void checkIdentifiability() {
        for (Chord chord : chords) {
            Chord.PitchedVoicing pitchedVoicing = new Chord.PitchedVoicing(new Chord.Voicing(chord), Pitch.classValue("C"));
            int[] notes = pitchedVoicing.getPitches();
            List<Chord.PitchedVoicing> matches = Chords.withNotes(notes);
            boolean found = false;
            for (Chord.PitchedVoicing cpv : matches) {
                if (cpv.getChord() != chord) continue;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("C" + chord.getSymbol() + " not identified");
            for (Chord.PitchedVoicing car : matches) {
                System.out.println("matched " + car);
            }
        }
    }

    private static void addChords() {
        Chords.addChord("maj", "1 3 5", "major");
        Chords.addChord("maj7", "1 3 5 7", "major seventh");
        Chords.addChord("maj7-5", "1 3 b5 7", "major seventh flat 5");
        Chords.addChord("maj7+5", "1 3 #5 7", "major seventh sharp 5");
        Chords.addChord("maj7sus4", "1 4 5 7", "major seventh suspended fourth");
        Chords.addChord("add+11", "1 3 5 #11", "added augmented eleventh");
        Chords.addChord("6", "1 3 5 6", "six");
        Chords.addChord("maj9", "1 3 5 7 9", "major ninth");
        Chords.addChord("maj9+5", "1 3 #5 7 9", "major ninth augmented fifth");
        Chords.addChord("maj9-5", "1 3 b5 7 9", "major ninth diminished fifth");
        Chords.addChord("maj7+11", "1 3 5 7 #11", "major seventh augmented eleventh");
        Chords.addChord("6/7", "1 3 5 6 7", "six seven");
        Chords.addChord("6/9", "1 3 5 6 9", "major sixth added ninth");
        Chords.addChord("6/7sus4", "1 4 5 6 7", "six seven suspended fourth");
        Chords.addChord("maj11", "1 3 5 7 9 11", "major eleventh");
        Chords.addChord("maj11+5", "1 3 #5 7 9 11", "major eleventh augmented fifth");
        Chords.addChord("maj11-5", "1 3 b5 7 9 11", "major eleventh augmented fifth");
        Chords.addChord("maj9+11", "1 3 5 7 9 #11", "major ninth augmented eleventh");
        Chords.addChord("maj13", "1 3 5 7 9 11 13", "major thirteenth");
        Chords.addChord("maj13+11", "1 3 5 7 9 #11 13", "major thirteenth augmented eleventh");
        Chords.addChord("dim", "1 b3 b5", "diminished");
        Chords.addChord("dim7", "1 b3 b5 bb7", "diminished seventh");
        Chords.addChord("min/maj7", "1 b3 5 7", "minor/major seventh");
        Chords.addChord("min/maj9", "1 b3 5 7 9", "minor/major ninth");
        Chords.addChord("min/maj11", "1 b3 5 7 9 11", "minor/major eleventh");
        Chords.addChord("min/maj13", "1 b3 5 7 9 11 13", "minor/major thirteenth");
        Chords.addChord("m", "1 b3 5", "minor");
        Chords.addChord("m7", "1 b3 5 b7", "minor seventh");
        Chords.addChord("m7-5", "1 b3 b5 b7", "half diminished");
        Chords.addChord("m6", "1 b3 5 6", "minor sixth");
        Chords.addChord("m9", "1 b3 5 b7 9", "minor ninth");
        Chords.addChord("m9-5", "1 b3 b5 b7 9", "minor ninth diminished fifth");
        Chords.addChord("m7-9", "1 b3 5 b7 b9", "minor seventh flat nine");
        Chords.addChord("m7-9-5", "1 b3 b5 b7 b9", "minor seventh flat nine diminished fifth");
        Chords.addChord("m7/11", "1 b3 5 b7 11", "minor seven eleven");
        Chords.addChord("m6/7", "1 b3 5 6 b7", "minor six seven");
        Chords.addChord("m6/9", "1 b3 5 6 9", "minor six nine");
        Chords.addChord("m11", "1 b3 5 b7 9 11", "minor eleventh");
        Chords.addChord("m11-9", "1 b3 5 b7 b9 11", "minor eleventh flat nine");
        Chords.addChord("m11-9-5", "1 b3 b5 b7 b9 11", "minor eleventh flat nine diminished fifth");
        Chords.addChord("m11-5", "1 b3 b5 b7 9 11", "minor eleventh diminished fifth");
        Chords.addChord("m6/7/11", "1 b3 5 6 b7 11", "minor six seven eleven");
        Chords.addChord("m13/11", "1 b3 5 9 11 13", "minor thirteen eleven");
        Chords.addChord("m13", "1 b3 5 b7 9 11 13", "minor thirteenth");
        Chords.addChord("m13-9", "1 b3 5 b7 b9 11 13", "minor thirteenth flat nine");
        Chords.addChord("m13-5", "1 b3 b5 b7 9 11 13", "minor thriteenth diminished fifth");
        Chords.addChord("m11-13", "1 b3 5 b7 9 11 b13", "minor eleventh diminished thirteenth");
        Chords.addChord("m11-9-13", "1 b3 5 b7 b9 11 b13", "minor eleventh diminished ninth diminished thirteenth");
        Chords.addChord("m11-9-5-13", "1 b3 b5 b7 b9 11 b13", "minor eleventh diminished ninth diminished fifth diminshed thirteenth");
        Chords.addChord("aug", "1 3 #5", "augmented");
        Chords.addChord("7", "1 3 5 b7", "seventh");
        Chords.addChord("7-5", "1 3 b5 b7", "seventh flat 5");
        Chords.addChord("7+5", "1 3 #5 b7", "seventh sharp 5");
        Chords.addChord("9", "1 3 5 b7 9", "ninth");
        Chords.addChord("9-5", "1 3 b5 b7 9", "ninth diminished fifth");
        Chords.addChord("9+5", "1 3 #5 b7 9", "ninth augmented fifth");
        Chords.addChord("7-9", "1 3 5 b7 b9", "seventh flat 9");
        Chords.addChord("7-9-5", "1 3 b5 b7 b9", "seventh flat 9 dimished fifth");
        Chords.addChord("7-9+5", "1 3 #5 b7 b9", "seventh flat 9 augmented fifth");
        Chords.addChord("7+9", "1 3 5 b7 #9", "seventh augmented ninth");
        Chords.addChord("7+9-5", "1 3 b5 b7 #9", "seventh augmented ninth diminished fifth");
        Chords.addChord("7+9+5", "1 3 #5 b7 #9", "seventh augmented ninth augmented fifth");
        Chords.addChord("7/11", "1 3 5 b7 11", "seven eleven");
        Chords.addChord("11", "1 3 5 b7 9 11", "eleventh");
        Chords.addChord("11+9", "1 3 5 b7 #9 11", "eleventh augmented ninth");
        Chords.addChord("11+9+5", "1 3 #5 b7 #9 11", "eleventh augmented ninth augmented fifth");
        Chords.addChord("11+9-5", "1 3 b5 b7 #9 11", "eleventh augmented ninth diminished fifth");
        Chords.addChord("11-9", "1 3 5 b7 b9 11", "eleventh diminished ninth");
        Chords.addChord("11-9+5", "1 3 #5 b7 b9 11", "eleventh diminished ninth augmented fifth");
        Chords.addChord("11-9-5", "1 3 b5 b7 b9 11", "eleventh diminished ninth diminished fifth");
        Chords.addChord("7+11", "1 3 5 b7 9 #11", "seventh augmented eleventh");
        Chords.addChord("7+11+9", "1 3 5 b7 #9 #11", "seventh augmented eleventh augmented ninth");
        Chords.addChord("7+11+9+5", "1 3 #5 b7 #9 #11", "seventh augmented eleventh augmented ninth augmented fifth");
        Chords.addChord("7+11-9", "1 3 5 b7 b9 #11", "seventh augmented eleventh diminished ninth");
        Chords.addChord("7+11-9+5", "1 3 #5 b7 b9 #11", "seventh augmented eleventh diminished ninth augmented fifth");
        Chords.addChord("13", "1 3 5 b7 9 11 13", "thirteenth");
        Chords.addChord("13+9", "1 3 5 b7 #9 11 13", "thirteenth augmented ninth");
        Chords.addChord("13+9+5", "1 3 #5 b7 #9 11 13", "thirteenth augmented ninth augmented fifth");
        Chords.addChord("13+9-5", "1 3 b5 b7 #9 11 13", "thirteenth augmented ninth diminished fifth");
        Chords.addChord("13-9", "1 3 5 b7 b9 11 13", "thirteenth diminished ninth");
        Chords.addChord("13-9+5", "1 3 #5 b7 b9 11 13", "thirteenth diminished ninth");
        Chords.addChord("13-9-5", "1 3 b5 b7 b9 11 13", "thirteenth diminished ninth");
        Chords.addChord("13+11", "1 3 5 b7 9 #11 13", "thirteenth augmented eleventh");
        Chords.addChord("13+11+9", "1 3 5 b7 #9 #11 13", "thirteenth augmented eleventh augmented ninth");
        Chords.addChord("13+11+9+5", "1 3 #5 b7 #9 #11 13", "thirteenth augmented eleventh augmented ninth augmented fifth");
        Chords.addChord("13+11-9", "1 3 5 b7 b9 #11 13", "thirteenth augmented eleventh diminished ninth");
        Chords.addChord("13+11-9+5", "1 3 #5 b7 b9 #11 13", "thirteenth augmented eleventh diminished ninth augmented fifth");
        Chords.addChord("13sus4", "1 4 5 b7 9 13", "thirteenth suspended fourth");
        Chords.addChord("sus4", "1 4 5", "suspended fourth");
        Chords.addChord("sus2", "1 2 5", "suspended second");
        Chords.addChord("add4", "1 3 4 5", "added fourth");
        Chords.addChord("add2", "1 2 3 5", "added second");
        Chords.addChord("5", "1 5", "power");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Identifier {
        public List<Chord.PitchedVoicing> withNotes(int[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultIdentifier
    implements Identifier {
        @Override
        public List<Chord.PitchedVoicing> withNotes(int[] notes) {
            ArrayList<Chord.PitchedVoicing> matches = new ArrayList<Chord.PitchedVoicing>();
            notes = Pitch.distinctClasses(notes);
            int[] intervals = new int[notes.length];
            int rootStart = 0;
            this.root(0, notes, intervals);
            Chord chord = Chords.withIntervals(intervals);
            if (chord != null) {
                matches.add(new Chord.PitchedVoicing(new Chord.Voicing(chord), notes[0]));
                ++rootStart;
            }
            int missing = 0;
            while (missing < 3) {
                int root = rootStart;
                while (root < notes.length) {
                    int nmatch = 0;
                    this.root(root, notes, intervals);
                    this.compress(intervals);
                    boolean sixth = this.expand(intervals);
                    List<Chord.Voicing> voicings = Chords.withIntervals(intervals, missing);
                    int i = 0;
                    while (i < voicings.size()) {
                        matches.add(new Chord.PitchedVoicing(voicings.get(i), notes[root], notes[0]));
                        ++nmatch;
                        ++i;
                    }
                    if (sixth) {
                        this.toggle(intervals, 9);
                        voicings = Chords.withIntervals(intervals, missing);
                        i = 0;
                        while (i < voicings.size()) {
                            matches.add(new Chord.PitchedVoicing(voicings.get(i), notes[root], notes[0]));
                            ++nmatch;
                            ++i;
                        }
                    }
                    if (nmatch == 0 && root != notes.length - 1) {
                        int[] slashNotes = new int[notes.length - 1];
                        int[] slashIntervals = new int[slashNotes.length];
                        int bassNote = notes[root];
                        int i2 = 0;
                        int j = 0;
                        while (i2 < notes.length) {
                            int note = notes[i2];
                            if (note != bassNote) {
                                slashNotes[j++] = note;
                            }
                            ++i2;
                        }
                        this.root(root, slashNotes, slashIntervals);
                        this.compress(slashIntervals);
                        sixth = this.expand(slashIntervals);
                        voicings = Chords.withIntervals(slashIntervals, missing);
                        i2 = 0;
                        while (i2 < voicings.size()) {
                            matches.add(new Chord.PitchedVoicing(voicings.get(i2), slashNotes[root], bassNote));
                            ++nmatch;
                            ++i2;
                        }
                        if (sixth) {
                            this.toggle(intervals, 9);
                            voicings = Chords.withIntervals(slashIntervals, missing);
                            i2 = 0;
                            while (i2 < voicings.size()) {
                                matches.add(new Chord.PitchedVoicing(voicings.get(i2), slashNotes[root], bassNote));
                                ++nmatch;
                                ++i2;
                            }
                        }
                    }
                    ++root;
                }
                if (matches.size() > 0) break;
                ++missing;
            }
            return matches;
        }

        protected void root(int root, int[] notes, int[] intervals) {
            int i = 0;
            while (i < intervals.length) {
                int tmp = notes[i] - notes[root];
                while (tmp < 0) {
                    tmp += 12;
                }
                while (tmp > 23) {
                    tmp -= 12;
                }
                intervals[i] = tmp;
                ++i;
            }
            Arrays.sort(intervals);
        }

        protected void compress(int[] intervals) {
            int i = 0;
            while (i < intervals.length) {
                intervals[i] = intervals[i] % 12;
                ++i;
            }
            Arrays.sort(intervals);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected boolean expand(int[] intervals) {
            int len = intervals.length;
            boolean sixth = false;
            int i = 0;
            while (i < len) {
                block11: {
                    int tmp = intervals[i];
                    switch (tmp) {
                        case 0: 
                        case 4: 
                        case 7: 
                        case 10: 
                        case 11: {
                            break block11;
                        }
                        case 1: {
                            tmp += 12;
                            break;
                        }
                        case 2: {
                            int tmp2;
                            if (i + 1 >= len || (tmp2 = intervals[i + 1]) != 3 && tmp2 != 4 && tmp2 != 5) break;
                            tmp += 12;
                            break;
                        }
                        case 3: {
                            int tmp2;
                            if (i + 1 >= len || (tmp2 = intervals[i + 1]) != 4) break;
                            tmp += 12;
                            break;
                        }
                        case 5: {
                            int tmp2;
                            if (i - 1 < 0 || (tmp2 = intervals[i - 1]) != 3 && tmp2 != 4) break;
                            tmp += 12;
                            break;
                        }
                        case 6: {
                            int tmp2;
                            if (i + 1 >= len || (tmp2 = intervals[i + 1]) != 7 && tmp2 != 8) break;
                            tmp += 12;
                            break;
                        }
                        case 8: {
                            int tmp2;
                            if (i - 1 < 0 || (tmp2 = intervals[i - 1]) != 6) break;
                            tmp += 12;
                            break;
                        }
                        case 9: {
                            tmp += 12;
                            sixth = true;
                        }
                    }
                    intervals[i] = tmp;
                }
                ++i;
            }
            Arrays.sort(intervals);
            return sixth;
        }

        protected void toggle(int[] intervals, int value) {
            int i = 0;
            while (i < intervals.length) {
                if (intervals[i] % 12 == value) {
                    intervals[i] = value + value + 12 - intervals[i];
                    break;
                }
                ++i;
            }
            Arrays.sort(intervals);
        }
    }
}

