/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midix.control.neck;

import uk.org.toot.music.tonality.Pitch;

public class StringTuning {
    private int polyphony;
    private int[] pitchClasses;
    private int[] regOffsets;
    private int register;
    private boolean low = false;

    public StringTuning(String tuning, int reg) {
        if (tuning.indexOf("Low") >= 0) {
            --reg;
            this.low = true;
        }
        String t = tuning.substring(0, tuning.indexOf(" -"));
        String[] p = t.split("\\s");
        this.polyphony = p.length;
        this.pitchClasses = new int[this.polyphony];
        this.regOffsets = new int[this.polyphony];
        this.register = reg;
        int i = 0;
        while (i < this.polyphony) {
            this.pitchClasses[i] = Pitch.classValue(p[i]);
            this.regOffsets[i] = reg - this.register;
            if (i < this.polyphony - 1 && Pitch.classValue(p[i + 1]) < this.pitchClasses[i]) {
                ++reg;
            }
            ++i;
        }
    }

    public int getPolyphony() {
        return this.polyphony;
    }

    public int getRegister() {
        return this.register;
    }

    public void setRegister(int reg) {
        this.register = reg;
    }

    public int getPitch(int string) {
        return Pitch.value(this.pitchClasses[string], this.register + this.regOffsets[string]);
    }

    public int getDoubleInterval(int string) {
        return string > 3 ? 0 : 12;
    }

    public boolean isLow() {
        return this.low;
    }
}

