/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midix.control.neck;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import uk.org.toot.midi.misc.GM;
import uk.org.toot.midix.control.neck.BassFamily;
import uk.org.toot.midix.control.neck.GuitarFamily;
import uk.org.toot.midix.control.neck.Tunings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeckFamily
extends Observable {
    private int register;
    private int GMfamily;
    private Tunings tunings;
    private static ArrayList<NeckFamily> families = new ArrayList();

    static {
        families.add(new GuitarFamily());
        families.add(new BassFamily());
    }

    protected NeckFamily(int reg, int family, Tunings t) {
        this.register = reg;
        this.GMfamily = family;
        this.tunings = t;
    }

    public static NeckFamily named(String name) {
        for (NeckFamily f : families) {
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return families.get(0);
    }

    public static List<NeckFamily> families() {
        return families;
    }

    public int getRegister() {
        return this.register;
    }

    public int getGMFamily() {
        return this.GMfamily;
    }

    public String getName() {
        return GM.melodicFamilyName(this.GMfamily);
    }

    public Tunings getTunings() {
        return this.tunings;
    }
}

