/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import uk.org.toot.midi.core.AbstractMidiDevice;
import uk.org.toot.midi.core.DefaultMidiOutput;
import uk.org.toot.midi.core.MidiInput;
import uk.org.toot.midi.sequencer.EventDispatcher;
import uk.org.toot.midi.sequencer.FastShortMessage;
import uk.org.toot.midi.sequencer.JSSecurityManager;
import uk.org.toot.midi.sequencer.MidiUtils;
import uk.org.toot.midi.sequencer.SequencerTrack;
import uk.org.toot.transport.TransportListener;

public class MidiSequencer
extends AbstractMidiDevice
implements TransportListener {
    private static final boolean DEBUG_PUMP = false;
    private static final boolean DEBUG_PUMP_ALL = false;
    private static final EventDispatcher eventDispatcher;
    private static Sequencer.SyncMode[] masterSyncModes;
    private static Sequencer.SyncMode[] slaveSyncModes;
    private static Sequencer.SyncMode masterSyncMode;
    private static Sequencer.SyncMode slaveSyncMode;
    private Sequence sequence = null;
    private double cacheTempoMPQ = -1.0;
    private float cacheTempoFactor = -1.0f;
    private boolean[] trackMuted = null;
    private boolean[] trackSolo = null;
    private MidiUtils.TempoCache tempoCache = new MidiUtils.TempoCache();
    private boolean running = false;
    private PlayEngine playEngine;
    private boolean recording = false;

    static {
        masterSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
        slaveSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
        masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
        slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
        eventDispatcher = new EventDispatcher();
        eventDispatcher.start();
    }

    public MidiSequencer() {
        super("Sequencer");
    }

    public synchronized void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (sequence != this.sequence) {
            if (this.sequence != null && sequence == null) {
                this.setCaches();
                this.stop();
                this.trackMuted = null;
                this.trackSolo = null;
                if (this.getDataPump() != null) {
                    this.getDataPump().setTickPos(0L);
                }
            }
            if (this.playEngine != null) {
                this.playEngine.setSequence(sequence);
            }
            this.sequence = sequence;
            if (sequence != null) {
                this.tempoCache.refresh(sequence);
                this.setTickPosition(0L);
                this.propagateCaches();
            }
        } else if (sequence != null) {
            this.tempoCache.refresh(sequence);
            if (this.playEngine != null) {
                this.playEngine.setSequence(sequence);
            }
        }
    }

    public synchronized void setSequence(InputStream stream) throws IOException, InvalidMidiDataException {
        if (stream == null) {
            this.setSequence((Sequence)null);
            return;
        }
        Sequence seq = MidiSystem.getSequence(stream);
        this.setSequence(seq);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public synchronized void play() {
        if (!this.isOpen()) {
            throw new IllegalStateException("sequencer not open");
        }
        if (this.sequence == null) {
            throw new IllegalStateException("sequence not set");
        }
        if (this.running) {
            return;
        }
        this.implPlay();
    }

    public synchronized void stop() {
        if (!this.isOpen()) {
            throw new IllegalStateException("sequencer not open");
        }
        this.stopRecording();
        if (!this.running) {
            return;
        }
        this.implStop();
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void record(boolean rec) {
        if (rec) {
            this.startRecording();
        } else {
            this.stopRecording();
        }
    }

    public void startRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.play();
        this.recording = true;
    }

    public void stopRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.recording = false;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public float getTempoInBPM() {
        return (float)MidiUtils.convertTempo(this.getTempoInMPQ());
    }

    public void setTempoInBPM(float bpm) {
        if (bpm <= 0.0f || bpm > 242.0f) {
            throw new IllegalArgumentException("bpm must be between 1 and 242");
        }
        this.setTempoInMPQ((float)MidiUtils.convertTempo(bpm));
    }

    public float getTempoInMPQ() {
        if (this.needCaching()) {
            if (this.cacheTempoMPQ != -1.0) {
                return (float)this.cacheTempoMPQ;
            }
            if (this.sequence != null) {
                return this.tempoCache.getTempoMPQAt(this.getTickPosition());
            }
            return 500000.0f;
        }
        return this.getDataPump().getTempoMPQ();
    }

    public void setTempoInMPQ(float mpq) {
        if (mpq <= 0.0f) {
            throw new IllegalArgumentException("mpq must be > 0");
        }
        if (this.needCaching()) {
            this.cacheTempoMPQ = mpq;
        } else {
            this.getDataPump().setTempoMPQ(mpq);
            this.cacheTempoMPQ = -1.0;
        }
    }

    public void setTempoFactor(float factor) {
        if (factor <= 0.1f || factor > 10.0f) {
            throw new IllegalArgumentException("tempo factor must be between 0.1 and 10");
        }
        if (this.needCaching()) {
            this.cacheTempoFactor = factor;
        } else {
            this.getDataPump().setTempoFactor(factor);
            this.cacheTempoFactor = -1.0f;
        }
    }

    public float getTempoFactor() {
        if (this.needCaching()) {
            if (this.cacheTempoFactor != -1.0f) {
                return this.cacheTempoFactor;
            }
            return 1.0f;
        }
        return this.getDataPump().getTempoFactor();
    }

    public long getTickLength() {
        if (this.sequence == null) {
            return 0L;
        }
        return this.sequence.getTickLength();
    }

    public synchronized long getTickPosition() {
        if (this.getDataPump() == null || this.sequence == null) {
            return 0L;
        }
        return this.getDataPump().getTickPos();
    }

    public synchronized void setTickPosition(long tick) {
        if (tick < 0L) {
            throw new IllegalArgumentException("tick position must be > 0");
        }
        if (this.getDataPump() == null) {
            if (tick != 0L) {
                throw new IllegalStateException("cannot set non-zero position in closed state");
            }
        } else if (this.sequence == null) {
            if (tick != 0L) {
                throw new IllegalStateException("cannot set non-zero position if sequence is not set");
            }
        } else {
            this.getDataPump().setTickPos(tick);
        }
    }

    public long getMicrosecondLength() {
        if (this.sequence == null) {
            return 0L;
        }
        return this.sequence.getMicrosecondLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMicrosecondPosition() {
        if (this.getDataPump() == null || this.sequence == null) {
            return 0L;
        }
        MidiUtils.TempoCache tempoCache = this.tempoCache;
        synchronized (tempoCache) {
            return MidiUtils.tick2microsecond(this.sequence, this.getDataPump().getTickPos(), this.tempoCache);
        }
    }

    public void locate(long microseconds) {
        this.setMicrosecondPosition(microseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMicrosecondPosition(long microseconds) {
        if (microseconds < 0L) {
            throw new IllegalArgumentException("microsecond position must be > 0");
        }
        if (this.getDataPump() == null) {
            if (microseconds != 0L) {
                throw new IllegalStateException("cannot set non-zero position in closed state");
            }
        } else if (this.sequence == null) {
            if (microseconds != 0L) {
                throw new IllegalStateException("cannot set non-zero position if sequence is not set");
            }
        } else {
            MidiUtils.TempoCache tempoCache = this.tempoCache;
            synchronized (tempoCache) {
                this.setTickPosition(MidiUtils.microsecond2tick(this.sequence, microseconds, this.tempoCache));
            }
        }
    }

    public void setMasterSyncMode(Sequencer.SyncMode sync) {
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        return masterSyncMode;
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        Sequencer.SyncMode[] returnedModes = new Sequencer.SyncMode[masterSyncModes.length];
        System.arraycopy(masterSyncModes, 0, returnedModes, 0, masterSyncModes.length);
        return returnedModes;
    }

    public void setSlaveSyncMode(Sequencer.SyncMode sync) {
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        return slaveSyncMode;
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        Sequencer.SyncMode[] returnedModes = new Sequencer.SyncMode[slaveSyncModes.length];
        System.arraycopy(slaveSyncModes, 0, returnedModes, 0, slaveSyncModes.length);
        return returnedModes;
    }

    protected int getTrackCount() {
        Sequence seq = this.getSequence();
        if (seq != null) {
            return this.sequence.getTracks().length;
        }
        return 0;
    }

    public synchronized void setTrackMute(int track, boolean mute) {
        int trackCount = this.getTrackCount();
        if (track < 0 || track >= this.getTrackCount()) {
            return;
        }
        this.trackMuted = MidiSequencer.ensureBoolArraySize(this.trackMuted, trackCount);
        this.trackMuted[track] = mute;
        if (this.getDataPump() != null) {
            this.getDataPump().muteSoloChanged();
        }
    }

    public synchronized boolean getTrackMute(int track) {
        if (track < 0 || track >= this.getTrackCount()) {
            return false;
        }
        if (this.trackMuted == null || this.trackMuted.length <= track) {
            return false;
        }
        return this.trackMuted[track];
    }

    public synchronized void setTrackSolo(int track, boolean solo) {
        int trackCount = this.getTrackCount();
        if (track < 0 || track >= this.getTrackCount()) {
            return;
        }
        this.trackSolo = MidiSequencer.ensureBoolArraySize(this.trackSolo, trackCount);
        this.trackSolo[track] = solo;
        if (this.getDataPump() != null) {
            this.getDataPump().muteSoloChanged();
        }
    }

    public synchronized boolean getTrackSolo(int track) {
        if (track < 0 || track >= this.getTrackCount()) {
            return false;
        }
        if (this.trackSolo == null || this.trackSolo.length <= track) {
            return false;
        }
        return this.trackSolo[track];
    }

    public void open() throws MidiUnavailableException {
        this.playEngine = new PlayEngine();
        if (this.sequence != null) {
            this.playEngine.setSequence(this.sequence);
        }
        this.propagateCaches();
    }

    private synchronized void propagateCaches() {
        if (this.sequence != null && this.isOpen()) {
            if (this.cacheTempoFactor != -1.0f) {
                this.setTempoFactor(this.cacheTempoFactor);
            }
            if (this.cacheTempoMPQ == -1.0) {
                this.setTempoInMPQ(new MidiUtils.TempoCache(this.sequence).getTempoMPQAt(this.getTickPosition()));
            } else {
                this.setTempoInMPQ((float)this.cacheTempoMPQ);
            }
        }
    }

    private synchronized void setCaches() {
        this.cacheTempoFactor = this.getTempoFactor();
        this.cacheTempoMPQ = this.getTempoInMPQ();
    }

    public synchronized void close() {
        if (this.playEngine != null) {
            this.playEngine.close();
            this.playEngine = null;
        }
        this.sequence = null;
        this.running = false;
        this.cacheTempoMPQ = -1.0;
        this.cacheTempoFactor = -1.0f;
        this.trackMuted = null;
        this.trackSolo = null;
    }

    protected void implPlay() {
        if (this.playEngine == null) {
            return;
        }
        this.tempoCache.refresh(this.sequence);
        if (!this.running) {
            this.running = true;
            this.playEngine.start();
        }
    }

    protected void implStop() {
        if (this.playEngine == null) {
            return;
        }
        this.recording = false;
        if (this.running) {
            this.running = false;
            this.playEngine.stop();
        }
    }

    private boolean needCaching() {
        return !this.isOpen() || this.sequence == null || this.playEngine == null;
    }

    private DataPump getDataPump() {
        if (this.playEngine != null) {
            return this.playEngine.getDataPump();
        }
        return null;
    }

    private MidiUtils.TempoCache getTempoCache() {
        return this.tempoCache;
    }

    private static boolean[] ensureBoolArraySize(boolean[] array, int desiredSize) {
        if (array == null) {
            return new boolean[desiredSize];
        }
        if (array.length < desiredSize) {
            boolean[] newArray = new boolean[desiredSize];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    class PlayEngine
    implements Runnable {
        private Thread thread;
        private Object lock = new Object();
        boolean interrupted = false;
        boolean isPumping = false;
        private DataPump dataPump;

        PlayEngine() {
            this.dataPump = new DataPump();
            int priority = 8;
            this.thread = JSSecurityManager.createThread(this, "Java Sound Sequencer", false, priority, true);
        }

        DataPump getDataPump() {
            return this.dataPump;
        }

        synchronized void setSequence(Sequence seq) {
            this.dataPump.setSequence(seq);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void start() {
            MidiSequencer.this.running = true;
            if (!this.dataPump.hasCachedTempo()) {
                long tickPos = MidiSequencer.this.getTickPosition();
                this.dataPump.setTempoMPQ(MidiSequencer.this.tempoCache.getTempoMPQAt(tickPos));
            }
            this.dataPump.checkPointMillis = 0L;
            this.dataPump.clearNoteOnCache();
            this.dataPump.needReindex = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop() {
            this.playThreadImplStop();
            long t = System.nanoTime() / 1000000L;
            while (this.isPumping) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (System.nanoTime() / 1000000L - t <= 1900L) continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void playThreadImplStop() {
            MidiSequencer.this.running = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Thread oldThread = null;
            Object object = this;
            synchronized (object) {
                this.interrupted = true;
                oldThread = this.thread;
                this.thread = null;
            }
            if (oldThread != null) {
                object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            if (oldThread != null) {
                try {
                    oldThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                boolean EOM = false;
                boolean wasRunning = MidiSequencer.this.running;
                this.isPumping = !this.interrupted && MidiSequencer.this.running;
                while (!EOM && !this.interrupted && MidiSequencer.this.running) {
                    EOM = this.dataPump.pump();
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.playThreadImplStop();
                if (wasRunning) {
                    this.dataPump.notesOff(true);
                }
                if (EOM) {
                    this.dataPump.setTickPos(MidiSequencer.this.sequence.getTickLength());
                }
                Object object = this.lock;
                synchronized (object) {
                    this.isPumping = false;
                    this.lock.notifyAll();
                    while (!MidiSequencer.this.running && !this.interrupted) {
                        try {
                            this.lock.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private class DataPump {
        private float currTempo;
        private float tempoFactor;
        private float inverseTempoFactor;
        private long ignoreTempoEventAt;
        private int resolution;
        private float divisionType;
        private long checkPointMillis;
        private long checkPointTick;
        private List<SequencerTrack> seqTracks = new ArrayList<SequencerTrack>();
        private boolean[] trackDisabled;
        private long lastTick;
        private boolean needReindex = false;

        DataPump() {
            this.init();
        }

        synchronized void init() {
            this.ignoreTempoEventAt = -1L;
            this.tempoFactor = 1.0f;
            this.inverseTempoFactor = 1.0f;
            this.trackDisabled = null;
        }

        synchronized void setTickPos(long tickPos) {
            long oldLastTick = tickPos;
            this.lastTick = tickPos;
            if (MidiSequencer.this.running) {
                this.notesOff(false);
            }
            if (MidiSequencer.this.running || tickPos > 0L) {
                this.chaseEvents(oldLastTick, tickPos);
            } else {
                this.needReindex = true;
            }
            if (!this.hasCachedTempo()) {
                this.setTempoMPQ(MidiSequencer.this.getTempoCache().getTempoMPQAt(this.lastTick, this.currTempo));
                this.ignoreTempoEventAt = -1L;
            }
            this.checkPointMillis = 0L;
        }

        long getTickPos() {
            return this.lastTick;
        }

        boolean hasCachedTempo() {
            if (this.ignoreTempoEventAt != this.lastTick) {
                this.ignoreTempoEventAt = -1L;
            }
            return this.ignoreTempoEventAt >= 0L;
        }

        synchronized void setTempoMPQ(float tempoMPQ) {
            if (tempoMPQ > 0.0f && tempoMPQ != this.currTempo) {
                this.ignoreTempoEventAt = this.lastTick;
                this.currTempo = tempoMPQ;
                this.checkPointMillis = 0L;
            }
        }

        float getTempoMPQ() {
            return this.currTempo;
        }

        synchronized void setTempoFactor(float factor) {
            if (factor > 0.0f && factor != this.tempoFactor) {
                this.tempoFactor = factor;
                this.inverseTempoFactor = 1.0f / factor;
                this.checkPointMillis = 0L;
            }
        }

        float getTempoFactor() {
            return this.tempoFactor;
        }

        synchronized void muteSoloChanged() {
            boolean[] newDisabled = this.makeDisabledArray();
            if (MidiSequencer.this.running) {
                this.applyDisabledTracks(this.trackDisabled, newDisabled);
            }
            this.trackDisabled = newDisabled;
        }

        synchronized void setSequence(Sequence seq) {
            if (seq == null) {
                this.init();
                return;
            }
            Track[] tracks = seq.getTracks();
            this.seqTracks.clear();
            MidiSequencer.this.removeAllMidiOutputs();
            MidiSequencer.this.removeAllMidiInputs();
            int i = 0;
            while (i < tracks.length) {
                this.seqTracks.add(new DefaultSequencerTrack(tracks[i], i));
                ++i;
            }
            this.muteSoloChanged();
            this.resolution = seq.getResolution();
            this.divisionType = seq.getDivisionType();
            this.checkPointMillis = 0L;
            this.needReindex = true;
        }

        void clearNoteOnCache() {
            for (SequencerTrack t : this.seqTracks) {
                t.clearNoteOnCache();
            }
        }

        void notesOff(boolean doControllers) {
            for (SequencerTrack t : this.seqTracks) {
                t.notesOff(doControllers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean[] makeDisabledArray() {
            int i;
            boolean[] solo;
            boolean[] mute;
            if (this.seqTracks.isEmpty()) {
                return null;
            }
            boolean[] newTrackDisabled = new boolean[this.seqTracks.size()];
            MidiSequencer midiSequencer = MidiSequencer.this;
            synchronized (midiSequencer) {
                mute = MidiSequencer.this.trackMuted;
                solo = MidiSequencer.this.trackSolo;
            }
            boolean hasSolo = false;
            if (solo != null) {
                i = 0;
                while (i < solo.length) {
                    if (solo[i]) {
                        hasSolo = true;
                        break;
                    }
                    ++i;
                }
            }
            if (hasSolo) {
                i = 0;
                while (i < newTrackDisabled.length) {
                    newTrackDisabled[i] = i >= solo.length || !solo[i];
                    ++i;
                }
            } else {
                i = 0;
                while (i < newTrackDisabled.length) {
                    newTrackDisabled[i] = mute != null && i < mute.length && mute[i];
                    ++i;
                }
            }
            return newTrackDisabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyDisabledTracks(boolean[] oldDisabled, boolean[] newDisabled) {
            byte[][] tempArray = null;
            MidiSequencer midiSequencer = MidiSequencer.this;
            synchronized (midiSequencer) {
                int i = 0;
                while (i < newDisabled.length) {
                    if ((oldDisabled == null || i >= oldDisabled.length || !oldDisabled[i]) && newDisabled[i]) {
                        if (this.seqTracks.size() > i) {
                            this.seqTracks.get(i).notesOff(false);
                        }
                    } else if (oldDisabled != null && i < oldDisabled.length && oldDisabled[i] && !newDisabled[i]) {
                        if (tempArray == null) {
                            tempArray = new byte[128][16];
                        }
                        this.seqTracks.get(i).chaseEvents(0L, this.lastTick, true, tempArray);
                    }
                    ++i;
                }
            }
        }

        synchronized void chaseEvents(long startTick, long endTick) {
            byte[][] tempArray = new byte[128][16];
            int t = 0;
            while (t < this.seqTracks.size()) {
                if (this.trackDisabled == null || this.trackDisabled.length <= t || !this.trackDisabled[t]) {
                    this.seqTracks.get(t).chaseEvents(startTick, endTick, true, tempArray);
                }
                ++t;
            }
        }

        private long getCurrentTimeMillis() {
            return System.nanoTime() / 1000000L;
        }

        private long millis2tick(long millis) {
            if (this.divisionType != 0.0f) {
                double dTick = (double)millis * (double)this.tempoFactor * (double)this.divisionType * (double)this.resolution / 1000.0;
                return (long)dTick;
            }
            return MidiUtils.microsec2ticks(millis * 1000L, this.currTempo * this.inverseTempoFactor, this.resolution);
        }

        private long tick2millis(long tick) {
            if (this.divisionType != 0.0f) {
                double dMillis = (double)tick * 1000.0 / ((double)this.tempoFactor * (double)this.divisionType * (double)this.resolution);
                return (long)dMillis;
            }
            return MidiUtils.ticks2microsec(tick, this.currTempo * this.inverseTempoFactor, this.resolution) / 1000L;
        }

        synchronized boolean pump() {
            long targetTick = this.lastTick;
            boolean changesPending = false;
            boolean EOM = false;
            long currMillis = this.getCurrentTimeMillis();
            int finishedTracks = 0;
            do {
                changesPending = false;
                if (this.needReindex) {
                    for (SequencerTrack t : this.seqTracks) {
                        t.reindex(targetTick);
                    }
                    this.needReindex = false;
                    this.checkPointMillis = 0L;
                }
                if (this.checkPointMillis == 0L) {
                    this.checkPointMillis = currMillis = this.getCurrentTimeMillis();
                    this.checkPointTick = targetTick = this.lastTick;
                } else {
                    this.lastTick = targetTick = this.checkPointTick + this.millis2tick(currMillis - this.checkPointMillis);
                }
                finishedTracks = 0;
                int t = 0;
                while (t < this.seqTracks.size()) {
                    block9: {
                        SequencerTrack seqTrack = this.seqTracks.get(t);
                        try {
                            boolean disabled = this.trackDisabled[t];
                            changesPending = seqTrack.pump(targetTick, disabled, t == 0);
                            if (seqTrack.isFinished()) {
                                ++finishedTracks;
                            }
                        }
                        catch (Exception e) {
                            if (!(e instanceof ArrayIndexOutOfBoundsException)) break block9;
                            this.needReindex = true;
                            changesPending = true;
                        }
                    }
                    if (changesPending) break;
                    ++t;
                }
                boolean bl = EOM = finishedTracks == this.seqTracks.size();
            } while (changesPending);
            return EOM;
        }

        public abstract class AbstractSequencerTrack
        implements SequencerTrack {
            private DefaultMidiOutput outPort;
            private int[] noteOnCache = new int[128];
            protected boolean finished = false;
            private ArrayList<MetaEventListener> metaEventListeners = new ArrayList();

            protected void createPorts(String name) {
                if (this.outPort == null) {
                    this.outPort = new DefaultMidiOutput("Sequencer: " + name);
                    MidiSequencer.this.addMidiOutput(this.outPort);
                }
            }

            public boolean isFinished() {
                return this.finished;
            }

            public void clearNoteOnCache() {
                int i = 0;
                while (i < 128) {
                    this.noteOnCache[i] = 0;
                    ++i;
                }
            }

            public void notesOff(boolean doControllers) {
                int done = 0;
                int ch = 0;
                while (ch < 16) {
                    int channelMask = 1 << ch;
                    int i = 0;
                    while (i < 128) {
                        if ((this.noteOnCache[i] & channelMask) != 0) {
                            int n = i;
                            this.noteOnCache[n] = this.noteOnCache[n] ^ channelMask;
                            this.sendMessage(0x90 | ch | i << 8, -1L);
                            ++done;
                        }
                        ++i;
                    }
                    this.sendMessage(0xB0 | ch | 0x7B00, -1L);
                    this.sendMessage(0xB0 | ch | 0x4000, -1L);
                    if (doControllers) {
                        this.sendMessage(0xB0 | ch | 0x7900, -1L);
                        ++done;
                    }
                    ++ch;
                }
            }

            protected void sendMessage(MidiMessage msg, long timestamp) {
                this.outPort.transport(msg, timestamp);
                int msgStatus = msg.getStatus();
                switch (msgStatus & 0xF0) {
                    case 128: {
                        int note;
                        int n = note = ((ShortMessage)msg).getData1() & 0x7F;
                        this.noteOnCache[n] = this.noteOnCache[n] & (0xFFFF ^ 1 << (msgStatus & 0xF));
                        break;
                    }
                    case 144: {
                        ShortMessage smsg = (ShortMessage)msg;
                        int note = smsg.getData1() & 0x7F;
                        int vel = smsg.getData2() & 0x7F;
                        if (vel > 0) {
                            int n = note;
                            this.noteOnCache[n] = this.noteOnCache[n] | 1 << (msgStatus & 0xF);
                            break;
                        }
                        int n = note;
                        this.noteOnCache[n] = this.noteOnCache[n] & (0xFFFF ^ 1 << (msgStatus & 0xF));
                    }
                }
            }

            protected void sendMessage(int m, long timestamp) {
                try {
                    this.sendMessage(new FastShortMessage(m), timestamp);
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    // empty catch block
                }
            }

            protected boolean dispatchMessage(boolean masterTrack, MidiEvent event) {
                boolean changesPending = false;
                MidiMessage message = event.getMessage();
                int msgStatus = message.getStatus();
                int msgLen = message.getLength();
                if (msgStatus == 255 && msgLen >= 2) {
                    int newTempo;
                    if (masterTrack && (newTempo = MidiUtils.getTempoMPQ(message)) > 0) {
                        if (event.getTick() != DataPump.this.ignoreTempoEventAt) {
                            DataPump.this.setTempoMPQ(newTempo);
                            changesPending = true;
                        }
                        DataPump.this.ignoreTempoEventAt = -1L;
                    }
                    this.sendMetaEvents(message);
                } else {
                    this.sendMessage(message, -1L);
                }
                return changesPending;
            }

            public void chaseEvents(long startTick, long endTick, boolean doReindex, byte[][] tempArray) {
            }

            public abstract void reindex(long var1);

            public abstract boolean pump(long var1, boolean var3, boolean var4);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean addMetaEventListener(MetaEventListener listener) {
                ArrayList<MetaEventListener> arrayList = this.metaEventListeners;
                synchronized (arrayList) {
                    if (!this.metaEventListeners.contains(listener)) {
                        this.metaEventListeners.add(listener);
                    }
                    return true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeMetaEventListener(MetaEventListener listener) {
                ArrayList<MetaEventListener> arrayList = this.metaEventListeners;
                synchronized (arrayList) {
                    int index = this.metaEventListeners.indexOf(listener);
                    if (index >= 0) {
                        this.metaEventListeners.remove(index);
                    }
                }
            }

            protected void sendMetaEvents(MidiMessage message) {
                if (this.metaEventListeners.size() == 0) {
                    return;
                }
                eventDispatcher.sendAudioEvents(message, this.metaEventListeners);
            }
        }

        private class DefaultSequencerTrack
        extends AbstractSequencerTrack {
            private Track track;
            private int trackReadPos;
            private MidiInput inPort;
            private boolean record = false;

            DefaultSequencerTrack(Track t, int i) {
                this.track = t;
                this.createPorts(String.valueOf(i));
            }

            protected void createPorts(String name) {
                super.createPorts(name);
                if (this.inPort == null) {
                    this.inPort = new RecordingInput("Sequencer: " + name);
                    MidiSequencer.this.addMidiInput(this.inPort);
                }
            }

            public void chaseEvents(long startTick, long endTick, boolean doReindex, byte[][] tempArray) {
                if (startTick > endTick) {
                    startTick = 0L;
                }
                byte[] progs = new byte[16];
                int ch = 0;
                while (ch < 16) {
                    progs[ch] = -1;
                    int co = 0;
                    while (co < 128) {
                        tempArray[co][ch] = -1;
                        ++co;
                    }
                    ++ch;
                }
                int size = this.track.size();
                try {
                    int i = 0;
                    while (i < size) {
                        byte[] data;
                        ShortMessage smsg;
                        MidiEvent event = this.track.get(i);
                        if (event.getTick() >= endTick) {
                            if (doReindex) {
                                this.trackReadPos = i > 0 ? i - 1 : 0;
                            }
                            break;
                        }
                        MidiMessage msg = event.getMessage();
                        int status = msg.getStatus();
                        int len = msg.getLength();
                        if (len == 3 && (status & 0xF0) == 176) {
                            if (msg instanceof ShortMessage) {
                                smsg = (ShortMessage)msg;
                                tempArray[smsg.getData1() & 0x7F][status & 0xF] = (byte)smsg.getData2();
                            } else {
                                data = msg.getMessage();
                                tempArray[data[1] & 0x7F][status & 0xF] = data[2];
                            }
                        }
                        if (len == 2 && (status & 0xF0) == 192) {
                            if (msg instanceof ShortMessage) {
                                smsg = (ShortMessage)msg;
                                progs[status & 0xF] = (byte)smsg.getData1();
                            } else {
                                data = msg.getMessage();
                                progs[status & 0xF] = data[1];
                            }
                        }
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException i) {
                    // empty catch block
                }
                int numControllersSent = 0;
                int ch2 = 0;
                while (ch2 < 16) {
                    int co = 0;
                    while (co < 128) {
                        byte controllerValue = tempArray[co][ch2];
                        if (controllerValue >= 0) {
                            int packedMsg = 0xB0 | ch2 | co << 8 | controllerValue << 16;
                            this.sendMessage(packedMsg, -1L);
                            ++numControllersSent;
                        }
                        ++co;
                    }
                    if (progs[ch2] >= 0) {
                        this.sendMessage(0xC0 | ch2 | progs[ch2] << 8, -1L);
                    }
                    if (progs[ch2] >= 0 || startTick == 0L || endTick == 0L) {
                        this.sendMessage(0xE0 | ch2 | 0x400000, -1L);
                        this.sendMessage(0xB0 | ch2 | 0x4000, -1L);
                    }
                    ++ch2;
                }
            }

            public void reindex(long tick) {
                this.trackReadPos = MidiUtils.tick2index(this.track, tick);
            }

            public boolean pump(long targetTick, boolean disabled, boolean masterTrack) {
                MidiEvent currEvent;
                boolean changesPending = false;
                int readPos = this.trackReadPos;
                int size = this.track.size();
                while (!changesPending && readPos < size && (currEvent = this.track.get(readPos)).getTick() <= targetTick) {
                    if (readPos == size - 1 && MidiUtils.isMetaEndOfTrack(currEvent.getMessage())) {
                        readPos = size;
                        break;
                    }
                    ++readPos;
                    if (disabled && (!masterTrack || !MidiUtils.isMetaTempo(currEvent.getMessage()))) continue;
                    changesPending = this.dispatchMessage(masterTrack, currEvent);
                }
                this.trackReadPos = readPos;
                if (readPos >= size) {
                    this.finished = true;
                }
                return changesPending;
            }

            public void recordEnable() {
                this.record = true;
            }

            public void recordDisable() {
                this.record = true;
            }

            private class RecordingInput
            implements MidiInput {
                private String name;

                public RecordingInput(String name) {
                    this.name = name;
                }

                public String getName() {
                    return this.name;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void transport(MidiMessage message, long timeStamp) {
                    if (DefaultSequencerTrack.this.record) {
                        long tickPos = 0L;
                        if (timeStamp < 0L) {
                            tickPos = MidiSequencer.this.getTickPosition();
                        } else {
                            MidiUtils.TempoCache tempoCache = MidiSequencer.this.tempoCache;
                            synchronized (tempoCache) {
                                tickPos = MidiUtils.microsecond2tick(MidiSequencer.this.sequence, timeStamp, MidiSequencer.this.tempoCache);
                            }
                        }
                        if (message.getLength() > 1) {
                            message = message instanceof ShortMessage ? new FastShortMessage((ShortMessage)message) : (MidiMessage)message.clone();
                            MidiEvent me = new MidiEvent(message, tickPos);
                            DefaultSequencerTrack.this.track.add(me);
                        }
                    }
                }
            }
        }
    }
}

