/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.message;

import java.io.File;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import uk.org.toot.midi.message.MidiMsg;

public class ShortMsg
extends MidiMsg {
    static MidiMessage fastShortPrototype;

    static {
        ShortMsg.createFastPrototypes();
    }

    public static boolean isShort(MidiMessage msg) {
        return msg instanceof ShortMessage;
    }

    public static boolean isShort(int status) {
        return false;
    }

    public static MidiMessage createShort(int status) throws InvalidMidiDataException {
        ShortMessage msg = (ShortMessage)fastShortPrototype.clone();
        msg.setMessage(status);
        return msg;
    }

    public static MidiMessage createShort(int status, int data1) throws InvalidMidiDataException {
        return ShortMsg.createShort(status, data1, 0);
    }

    public static MidiMessage createShort(int status, int data1, int data2) throws InvalidMidiDataException {
        ShortMessage msg = (ShortMessage)fastShortPrototype.clone();
        msg.setMessage(status, data1, data2);
        return msg;
    }

    public static MidiMessage setMessage(MidiMessage msg, int status) throws InvalidMidiDataException {
        ((ShortMessage)msg).setMessage(status);
        return msg;
    }

    public static MidiMessage setMessage(MidiMessage msg, int status, int data1, int data2) throws InvalidMidiDataException {
        ((ShortMessage)msg).setMessage(status, data1, data2);
        return msg;
    }

    private static void createFastPrototypes() {
        try {
            Sequence sequence = new Sequence(0.0f, 10);
            Track track = sequence.createTrack();
            track.add(new MidiEvent(new ShortMessage(), 0L));
            try {
                File file = File.createTempFile("FSMhack", "mid");
                MidiSystem.write(sequence, 0, file);
                sequence = MidiSystem.getSequence(file);
                track = sequence.getTracks()[0];
                MidiMessage msg = null;
                int i = 0;
                while (i < track.size()) {
                    msg = track.get(i).getMessage();
                    Class<?> clazz = msg.getClass();
                    if (fastShortPrototype == null && clazz.getCanonicalName().equals("com.sun.media.sound.FastShortMessage")) {
                        fastShortPrototype = msg;
                    }
                    ++i;
                }
                file.delete();
            }
            catch (IOException iOException) {}
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    public static int getData1(MidiMessage msg) {
        return ((ShortMessage)msg).getData1();
    }

    public static MidiMessage setData1(MidiMessage msg, int data1) throws InvalidMidiDataException {
        if (msg.getLength() == 1) {
            throw new InvalidMidiDataException("Can't setData1 on 1 byte message");
        }
        ((ShortMessage)msg).setMessage(ShortMsg.getStatus(msg), data1, ShortMsg.getData2(msg));
        return msg;
    }

    public static int getData2(MidiMessage msg) {
        return ((ShortMessage)msg).getData2();
    }

    public static MidiMessage setData2(MidiMessage msg, int data2) throws InvalidMidiDataException {
        if (msg.getLength() != 3) {
            throw new InvalidMidiDataException("Can't setData2 on " + msg.getLength() + " byte message");
        }
        ((ShortMessage)msg).setMessage(ShortMsg.getStatus(msg), ShortMsg.getData1(msg), data2);
        return msg;
    }

    public static int getData1and2(MidiMessage msg) {
        return ShortMsg.getData1and2(ShortMsg.getData1(msg), ShortMsg.getData2(msg));
    }

    public static int getData1and2(int data1, int data2) {
        return data1 & 0x3F | data2 << 7;
    }
}

