/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.message;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import uk.org.toot.midi.message.ShortMsg;

public class RealTimeMsg
extends ShortMsg {
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    private static final int N = 7;
    private static final int BASE = 248;
    private static MidiMessage[] messages = new MidiMessage[7];

    static {
        int i = 0;
        while (i < 7) {
            try {
                RealTimeMsg.messages[i] = RealTimeMsg.createShort(248 + i);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static boolean isRealTime(MidiMessage msg) {
        return RealTimeMsg.isRealTime(RealTimeMsg.getStatus(msg));
    }

    public static boolean isRealTime(int status) {
        return RealTimeMsg.isShort(status) && status >= 248 && status < 255;
    }

    public static MidiMessage createRealTime(int status) throws InvalidMidiDataException {
        int i = status - 248;
        if (i >= 0 && i < messages.length) {
            return messages[i];
        }
        throw new InvalidMidiDataException(String.valueOf(status) + " is NOT a RealTimeMsg");
    }
}

