/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.message;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import uk.org.toot.midi.message.MidiMsg;

public class MetaMsg
extends MidiMsg {
    public static final int META = 255;
    public static final int SEQUENCE_NUMBER = 0;
    public static final int TEXT = 1;
    public static final int COPYRIGHT = 2;
    public static final int TRACK_NAME = 3;
    public static final int INSTRUMENT_NAME = 4;
    public static final int LYRIC = 5;
    public static final int MARKER = 6;
    public static final int CUE_POINT = 7;
    public static final int DEVICE_NAME = 9;
    public static final int CHANNEL_PREFIX = 32;
    public static final int PORT_PREFIX = 33;
    public static final int END_OF_TRACK = 47;
    public static final int TEMPO = 81;
    public static final int SMPTE_OFFSET = 84;
    public static final int TIME_SIGNATURE = 88;
    public static final int MAJOR_MINOR_KEY = 89;
    public static final int SEQUENCER_SPECIFIC = 127;

    public static boolean isMeta(MidiMessage msg) {
        return MetaMsg.isMeta(MetaMsg.getStatus(msg));
    }

    public static boolean isMeta(int status) {
        return status == 255;
    }

    public static MidiMessage createMeta(int type, byte[] data, int length) throws InvalidMidiDataException {
        MetaMessage msg = new MetaMessage();
        msg.setMessage(type, data, length);
        return msg;
    }

    public static MidiMessage createMeta(int type, String name) throws InvalidMidiDataException {
        byte[] bytes = name.getBytes();
        return MetaMsg.createMeta(type, bytes, bytes.length);
    }

    public static MidiMessage createTempo(float bpm) throws InvalidMidiDataException {
        byte[] bytes = MetaMsg.tempoBytes(bpm);
        return MetaMsg.createMeta(81, bytes, bytes.length);
    }

    public static String getString(MidiMessage msg) {
        byte[] abData = MetaMsg.getData(msg);
        int type = MetaMsg.getType(msg);
        if (type == 84) {
            return String.valueOf(abData[0] & 0x1F) + ":" + (abData[1] & 0xFF) + ":" + (abData[2] & 0xFF) + "." + (abData[3] & 0xFF) + "." + (abData[4] & 0xFF) + "   [" + ((abData[0] & 0x60) >> 5) + "]";
        }
        if (type == 88) {
            return String.valueOf(abData[0] & 0xFF) + "/" + (1 << (abData[1] & 0xFF));
        }
        if (type == 32 || type == 33) {
            return String.valueOf(1 + (abData[0] & 0xF));
        }
        if (type == 81) {
            float bpm = MetaMsg.getTempo(msg);
            bpm = (float)Math.round(bpm * 100.0f) / 100.0f;
            return String.valueOf(bpm);
        }
        if (type == 47 || type == 89) {
            return "";
        }
        return new String(abData);
    }

    public static MidiMessage setString(MidiMessage msg, String str) throws InvalidMidiDataException {
        byte[] bytes = str.getBytes();
        return MetaMsg.setData(msg, bytes, bytes.length);
    }

    public static float convertTempo(float value) {
        if (value <= 0.0f) {
            value = 0.1f;
        }
        return 6.0E7f / value;
    }

    public static float getTempo(MidiMessage msg) {
        if (MetaMsg.getType(msg) == 81) {
            byte[] abData = MetaMsg.getData(msg);
            int nTempo = (abData[0] & 0xFF) << 16 | (abData[1] & 0xFF) << 8 | abData[2] & 0xFF;
            return MetaMsg.convertTempo(nTempo);
        }
        return 0.0f;
    }

    public static MidiMessage setTempo(MidiMessage msg, float bpm) throws InvalidMidiDataException {
        if (MetaMsg.getType(msg) == 81) {
            byte[] bytes = MetaMsg.tempoBytes(bpm);
            return MetaMsg.setData(msg, bytes, bytes.length);
        }
        return null;
    }

    public static byte[] tempoBytes(float bpm) {
        int mpqn = (int)MetaMsg.convertTempo(bpm);
        byte[] bytes = new byte[3];
        bytes[2] = (byte)(mpqn & 0xFF);
        bytes[1] = (byte)(mpqn >> 8 & 0xFF);
        bytes[0] = (byte)(mpqn >> 16 & 0xFF);
        return bytes;
    }

    public static int getType(MidiMessage msg) {
        return ((MetaMessage)msg).getType();
    }

    public static byte[] getData(MidiMessage msg) {
        return ((MetaMessage)msg).getData();
    }

    public static MidiMessage setData(MidiMessage msg, byte[] data, int length) throws InvalidMidiDataException {
        ((MetaMessage)msg).setMessage(MetaMsg.getType(msg), data, length);
        return msg;
    }
}

