/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.message;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import uk.org.toot.midi.message.UniversalSysexMsg;

public class MachineControlMsg
extends UniversalSysexMsg {
    public static final int MMC = 6;
    public static final int STOP = 1;
    public static final int PLAY = 2;
    public static final int PLAY_DEFERRED = 3;
    public static final int FAST_FORWARD = 4;
    public static final int REWIND = 5;
    public static final int PUNCH_IN = 6;
    public static final int PUNCH_OUT = 7;
    public static final int PAUSE = 9;

    public static boolean isMachineControl(MidiMessage msg) {
        return MachineControlMsg.isMachineControl(MachineControlMsg.getMessage(msg));
    }

    public static boolean isMachineControl(byte[] data) {
        return data[0] == 240 && data[1] == 127 && data[3] == 6;
    }

    public static MidiMessage createMachineControl(int cmd) throws InvalidMidiDataException {
        return MachineControlMsg.createMachineControl(127, cmd);
    }

    public static MidiMessage createMachineControl(int deviceid, int cmd) throws InvalidMidiDataException {
        byte[] data = new byte[6];
        MachineControlMsg.createUniversalHeader(data, 127, deviceid, 6, cmd);
        data[5] = -9;
        return MachineControlMsg.createSysex(data, 6);
    }

    public static int getDeviceId(MidiMessage msg) {
        return MachineControlMsg.getChannel(msg);
    }

    public static int getCommand(MidiMessage msg) {
        return MachineControlMsg.getSubId2(msg);
    }
}

