/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.message;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import uk.org.toot.midi.message.ShortMsg;

public class ChannelMsg
extends ShortMsg {
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;

    public static boolean isChannel(MidiMessage msg) {
        return ChannelMsg.isChannel(ChannelMsg.getStatus(msg));
    }

    public static boolean isChannel(int status) {
        return status < 240;
    }

    public static MidiMessage createChannel(int status, int chan, int data1, int data2) throws InvalidMidiDataException {
        ShortMessage msg = (ShortMessage)fastShortPrototype.clone();
        msg.setMessage(status, chan, data1, data2);
        return msg;
    }

    public static MidiMessage createChannel(int status, int chan, int data1) throws InvalidMidiDataException {
        return ChannelMsg.createChannel(status, chan, data1, 0);
    }

    public static int getCommand(MidiMessage msg) {
        return ((ShortMessage)msg).getCommand();
    }

    public static int getCommand(int status) {
        return status & 0xF0;
    }

    public static int getChannel(MidiMessage msg) {
        return ((ShortMessage)msg).getChannel();
    }

    public static int getChannel(int status) {
        return status & 0xF;
    }

    public static MidiMessage setChannel(MidiMessage msg, int chan) throws InvalidMidiDataException {
        ((ShortMessage)msg).setMessage(ChannelMsg.getCommand(msg), chan, ChannelMsg.getData1(msg), ChannelMsg.getData2(msg));
        return msg;
    }

    public static int setChannel(int status, int chan) {
        return status & 0xF0 | chan & 0xF;
    }
}

