/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.core.channel;

import java.beans.PropertyChangeSupport;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import uk.org.toot.midi.core.MidiInput;
import uk.org.toot.midi.core.channel.DefaultMidiChannelReader;
import uk.org.toot.midi.core.channel.DefaultMidiChannelWriter;
import uk.org.toot.midi.core.channel.MidiChannelReader;
import uk.org.toot.midi.core.channel.MidiChannelReaderProvider;
import uk.org.toot.midi.core.channel.MidiChannelWriter;
import uk.org.toot.midi.core.channel.MidiChannelWriterProvider;
import uk.org.toot.midi.message.ChannelMsg;
import uk.org.toot.midi.message.ShortMsg;

public class ChannelReadWriteMidiInput
implements MidiInput,
MidiChannelReaderProvider,
MidiChannelWriterProvider {
    private MidiInput input;
    private MidiChannelReader[] decoders;
    private MidiChannelWriter[] encoders;
    private PropertyChangeSupport propertyChangeSupport;

    public ChannelReadWriteMidiInput(MidiInput input) throws MidiUnavailableException {
        this.input = input;
        this.decoders = new MidiChannelReader[16];
        this.encoders = new MidiChannelWriter[16];
        int i = 0;
        while (i < 16) {
            this.decoders[i] = this.createChannelReader(i);
            ++i;
        }
    }

    public MidiChannelReader getChannelReader(int chan) {
        return this.decoders[chan];
    }

    public MidiChannelWriter getChannelWriter(int chan) {
        if (this.encoders[chan] == null) {
            this.encoders[chan] = this.createChannelWriter(chan);
        }
        return this.encoders[chan];
    }

    protected MidiChannelReader createChannelReader(int chan) {
        return new DefaultMidiChannelReader(chan);
    }

    protected MidiChannelWriter createChannelWriter(int chan) {
        return new DefaultMidiChannelWriter(this, chan);
    }

    public void transport(MidiMessage msg, long timestamp) {
        if (ChannelMsg.isChannel(msg)) {
            int chan = ChannelMsg.getChannel(msg);
            this.decoders[chan].decode(ChannelMsg.getCommand(msg), ShortMsg.getData1(msg), ShortMsg.getData2(msg));
        }
        this.input.transport(msg, timestamp);
    }

    public String getName() {
        return this.input.getName();
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public void firePropertyChange(String property, int index, int oldVal, int newVal) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.fireIndexedPropertyChange(property, index, oldVal, newVal);
        }
    }
}

