/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import uk.org.toot.midi.core.MidiDevice;
import uk.org.toot.midi.core.MidiSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMidiSystem
extends Observable
implements MidiSystem {
    private List<MidiDevice> devices = new ArrayList<MidiDevice>();
    private Observer observer = new Observer(){

        public void update(Observable arg0, Object arg1) {
            DefaultMidiSystem.this.setChanged();
            DefaultMidiSystem.this.notifyObservers();
        }
    };

    @Override
    public void addMidiDevice(MidiDevice device) {
        this.devices.add(device);
        this.setChanged();
        this.notifyObservers();
        device.addObserver(this.observer);
    }

    @Override
    public void removeMidiDevice(MidiDevice device) {
        device.deleteObserver(this.observer);
        this.devices.remove(device);
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public List<MidiDevice> getMidiDevices() {
        return Collections.unmodifiableList(this.devices);
    }
}

