/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.debug;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class JMXDebug {
    private ThreadMXBean mxbean = ManagementFactory.getThreadMXBean();
    private long maxcpums = 0L;

    public JMXDebug() {
        if (!this.mxbean.isThreadCpuTimeSupported()) {
            System.out.println("Thread CPU Time is NOT supported");
        } else {
            if (!this.mxbean.isThreadCpuTimeEnabled()) {
                this.mxbean.setThreadCpuTimeEnabled(true);
            }
            if (this.mxbean.isThreadContentionMonitoringSupported()) {
                if (!this.mxbean.isThreadContentionMonitoringEnabled()) {
                    this.mxbean.setThreadContentionMonitoringEnabled(true);
                }
            } else {
                System.out.println("Thread Contention Monitoring is NOT supported");
            }
            this.top();
        }
    }

    protected void top() {
        while (true) {
            try {
                while (true) {
                    this._top();
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected void _top() {
        long[] ids = this.mxbean.getAllThreadIds();
        int i = 0;
        while (i < ids.length) {
            int cpums = (int)(this.mxbean.getThreadCpuTime(ids[i]) / 1000000L);
            if ((long)cpums >= this.maxcpums / 100L) {
                if ((long)cpums > this.maxcpums) {
                    this.maxcpums = cpums;
                }
                ThreadInfo info = this.mxbean.getThreadInfo(ids[i]);
                String name = info.getThreadName();
                System.out.println(String.valueOf(cpums) + " " + info.getBlockedTime() + " " + info.getWaitedTime() + " " + name);
            }
            ++i;
        }
    }
}

