/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import uk.org.toot.control.AbstractLaw;

public class LogLaw
extends AbstractLaw {
    private double logMin;
    private double logMax;
    private double logSpan;

    public LogLaw(float min, float max, String units) {
        super(min, max, units);
        this.logMin = Math.log10(min);
        this.logMax = Math.log10(max);
        this.logSpan = this.logMax - this.logMin;
    }

    public int intValue(float userVal) {
        if (userVal == 0.0f) {
            userVal = 1.0f;
        }
        return (int)(1023.0 * (Math.log10(userVal) - this.logMin) / this.logSpan);
    }

    public float userValue(int intVal) {
        double p = this.logMin + this.logSpan * (double)intVal / 1023.0;
        return (float)Math.pow(10.0, p);
    }

    public static void main(String[] args) {
        LogLaw law = new LogLaw(20.0f, 20000.0f, "Hz");
        System.out.println("   20 Hz => " + law.intValue(20.0f) + " => " + law.userValue(law.intValue(20.0f)));
        System.out.println("  200 Hz => " + law.intValue(200.0f) + " => " + law.userValue(law.intValue(200.0f)));
        System.out.println(" 2000 Hz => " + law.intValue(2000.0f) + " => " + law.userValue(law.intValue(2000.0f)));
        System.out.println("20000 Hz => " + law.intValue(20000.0f) + " => " + law.userValue(law.intValue(20000.0f)));
    }
}

