/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import java.awt.Color;
import uk.org.toot.control.Control;
import uk.org.toot.localisation.Localisation;

public class BooleanControl
extends Control {
    private final String trueStateLabel;
    private final String falseStateLabel;
    private Color[] stateColor = new Color[]{Color.white, Color.white};
    private boolean momentary = false;
    private boolean value;

    public BooleanControl(int id, String name, boolean initialValue, String trueStateLabel, String falseStateLabel) {
        super(id, name);
        this.value = initialValue;
        this.trueStateLabel = trueStateLabel;
        this.falseStateLabel = falseStateLabel;
    }

    public BooleanControl(int id, String name, boolean initialValue) {
        this(id, name, initialValue, Localisation.getString("On"), Localisation.getString("Off"));
    }

    public BooleanControl(int id, String name, boolean initialValue, boolean momentary) {
        this(id, name, initialValue);
        this.momentary = momentary;
    }

    public boolean isMomentary() {
        return this.momentary;
    }

    public void setValue(boolean value) {
        if (value != this.value) {
            this.value = value;
            this.notifyParent(this);
        }
    }

    public void momentaryAction() {
    }

    public boolean getValue() {
        return this.value;
    }

    public void setStateColor(boolean state, Color color) {
        this.stateColor[state ? 1 : 0] = color;
    }

    public Color getStateColor(boolean state) {
        return this.stateColor[state ? 1 : 0];
    }

    public String getStateLabel(boolean state) {
        return state ? this.trueStateLabel : this.falseStateLabel;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " with current value: " + this.getStateLabel(this.getValue());
    }

    public String getValueString() {
        return this.isMomentary() ? "" : this.getStateLabel(this.getValue());
    }

    public void setIntValue(int value) {
        this.setValue(value != 0);
    }

    public int getIntValue() {
        return this.getValue() ? 1 : 0;
    }

    public boolean isWidthLimited() {
        return true;
    }
}

