/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.tool;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.FloatDenormals;
import uk.org.toot.audio.core.SimpleAudioProcess;
import uk.org.toot.audio.tool.DenormalControls;

public class DenormalProcess
extends SimpleAudioProcess {
    public static final int COUNT = 0;
    public static final int DAZ = 1;
    private DenormalControls controls;
    private int mode = 0;

    public DenormalProcess(DenormalControls c) {
        this.controls = c;
    }

    public int processAudio(AudioBuffer buffer) {
        if (this.controls.isBypassed()) {
            return 0;
        }
        switch (this.mode) {
            case 0: {
                return this.countDenormals(buffer);
            }
            case 1: {
                return this.zeroDenormals(buffer);
            }
        }
        return 0;
    }

    protected int countDenormals(AudioBuffer buffer) {
        int ns = buffer.getSampleCount();
        int nc = buffer.getChannelCount();
        int count = 0;
        int c = 0;
        while (c < nc) {
            count += FloatDenormals.countDenorms(buffer.getChannel(c), ns);
            ++c;
        }
        return 0;
    }

    protected int zeroDenormals(AudioBuffer buffer) {
        int ns = buffer.getSampleCount();
        int nc = buffer.getChannelCount();
        int c = 0;
        while (c < nc) {
            FloatDenormals.zeroDenorms(buffer.getChannel(c), ns);
            ++c;
        }
        return 0;
    }
}

